/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.changes.MoveResourceChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.core.libfolders.RenameLibraryFolderChange;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.core.util.collections.BucketMap;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.changes.ProgramFileChange;
import org.eclipse.php.refactoring.core.changes.RenameBreackpointChange;
import org.eclipse.php.refactoring.core.changes.RenameBuildAndIcludePathChange;
import org.eclipse.php.refactoring.core.changes.RenameConfigurationChange;
import org.eclipse.php.refactoring.core.move.ChangeIncludePath;
import org.eclipse.php.refactoring.core.move.MoveUtils;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.eclipse.php.refactoring.core.utils.ASTUtils;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class MoveDelegate {
    private PHPMoveProcessor fProcessor;
    private IPath fMainDestinationPath;
    private Set<IFile> phpFiles;
    private BucketMap<IResource, IBreakpoint> fBreakpoints;
    private HashMap<IBreakpoint, Map<String, Object>> fBreakpointAttributes;
    private List<IBuildpathEntry> oldBuildEntries;
    private ArrayList<IBuildpathEntry> newBuildEntries;
    private ArrayList<IBuildpathEntry> newIncludePathEntries;
    private ArrayList<IBuildpathEntry> oldIncludePath;

    public MoveDelegate(PHPMoveProcessor processor) {
        this.fProcessor = processor;
    }

    public RefactoringStatus checkInitialConditions() throws OperationCanceledException {
        IResource[] sourceResources = this.fProcessor.getSourceSelection();
        this.phpFiles = new HashSet<IFile>();
        MoveUtils.getAllPHPFiles(sourceResources, this.phpFiles);
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions() throws OperationCanceledException {
        IResource[] sourceResources;
        IProject destinationProject;
        RefactoringStatus status = new RefactoringStatus();
        IContainer destination = this.fProcessor.getDestination();
        IProject sourceProject = this.fProcessor.getSourceSelection()[0].getProject();
        if (sourceProject != (destinationProject = destination.getProject())) {
            status.merge(MoveUtils.checkMove(this.phpFiles, sourceProject, destination));
        }
        IPath dest = this.fProcessor.getDestination().getFullPath();
        IResource[] iResourceArray = sourceResources = this.fProcessor.getSourceSelection();
        int n = sourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            String newFilePath = String.valueOf(dest.toOSString()) + File.separatorChar + element.getName();
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(newFilePath));
            if (resource != null && resource.exists()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)PhpRefactoringCoreMessages.getString("MoveDelegate.6"), (Object)element.getName(), (Object)dest.toOSString())));
            }
            ++n2;
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm, CompositeChange rootChange) throws CoreException, OperationCanceledException {
        this.fMainDestinationPath = this.fProcessor.getDestination().getFullPath();
        this.fProcessor.getSourceSelection();
        if (!this.fProcessor.getUpdateReferences()) {
            return this.createSimpleMoveChange(pm, rootChange);
        }
        return this.createReferenceUpdatingMoveChange(pm, rootChange);
    }

    private Change createSimpleMoveChange(IProgressMonitor pm, CompositeChange rootChange) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(PhpRefactoringCoreMessages.getString("MoveDelegate.0"), 100);
            IResource[] sourceResources = this.fProcessor.getSourceSelection();
            this.createMoveChange(sourceResources, rootChange);
            pm.worked(100);
        }
        finally {
            pm.done();
        }
        return rootChange;
    }

    private Change createReferenceUpdatingMoveChange(IProgressMonitor pm, CompositeChange rootChange) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(PhpRefactoringCoreMessages.getString("MoveDelegate.0"), 100);
            IResource[] sourceResources = this.fProcessor.getSourceSelection();
            this.createTextChanges((IProgressMonitor)new SubProgressMonitor(pm, 80), rootChange, this.phpFiles, sourceResources);
            pm.worked(80);
            this.createRunConfigurationChange(sourceResources, rootChange);
            this.createMoveChange(sourceResources, rootChange);
            this.createBreakPointChange(sourceResources, rootChange);
            this.createBuildPathChange(sourceResources, rootChange);
            this.createRenameLibraryFolderChange(sourceResources, rootChange);
            pm.worked(20);
        }
        finally {
            pm.done();
        }
        return rootChange;
    }

    private void createRenameLibraryFolderChange(IResource[] sourceResources, CompositeChange rootChange) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        LibraryFolderManager lfm = LibraryFolderManager.getInstance();
        IResource[] iResourceArray = sourceResources;
        int n = sourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 2 && lfm.isInLibraryFolder(resource)) {
                IPath newPath = this.fMainDestinationPath.append(resource.getName());
                IFolder newFolder = root.getFolder(newPath);
                RenameLibraryFolderChange change = new RenameLibraryFolderChange((IFolder)resource, newFolder);
                rootChange.add((Change)change);
            }
            ++n2;
        }
    }

    private void createBuildPathChange(IResource[] sourceResources, CompositeChange rootChange) throws ModelException {
        IResource[] uniqueSourceResources;
        IResource[] iResourceArray = uniqueSourceResources = this.removeDuplicateResources(sourceResources);
        int n = uniqueSourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            if (element instanceof IContainer) {
                IProject project = element.getProject();
                if (RefactoringUtility.getResource(this.fMainDestinationPath).getProject() != project) {
                    this.removeBuildPath(element, project);
                    IPath path = element.getFullPath().removeLastSegments(1);
                    RenameBuildAndIcludePathChange biChange = new RenameBuildAndIcludePathChange(path, path, element.getName(), "", this.oldBuildEntries, this.newBuildEntries, this.oldIncludePath, this.newIncludePathEntries);
                    if (this.newBuildEntries.size() > 0 || this.newIncludePathEntries.size() > 0) {
                        rootChange.add((Change)biChange);
                    }
                } else {
                    this.updateBuildPath(element, project);
                    RenameBuildAndIcludePathChange biChange = new RenameBuildAndIcludePathChange(element.getFullPath().removeLastSegments(1), this.fMainDestinationPath, element.getName(), element.getName(), this.oldBuildEntries, this.newBuildEntries, this.oldIncludePath, this.newIncludePathEntries);
                    if (this.newBuildEntries.size() > 0 || this.newIncludePathEntries.size() > 0) {
                        rootChange.add((Change)biChange);
                    }
                }
            }
            ++n2;
        }
    }

    private void removeBuildPath(IResource resource, IProject project) {
        IScriptProject projrct = DLTKCore.create((IProject)project);
        IPath filePath = resource.getFullPath();
        this.oldBuildEntries = Arrays.asList(projrct.readRawBuildpath());
        this.newBuildEntries = new ArrayList();
        this.newBuildEntries.addAll(this.oldBuildEntries);
        int i = 0;
        while (i < this.oldBuildEntries.size()) {
            IBuildpathEntry fEntryToChange = this.oldBuildEntries.get(i);
            IPath entryPath = fEntryToChange.getPath();
            int mattchedPath = entryPath.matchingFirstSegments(filePath);
            if (mattchedPath == filePath.segmentCount()) {
                this.newBuildEntries.remove(fEntryToChange);
            } else {
                IBuildpathEntry newEntry = RefactoringUtility.createNewBuildpathEntry(fEntryToChange, fEntryToChange.getPath(), filePath, "");
                this.newBuildEntries.remove(fEntryToChange);
                this.newBuildEntries.add(newEntry);
            }
            ++i;
        }
        this.oldIncludePath = new ArrayList();
        this.newIncludePathEntries = new ArrayList();
        List<IncludePath> includePathEntries = Arrays.asList(IncludePathManager.getInstance().getIncludePaths(project));
        for (IncludePath entry : includePathEntries) {
            Object includePathEntry = entry.getEntry();
            IResource includeResource = null;
            if (!(includePathEntry instanceof IBuildpathEntry)) {
                includeResource = (IResource)includePathEntry;
                IPath entryPath = includeResource.getFullPath();
                IBuildpathEntry oldEntry = RefactoringUtility.createNewBuildpathEntry(3, entryPath);
                this.oldIncludePath.add(oldEntry);
                if (filePath.isPrefixOf(entryPath) || entryPath.equals((Object)filePath)) continue;
                IBuildpathEntry newEntry = RefactoringUtility.createNewBuildpathEntry(3, entryPath);
                this.newIncludePathEntries.add(newEntry);
                continue;
            }
            this.newIncludePathEntries.add((IBuildpathEntry)includePathEntry);
            this.oldIncludePath.add((IBuildpathEntry)includePathEntry);
        }
    }

    private void updateBuildPath(IResource resource, IProject project) {
        String newElementName = resource.getName();
        IScriptProject projrct = DLTKCore.create((IProject)project);
        IPath filePath = resource.getFullPath();
        this.oldBuildEntries = Arrays.asList(projrct.readRawBuildpath());
        this.newBuildEntries = new ArrayList();
        this.newBuildEntries.addAll(this.oldBuildEntries);
        int i = 0;
        while (i < this.oldBuildEntries.size()) {
            IBuildpathEntry fEntryToChange = this.oldBuildEntries.get(i);
            IPath entryPath = fEntryToChange.getPath();
            int mattchedPath = entryPath.matchingFirstSegments(filePath);
            if (mattchedPath == filePath.segmentCount()) {
                this.newBuildEntries.remove(fEntryToChange);
            } else {
                IBuildpathEntry newEntry = RefactoringUtility.createNewBuildpathEntry(fEntryToChange, fEntryToChange.getPath(), filePath, "");
                this.newBuildEntries.remove(fEntryToChange);
                this.newBuildEntries.add(newEntry);
            }
            ++i;
        }
        this.oldIncludePath = new ArrayList();
        this.newIncludePathEntries = new ArrayList();
        List<IncludePath> includePathEntries = Arrays.asList(IncludePathManager.getInstance().getIncludePaths(project));
        for (IncludePath entry : includePathEntries) {
            Object includePathEntry = entry.getEntry();
            IResource includeResource = null;
            if (!(includePathEntry instanceof IBuildpathEntry)) {
                includeResource = (IResource)includePathEntry;
                IPath entryPath = includeResource.getFullPath();
                IBuildpathEntry oldEntry = RefactoringUtility.createNewBuildpathEntry(3, entryPath);
                this.oldIncludePath.add(oldEntry);
                if (filePath.isPrefixOf(entryPath) || entryPath.equals((Object)filePath)) {
                    int mattchedPath = entryPath.matchingFirstSegments(filePath);
                    IPath truncatedPath = entryPath.uptoSegment(mattchedPath);
                    IPath remaingPath = entryPath.removeFirstSegments(mattchedPath);
                    IPath newPath = mattchedPath == filePath.segmentCount() ? truncatedPath.removeLastSegments(1).append(newElementName).append(remaingPath) : truncatedPath.append(newElementName).append(remaingPath);
                    IBuildpathEntry newEntry = RefactoringUtility.createNewBuildpathEntry(3, newPath);
                    this.newIncludePathEntries.add(newEntry);
                    continue;
                }
                IBuildpathEntry newEntry = RefactoringUtility.createNewBuildpathEntry(3, entryPath);
                this.newIncludePathEntries.add(newEntry);
                continue;
            }
            this.newIncludePathEntries.add((IBuildpathEntry)includePathEntry);
            this.oldIncludePath.add((IBuildpathEntry)includePathEntry);
        }
    }

    private void createBreakPointChange(IResource[] sourceResources, CompositeChange rootChange) throws CoreException {
        IResource[] uniqueSourceResources;
        IResource[] iResourceArray = uniqueSourceResources = this.removeDuplicateResources(sourceResources);
        int n = uniqueSourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            this.collectBrakePoint(element);
            RenameBreackpointChange breakePointchanges = new RenameBreackpointChange(element.getFullPath().removeLastSegments(1), this.fMainDestinationPath, element.getName(), element.getName(), this.fBreakpoints, this.fBreakpointAttributes);
            if (this.fBreakpoints.getKeys().size() > 0) {
                rootChange.add((Change)breakePointchanges);
            }
            ++n2;
        }
    }

    protected void collectBrakePoint(IResource resource) throws CoreException {
        IMarker[] markers;
        this.fBreakpoints = new BucketMap(6);
        this.fBreakpointAttributes = new HashMap(6);
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IMarker[] iMarkerArray = markers = resource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            IResource markerResource = marker.getResource();
            IBreakpoint breakpoint = breakpointManager.getBreakpoint(marker);
            if (breakpoint != null) {
                this.fBreakpoints.add((Object)markerResource, (Object)breakpoint);
                this.fBreakpointAttributes.put(breakpoint, breakpoint.getMarker().getAttributes());
            }
            ++n2;
        }
    }

    private void createRunConfigurationChange(IResource[] sourceResources, CompositeChange rootChange) {
        IResource[] uniqueSourceResources;
        IResource[] iResourceArray = uniqueSourceResources = this.removeDuplicateResources(sourceResources);
        int n = uniqueSourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            RenameConfigurationChange configPointchanges = new RenameConfigurationChange(element.getFullPath().removeLastSegments(1), this.fMainDestinationPath, element.getName(), element.getName());
            rootChange.add((Change)configPointchanges);
            ++n2;
        }
    }

    private Change createTextChanges(IProgressMonitor pm, CompositeChange rootChange, Set<IFile> phpFiles, IResource[] sourceResources) throws CoreException {
        ArrayList<ProgramFileChange> changes = new ArrayList<ProgramFileChange>();
        try {
            pm.beginTask(PhpRefactoringCoreMessages.getString("MoveDelegate.1"), 100);
            IResource[] uniqueSourceResources = this.removeDuplicateResources(sourceResources);
            for (IFile currentMovedResource : phpFiles) {
                Map<IFile, Program> participantFiles = this.collectReferencingFiles(currentMovedResource, pm);
                for (Map.Entry<IFile, Program> entry : participantFiles.entrySet()) {
                    IFile file = entry.getKey();
                    if (phpFiles.contains(file)) continue;
                    Program program = entry.getValue();
                    ChangeIncludePath rename = new ChangeIncludePath(currentMovedResource, file, this.fMainDestinationPath, false, uniqueSourceResources);
                    program.accept((Visitor)rename);
                    if (pm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    pm.worked(1);
                    if (!rename.hasChanges()) continue;
                    ProgramFileChange change = new ProgramFileChange(file.getName(), file, program);
                    change.setEdit((TextEdit)new MultiTextEdit());
                    change.setTextType("php");
                    changes.add(change);
                    rename.updateChange(change);
                }
                ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)currentMovedResource);
                if (!(sourceModule instanceof ISourceModule)) continue;
                Program program = null;
                try {
                    program = ASTUtils.createProgramFromSource(sourceModule);
                }
                catch (Exception file) {
                    // empty catch block
                }
                if (program == null) continue;
                ChangeIncludePath rename = new ChangeIncludePath(currentMovedResource, currentMovedResource, this.fMainDestinationPath, true, uniqueSourceResources);
                program.accept((Visitor)rename);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                pm.worked(1);
                if (!rename.hasChanges()) continue;
                ProgramFileChange change = new ProgramFileChange(currentMovedResource.getName(), currentMovedResource, program);
                change.setEdit((TextEdit)new MultiTextEdit());
                change.setTextType("php");
                changes.add(change);
                rename.updateChange(change);
            }
            pm.worked(70);
        }
        finally {
            pm.done();
        }
        HashMap<IFile, ArrayList<TextEdit>> changeMap = new HashMap<IFile, ArrayList<TextEdit>>();
        HashMap<IFile, ProgramFileChange> fileMap = new HashMap<IFile, ProgramFileChange>();
        for (ProgramFileChange programFileChange : changes) {
            ArrayList<TextEdit> list = (ArrayList<TextEdit>)changeMap.get(programFileChange.getFile());
            if (list == null) {
                list = new ArrayList<TextEdit>();
                changeMap.put(programFileChange.getFile(), list);
                fileMap.put(programFileChange.getFile(), programFileChange);
            }
            list.addAll(Arrays.asList(programFileChange.getEdit().getChildren()));
        }
        for (IFile file : changeMap.keySet()) {
            ProgramFileChange change = new ProgramFileChange(file.getName(), file, ((ProgramFileChange)((Object)fileMap.get(file))).getProgram());
            change.setEdit((TextEdit)new MultiTextEdit());
            change.setTextType("php");
            List list = (List)changeMap.get(file);
            Collections.sort(list, new Comparator<TextEdit>(){

                @Override
                public int compare(TextEdit o1, TextEdit o2) {
                    return o2.getOffset() - o1.getOffset();
                }
            });
            for (TextEdit textEdit : list) {
                if (!(textEdit instanceof ReplaceEdit)) continue;
                ReplaceEdit replaceEdit = (ReplaceEdit)textEdit;
                change.addEdit((TextEdit)new ReplaceEdit(replaceEdit.getOffset(), replaceEdit.getLength(), replaceEdit.getText()));
            }
            rootChange.add((Change)change);
        }
        return rootChange;
    }

    private IResource[] removeDuplicateResources(IResource[] sourceResources) {
        if (sourceResources == null || sourceResources.length == 0) {
            return sourceResources;
        }
        ArrayList<IResource> result = new ArrayList<IResource>();
        IResource[] iResourceArray = sourceResources;
        int n = sourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource source = iResourceArray[n2];
            if (result.size() == 0) {
                result.add(source);
            } else {
                for (IResource existing : result) {
                    if (!source.getFullPath().isPrefixOf(existing.getFullPath())) continue;
                    result.remove(existing);
                    result.add(source);
                }
                boolean noNeedAdded = false;
                for (IResource existing : result) {
                    if (!existing.getFullPath().isPrefixOf(source.getFullPath())) continue;
                    noNeedAdded = true;
                }
                if (!result.contains(source) && !noNeedAdded) {
                    result.add(source);
                }
            }
            ++n2;
        }
        IResource[] ret = new IResource[result.size()];
        return result.toArray(ret);
    }

    private void createMoveChange(IResource[] sourceResources, CompositeChange rootChange) {
        IResource[] uniqueSourceResources;
        IResource[] iResourceArray = uniqueSourceResources = this.removeDuplicateResources(sourceResources);
        int n = uniqueSourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            MoveResourceChange moveResource = new MoveResourceChange(element, this.fProcessor.getDestination());
            rootChange.add((Change)moveResource);
            ++n2;
        }
    }

    public RefactoringStatus verifyDestination(IResource destination) {
        IResource[] sourceResources;
        RefactoringStatus status = new RefactoringStatus();
        Assert.isNotNull((Object)destination);
        if (!destination.exists() || destination.isPhantom()) {
            return RefactoringStatus.createFatalErrorStatus((String)PhpRefactoringCoreMessages.getString("MoveDelegate.2"));
        }
        if (!destination.isAccessible()) {
            return RefactoringStatus.createFatalErrorStatus((String)PhpRefactoringCoreMessages.getString("MoveDelegate.3"));
        }
        Assert.isTrue((destination.getType() != 8 ? 1 : 0) != 0);
        IResource[] iResourceArray = sourceResources = this.fProcessor.getSourceSelection();
        int n = sourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            if (destination.equals((Object)element.getParent())) {
                return RefactoringStatus.createFatalErrorStatus((String)PhpRefactoringCoreMessages.getString("MoveDelegate.4"));
            }
            if (destination.equals((Object)element)) {
                return RefactoringStatus.createFatalErrorStatus((String)PhpRefactoringCoreMessages.getString("MoveDelegate.5"));
            }
            ++n2;
        }
        return status;
    }

    private Map<IFile, Program> collectReferencingFiles(IFile sourceFile, IProgressMonitor pm) {
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)sourceFile);
        HashMap<IFile, Program> participantFiles = new HashMap<IFile, Program>();
        Collection<ReferenceTree.Node> references = MoveUtils.getReferencingFiles(sourceModule);
        if (references != null) {
            for (ReferenceTree.Node node : references) {
                IFile file = (IFile)node.getFile().getResource();
                try {
                    participantFiles.put(file, RefactoringUtility.getProgramForFile(file));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return participantFiles;
    }
}

