/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.AbstractRenameProcessor;
import org.eclipse.php.refactoring.core.rename.ITextUpdating;
import org.eclipse.php.refactoring.core.rename.logic.RenameClass;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;

public class RenameClassProcessor
extends AbstractRenameProcessor<IFile>
implements ITextUpdating {
    public static final String RENAME_IS_PROCESSING = PhpRefactoringCoreMessages.getString("RenameClassNameProcessor.0");
    public static final String CREATING_MODIFICATIONS_LABEL = PhpRefactoringCoreMessages.getString("RenameClassNameProcessor.1");
    private static final String CLASS_IS_USED = PhpRefactoringCoreMessages.getString("RenameClassNameProcessor.2");
    private static final String ID_RENAME_CLASS = "php.refactoring.ui.rename.className";
    protected static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    public static final String RENAME_CLASS_PROCESSOR_NAME = PhpRefactoringCoreMessages.getString("RenameClassNameProcessor.3");
    private final ASTNode identifier;
    private boolean isUpdateTextualMatches;
    private IType[] types;

    public RenameClassProcessor(IFile operatedFile, ASTNode locateNode) {
        super(operatedFile);
        this.identifier = locateNode;
        IModelElement[] elements = null;
        try {
            elements = this.identifier.getProgramRoot().getSourceModule().codeSelect(this.getOffset(), 0);
        }
        catch (ModelException e) {
            elements = new IModelElement[]{};
        }
        this.types = this.getTypes(elements);
    }

    private IType[] getTypes(IModelElement[] elements) {
        if (elements == null) {
            return new IType[0];
        }
        ArrayList<IType> types = new ArrayList<IType>();
        int i = 0;
        while (i < elements.length) {
            IMethod method;
            if (elements[i] instanceof IType) {
                types.add((IType)elements[i]);
            } else if (elements[i] instanceof IMethod && (method = (IMethod)elements[i]).getElementName().equals(method.getDeclaringType().getElementName())) {
                types.add(method.getDeclaringType());
            }
            ++i;
        }
        return types.toArray(new IType[types.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange rootChange = new CompositeChange(PhpRefactoringCoreMessages.getString("RenameClassNameProcessor.4"));
        rootChange.markAsSynthetic();
        try {
            pm.beginTask(RENAME_IS_PROCESSING, this.participantFiles.size());
            pm.setTaskName(CREATING_MODIFICATIONS_LABEL);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            String newElementName = this.getNewElementName();
            for (Map.Entry entry : this.participantFiles.entrySet()) {
                IFile file = (IFile)entry.getKey();
                Program program = (Program)entry.getValue();
                RenameClass rename = new RenameClass(file, this.identifier, this.getCurrentElementName(), newElementName, this.getUpdateTextualMatches(), this.types);
                try {
                    program.accept((Visitor)rename);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                pm.worked(1);
                if (!rename.hasChanges()) continue;
                TextFileChange change = this.acquireChange(file, program);
                rename.updateChange(change);
                rootChange.add((Change)change);
            }
            CompositeChange compositeChange = rootChange;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.identifier};
    }

    public String getIdentifier() {
        return ID_RENAME_CLASS;
    }

    public String getProcessorName() {
        return RENAME_CLASS_PROCESSOR_NAME;
    }

    @Override
    public Object getNewElement() {
        return this.getNewElementName();
    }

    private int getOffset() {
        if (this.identifier instanceof Identifier) {
            return ((Identifier)this.identifier).getStart();
        }
        if (this.identifier instanceof ClassDeclaration) {
            return ((ClassDeclaration)this.identifier).getName().getStart();
        }
        if (this.identifier instanceof InterfaceDeclaration) {
            return ((InterfaceDeclaration)this.identifier).getName().getStart();
        }
        return this.identifier.getStart();
    }

    @Override
    public String getCurrentElementName() {
        if (this.identifier instanceof Identifier) {
            return ((Identifier)this.identifier).getName();
        }
        if (this.identifier instanceof ClassDeclaration) {
            return ((ClassDeclaration)this.identifier).getName().getName();
        }
        if (this.identifier instanceof InterfaceDeclaration) {
            return ((InterfaceDeclaration)this.identifier).getName().getName();
        }
        return this.identifier.toString();
    }

    @Override
    protected void collectReferences(Program program, IProgressMonitor pm) {
        final HashSet list = new HashSet();
        IScriptProject project = this.identifier.getProgramRoot().getSourceModule().getScriptProject();
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project, (int)RenameClassProcessor.getSearchFlags(false));
        SearchPattern pattern = null;
        int matchMode = 16;
        SearchEngine engine = new SearchEngine();
        pattern = SearchPattern.createPattern((String)this.getCurrentElementName(), (int)0, (int)2, (int)matchMode, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    IModelElement element = (IModelElement)match.getElement();
                    list.add(element.getResource());
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        for (IResource file : list) {
            if (!(file instanceof IFile)) continue;
            try {
                this.participantFiles.put((IFile)file, RefactoringUtility.getProgramForFile((IFile)file));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canEnableTextUpdating() {
        return true;
    }

    @Override
    public String getCurrentElementQualifier() {
        return this.getCurrentElementName();
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.isUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.isUpdateTextualMatches = update;
    }

    @Override
    public RefactoringStatus getRefactoringStatus(IFile key, Program program) {
        if (PhpElementConciliator.classNameAlreadyExists((Program)program, (String)this.getNewElementName())) {
            String message = MessageFormat.format(CLASS_IS_USED, key.getName());
            return RefactoringStatus.createWarningStatus((String)message);
        }
        return null;
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        String[] affectedNatures = ResourceProcessors.computeAffectedNatures((IResource)this.resource);
        RenameArguments fRenameArguments = new RenameArguments(this.getNewElementName(), false);
        LinkedList<RenameParticipant> participants = new LinkedList<RenameParticipant>(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.identifier, (RenameArguments)fRenameArguments, null, (String[])affectedNatures, (SharableParticipants)sharedParticipants)));
        IType[] iTypeArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            participants.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)type, (RenameArguments)fRenameArguments, null, (String[])affectedNatures, (SharableParticipants)sharedParticipants)));
            ++n2;
        }
        return participants.toArray(new RefactoringParticipant[participants.size()]);
    }
}

