/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.visitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.corext.SourceRange;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.rewrite.TokenScanner;
import org.eclipse.php.internal.core.corext.dom.Selection;
import org.eclipse.php.internal.core.corext.dom.SelectionAnalyzer;
import org.eclipse.php.refactoring.core.SourceModuleSourceContext;

public class StatementAnalyzer
extends SelectionAnalyzer {
    protected Program fCUnit;
    private IDocument fDocument;
    private ISourceModule fFile;
    private TokenScanner fScanner;
    private RefactoringStatus fStatus;

    public StatementAnalyzer(Program cunit, ISourceModule sourceModule, IDocument document, Selection selection, boolean traverseSelectedNode) throws CoreException, IOException {
        super(selection, traverseSelectedNode);
        Assert.isNotNull((Object)cunit);
        this.fCUnit = cunit;
        this.fDocument = document;
        this.fFile = sourceModule;
        this.fStatus = new RefactoringStatus();
        this.fScanner = new TokenScanner(this.fCUnit.getAST().lexer(), document.get().toCharArray());
    }

    protected void checkSelectedNodes() {
        int selectionOffset;
        ASTNode node;
        block7: {
            ASTNode[] nodes = this.getSelectedNodes();
            if (nodes.length == 0) {
                return;
            }
            node = nodes[0];
            selectionOffset = this.getSelection().getOffset();
            try {
                int pos = this.fScanner.getNextStartOffset(selectionOffset);
                if (pos != node.getStart()) break block7;
                int lastNodeEnd = nodes[nodes.length - 1].getEnd();
                try {
                    pos = this.fScanner.getNextStartOffset(lastNodeEnd);
                }
                catch (IllegalArgumentException e) {
                    pos = -1;
                }
                catch (CoreException e) {
                    pos = -1;
                }
                int selectionEnd = this.getSelection().getInclusiveEnd();
                if (pos > 0 && pos <= selectionEnd) {
                    org.eclipse.dltk.core.SourceRange range = new org.eclipse.dltk.core.SourceRange(lastNodeEnd, pos - lastNodeEnd);
                    this.invalidSelection("The end of the selection contains characters that do not belong to a statement.", (RefactoringStatusContext)new SourceModuleSourceContext(this.fFile, (ISourceRange)new SourceRange(range.getOffset(), range.getLength())));
                }
                return;
            }
            catch (CoreException pos) {
                // empty catch block
            }
        }
        org.eclipse.dltk.core.SourceRange range = new org.eclipse.dltk.core.SourceRange(selectionOffset, node.getStart() - selectionOffset + 1);
        this.invalidSelection("The beginning of the selection contains characters that do not belong to a statement.", (RefactoringStatusContext)new SourceModuleSourceContext(this.fFile, (ISourceRange)new SourceRange(range.getOffset(), range.getLength())));
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    protected Program getCompilationUnit() {
        return this.fCUnit;
    }

    protected TokenScanner getTokenScanner() {
        return this.fScanner;
    }

    public void endVisit(Program program) {
        if (!this.hasSelectedNodes()) {
            super.endVisit(program);
            return;
        }
        if (!this.fStatus.hasFatalError()) {
            this.checkSelectedNodes();
        }
        super.endVisit(program);
    }

    public void endVisit(DoStatement doStatement) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)doStatement, selectedNodes) && StatementAnalyzer.contains(selectedNodes, (ASTNode)doStatement.getBody()) && StatementAnalyzer.contains(selectedNodes, (ASTNode)doStatement.getCondition())) {
            this.invalidSelection("Operation not applicable to a 'do' statement's body and expression.");
        }
        super.endVisit(doStatement);
    }

    public void endVisit(ForStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)node, selectedNodes)) {
            boolean containsExpression = StatementAnalyzer.contains(selectedNodes, node.conditions());
            boolean containsUpdaters = StatementAnalyzer.contains(selectedNodes, node.updaters());
            if (StatementAnalyzer.contains(selectedNodes, node.initializers()) && containsExpression) {
                this.invalidSelection("Operation not applicable to a 'for' statement's initializer and expression part.");
            } else if (containsExpression && containsUpdaters) {
                this.invalidSelection("Operation not applicable to a 'for' statement's expression and updater part.");
            } else if (containsUpdaters && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getBody())) {
                this.invalidSelection("Operation not applicable to a 'for' statement's updater and body part.");
            }
        }
        super.endVisit(node);
    }

    public void endVisit(SwitchStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)node, selectedNodes)) {
            List cases = StatementAnalyzer.getSwitchCases(node);
            int i = 0;
            while (i < selectedNodes.length) {
                ASTNode topNode = selectedNodes[i];
                if (cases.contains(topNode)) {
                    this.invalidSelection("Selection must either cover whole switch statement or parts of a single case block.");
                    break;
                }
                ++i;
            }
        }
        super.endVisit(node);
    }

    public void endVisit(TryStatement node) {
        ASTNode firstSelectedNode = this.getFirstSelectedNode();
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 3) {
            if (firstSelectedNode == node.getBody()) {
                this.invalidSelection("Selection must either cover whole try statement or parts of try or catch block.");
            } else {
                List catchClauses = node.catchClauses();
                for (CatchClause element : catchClauses) {
                    if (element == firstSelectedNode || element.getBody() == firstSelectedNode) {
                        this.invalidSelection("Selection must either cover whole try statement or parts of try or catch block.");
                        continue;
                    }
                    if (element.getClassName() != firstSelectedNode) continue;
                    this.invalidSelection("Operation is not applicable to a catch block's argument declaration.");
                }
            }
        }
        try {
            throw new Exception("");
        }
        catch (Exception exception) {
            super.endVisit(node);
            return;
        }
    }

    public void endVisit(WhileStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)node, selectedNodes) && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getCondition()) && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getBody())) {
            this.invalidSelection("Operation not applicable to a while statement's expression and body.");
        }
        super.endVisit(node);
    }

    private boolean doAfterValidation(ASTNode node, ASTNode[] selectedNodes) {
        return selectedNodes.length > 0 && node == selectedNodes[0].getParent() && this.getSelection().getEndVisitSelectionMode(node) == 3;
    }

    protected void invalidSelection(String message) {
        this.fStatus.addFatalError(message);
        this.reset();
    }

    protected void invalidSelection(String message, RefactoringStatusContext context) {
        this.fStatus.addFatalError(message, context);
        this.reset();
    }

    private static List getSwitchCases(SwitchStatement node) {
        ArrayList result = new ArrayList();
        for (Object element : node.getBody().statements()) {
            if (!(element instanceof SwitchCase)) continue;
            result.add(element);
        }
        return result;
    }

    protected static boolean contains(ASTNode[] nodes, ASTNode node) {
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] == node) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean contains(ASTNode[] nodes, List list) {
        int i = 0;
        while (i < nodes.length) {
            if (list.contains(nodes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

