/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Shell;

public class ActionUtils {
    private static final IContentType contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);

    public static boolean containsOnlyProjects(List elements) {
        if (elements.isEmpty()) {
            return false;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (ActionUtils.isProject(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnly(List elements, Class clazz) {
        if (elements.isEmpty()) {
            return false;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (clazz.isAssignableFrom(iter.next().getClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean isProject(Object element) {
        return element instanceof IScriptProject || element instanceof IProject;
    }

    public static IResource[] getResources(List elements) {
        return ActionUtils.getResources(elements, false);
    }

    public static IResource[] getResources(List elements, boolean includePHPFileData) {
        ArrayList resources = new ArrayList(elements.size());
        for (Object element : elements) {
            if (element instanceof IResource) {
                resources.add(element);
                continue;
            }
            if (!includePHPFileData || !(element instanceof ISourceModule)) continue;
            resources.add(((ISourceModule)element).getResource());
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IResource[] getResources(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                result.add(element);
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IResource[] getPHPResources(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IFile) {
                if (contentType.isAssociatedWith(((IResource)element).getName())) {
                    result.add(element);
                }
            } else if (element instanceof IResource) {
                result.add(element);
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static Object[] getPHPElements(List elements) {
        return ActionUtils.getPHPElements(elements, false);
    }

    public static Object[] getPHPElements(List elements, boolean phpFileDataIsResource) {
        ArrayList phpElements = new ArrayList(elements.size());
        for (Object element : elements) {
            if (!(element instanceof IModelElement) && !(element instanceof IScriptProject) || phpFileDataIsResource && element instanceof ISourceModule) continue;
            phpElements.add(element);
        }
        return phpElements.toArray();
    }

    public static Object[] getPHPElements(Object[] elements) {
        ArrayList<Object> resources = new ArrayList<Object>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof ISourceModule || element instanceof IScriptProject) {
                resources.add(element);
            }
            ++n2;
        }
        return resources.toArray();
    }

    public static boolean isPHPSource(ISourceModule element) {
        IProject project;
        IScriptProject scriptProject = element.getScriptProject();
        if (scriptProject != null && (project = scriptProject.getProject()) != null) {
            try {
                IProjectNature nature = project.getNature("org.eclipse.php.core.PHPNature");
                if (nature != null) {
                    return true;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isProcessable(Shell shell, Object element) {
        if (!(element instanceof ISourceModule)) {
            return true;
        }
        return ActionUtils.isPHPSource((ISourceModule)element);
    }

    public static boolean isProcessable(Shell shell, PHPStructuredEditor editor) {
        if (editor == null) {
            return true;
        }
        ISourceModule input = SelectionConverter.getInput(editor);
        if (input == null) {
            return false;
        }
        return ActionUtils.isProcessable(shell, input);
    }

    public static boolean isRenameAvailable(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            return false;
        }
        return resource.isAccessible();
    }

    public static boolean isDeleteAvailable(IResource resource) {
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        return resource.getType() != 8 && resource.getType() != 4;
    }

    public static boolean isDeleteAvailable(Object element) {
        if (element instanceof IScriptProject) {
            return false;
        }
        return element instanceof ISourceModule;
    }

    public static boolean isDeleteAvailable(Object[] objects) {
        if (objects.length != 0) {
            Object[] elements;
            IResource[] resources = ActionUtils.getResources(objects);
            if (objects.length != resources.length + (elements = ActionUtils.getPHPElements(objects)).length) {
                return false;
            }
            int index = 0;
            while (index < resources.length) {
                if (!ActionUtils.isDeleteAvailable(resources[index])) {
                    return false;
                }
                ++index;
            }
            index = 0;
            while (index < elements.length) {
                if (!ActionUtils.isDeleteAvailable(elements[index])) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    public static boolean arePHPElements(Object[] elements) {
        if (elements != null) {
            int index = 0;
            while (index < elements.length) {
                if (elements[index] instanceof IMember && !(elements[index] instanceof ISourceModule)) {
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public static boolean isInsidePHPFile(Object object) {
        return object instanceof ISourceModule;
    }
}

