/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.util.MethodOverrideTester;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.corext.util.SuperTypeHierarchyCache;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.CodeGeneration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class AddDescriptionAction
extends Action
implements IObjectActionDelegate {
    private static final String PHP_COMMENT_BLOCK_END = " */";
    private static final String PHP_COMMENT_BLOCK_MID = " *";
    private static final String PHP_COMMENT_BLOCK_START = "/**";
    private final String PHP_BLOCK_OPEN_TAG = "<?php";
    private final String PHP_BLOCK_CLOSE_TAG = "?>";
    private IModelElement[] fModelElement;
    private int startPosition = 0;
    String docBlock;
    String lineDelim;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IModelElement[] modelElement = this.getModelElement();
        if (modelElement == null) {
            return;
        }
        Arrays.sort(modelElement, new modelElementComparatorImplementation());
        int i = modelElement.length - 1;
        while (i >= 0) {
            IModelElement modelElem = modelElement[i];
            if (modelElem != null) {
                IEditorPart editorPart;
                IEditorInput input;
                try {
                    input = org.eclipse.php.internal.ui.util.EditorUtility.getEditorInput(modelElem);
                }
                catch (ModelException e) {
                    Logger.logException(e);
                    return;
                }
                IWorkbenchPage page = PHPUiPlugin.getActivePage();
                try {
                    editorPart = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.php.editor");
                }
                catch (PartInitException e) {
                    Logger.logException(e);
                    return;
                }
                if (editorPart instanceof ITextEditor) {
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IEditorInput editorInput = editorPart.getEditorInput();
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
                    this.lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                    String docBlockText = this.handleElement(textEditor, modelElem, document);
                    if (docBlockText == null) {
                        return;
                    }
                    EditorUtility.revealInEditor((IEditorPart)textEditor, (int)this.startPosition, (int)this.docBlock.length());
                }
            }
            --i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleElement(ITextEditor textEditor, IModelElement modelElem, IDocument document) {
        int type;
        PHPStructuredEditor editor;
        if (textEditor instanceof PHPStructuredEditor && (editor = (PHPStructuredEditor)textEditor).getTextViewer() != null && !editor.getTextViewer().isEditable()) {
            return null;
        }
        if (modelElem instanceof ISourceModule) {
            this.handleFileDocBlock((ISourceModule)modelElem, (IStructuredDocument)document);
            return null;
        }
        try {
            this.startPosition = this.getCodeDataOffset(modelElem);
        }
        catch (ModelException e) {
            Logger.logException(e);
            return null;
        }
        String indentString = null;
        try {
            indentString = this.getIndentString(document, modelElem);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return null;
        }
        if (!textEditor.isEditable()) {
            return null;
        }
        int n = type = modelElem != null ? modelElem.getElementType() : -1;
        if (type != 9 && type != 7 && type != 8) {
            assert (false);
            return null;
        }
        String comment = null;
        try {
            switch (type) {
                case 7: {
                    if (PHPModelUtils.getDocBlock((IType)((IType)modelElem)) != null) {
                        return null;
                    }
                    comment = this.createTypeComment((IType)modelElem, this.lineDelim);
                    break;
                }
                case 8: {
                    if (!this.isParameter((IField)modelElem)) {
                        if (PHPModelUtils.getDocBlock((IField)((IField)modelElem)) != null) {
                            return null;
                        }
                        comment = this.createFieldComment((IField)modelElem, this.lineDelim);
                        break;
                    }
                    if (modelElem != null) {
                        modelElem = modelElem.getParent();
                        this.startPosition = this.getCodeDataOffset(modelElem);
                        try {
                            indentString = this.getIndentString(document, modelElem);
                        }
                        catch (BadLocationException e) {
                            Logger.logException(e);
                            return null;
                        }
                    }
                }
                case 9: {
                    if (PHPModelUtils.getDocBlock((IMethod)((IMethod)modelElem)) != null) {
                        return null;
                    }
                    comment = this.createMethodComment((IMethod)modelElem, this.lineDelim);
                    break;
                }
                default: {
                    comment = this.createDefaultComment(this.lineDelim);
                    break;
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (comment == null) {
            comment = this.createDefaultComment(this.lineDelim);
        }
        this.docBlock = this.indentPattern(comment, indentString, this.lineDelim);
        return this.insertDocBlock((IDocument)((IStructuredDocument)document), this.startPosition, this.docBlock);
    }

    private boolean isParameter(IField field) {
        ISourceModule sourceModule = field.getSourceModule();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        ASTNode fieldDeclaration = null;
        try {
            fieldDeclaration = PHPModelUtils.getNodeByField((ModuleDeclaration)moduleDeclaration, (IField)field);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return fieldDeclaration instanceof Argument;
    }

    private String indentPattern(String originalPattern, String indentation, String lineDelim) {
        String delimPlusIndent = String.valueOf(lineDelim) + indentation;
        String indentedPattern = String.valueOf(originalPattern.replaceAll(Pattern.quote(lineDelim), delimPlusIndent)) + delimPlusIndent;
        return indentedPattern;
    }

    private String createDefaultComment(String lineDelimiter) {
        return PHP_COMMENT_BLOCK_START + lineDelimiter + PHP_COMMENT_BLOCK_MID + lineDelimiter + PHP_COMMENT_BLOCK_END;
    }

    private String createTypeComment(IType type, String lineDelimiter) throws CoreException {
        return CodeGeneration.getTypeComment(type.getScriptProject(), type.getTypeQualifiedName(), null, lineDelimiter);
    }

    private String createMethodComment(IMethod meth, String lineDelimiter) throws CoreException {
        IType declaringType = meth.getDeclaringType();
        IMethod overridden = null;
        if (!meth.isConstructor() && declaringType != null) {
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(declaringType);
            MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
            overridden = tester.findOverriddenMethod(meth, true);
        }
        return CodeGeneration.getMethodComment(meth, overridden, lineDelimiter);
    }

    private String createFieldComment(IField field, String lineDelimiter) throws ModelException, CoreException {
        return CodeGeneration.getFieldComment(field.getScriptProject(), field, lineDelimiter);
    }

    public String createPHPScopeFileDocBlock(IScriptProject scriptProject) {
        String fileComment = null;
        try {
            fileComment = CodeGeneration.getFileComment(scriptProject, this.lineDelim);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (fileComment == null) {
            fileComment = this.createDefaultComment(this.lineDelim);
        }
        return "<?php" + this.lineDelim + fileComment + "?>" + this.lineDelim;
    }

    private String getIndentString(IDocument document, IModelElement modelElem) throws BadLocationException {
        int elementOffset = 0;
        String leadingString = null;
        try {
            elementOffset = this.getCodeDataOffset(modelElem);
            int lineStartOffset = document.getLineInformationOfOffset(elementOffset).getOffset();
            leadingString = document.get(lineStartOffset, elementOffset - lineStartOffset);
        }
        catch (ModelException e) {
            Logger.logException(e);
            return null;
        }
        leadingString = leadingString.replaceAll("[^\\p{javaWhitespace}]", " ");
        return leadingString;
    }

    private int getCodeDataOffset(IModelElement modelElem) throws ModelException {
        if (modelElem instanceof ISourceModule) {
            ISourceReference primaryModelElem = (ISourceReference)((ISourceModule)modelElem).getPrimaryElement();
            return primaryModelElem != null ? primaryModelElem.getSourceRange().getOffset() + primaryModelElem.getSourceRange().getLength() : -1;
        }
        if (modelElem instanceof ISourceReference) {
            int dataOffset = ((ISourceReference)modelElem).getSourceRange().getOffset();
            return dataOffset;
        }
        assert (false);
        return -1;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        this.setModelElement(new IModelElement[structuredSelection.size()]);
        Iterator i = structuredSelection.iterator();
        int idx = 0;
        IModelElement[] modelElement = this.getModelElement();
        while (i.hasNext()) {
            modelElement[idx++] = (IModelElement)i.next();
        }
    }

    private void handleFileDocBlock(ISourceModule data, IStructuredDocument document) {
        IStructuredDocumentRegion sdRegion = document.getFirstStructuredDocumentRegion();
        IPhpScriptRegion phpScriptRegion = null;
        ITextRegion textRegion = null;
        String docBlock = null;
        while (sdRegion != null && docBlock == null) {
            ITextRegion region = sdRegion.getFirstRegion();
            if (region.getType() == "PHP_OPEN") {
                if ((region = sdRegion.getRegionAtCharacterOffset(region.getEnd() + sdRegion.getStartOffset())) != null && region.getType() == "PHP_CONTENT") {
                    phpScriptRegion = (IPhpScriptRegion)region;
                    try {
                        docBlock = CodeGeneration.getFileComment(data, null);
                    }
                    catch (CoreException e) {
                        Logger.logException("Generating default phpdoc comment", e);
                    }
                    if (docBlock != null) break;
                    docBlock = this.createDefaultComment("");
                    break;
                }
            } else if (region.getType() == "XML_DECLARATION_OPEN" && (region = sdRegion.getRegionAtCharacterOffset(region.getEnd() + sdRegion.getStartOffset())) != null) {
                phpScriptRegion = null;
                textRegion = region;
                docBlock = this.createPHPScopeFileDocBlock(data.getScriptProject());
                break;
            }
            sdRegion = sdRegion.getNext();
        }
        if (phpScriptRegion != null || textRegion != null) {
            try {
                int offset = 0;
                if (phpScriptRegion == null && textRegion != null) {
                    offset = 0;
                } else if (phpScriptRegion != null && sdRegion != null) {
                    textRegion = phpScriptRegion.getPhpToken(0);
                    String lineDelimiter = document.getLineDelimiter(document.getLineOfOffset(textRegion.getStart()));
                    if (lineDelimiter == null) {
                        lineDelimiter = "";
                    }
                    int lineDelimiterLength = lineDelimiter.length();
                    offset = textRegion.getStart() + sdRegion.getStartOffset() + phpScriptRegion.getStart() + lineDelimiterLength;
                } else assert (false);
                if (data instanceof AbstractSourceModule) {
                    this.insertDocBlock((IDocument)document, offset, docBlock);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private String insertDocBlock(IDocument document, int offset, String docBlock) {
        try {
            document.replace(offset, 0, docBlock);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            docBlock = null;
        }
        return docBlock;
    }

    public void setModelElement(IModelElement[] fmodelElement) {
        this.fModelElement = fmodelElement;
    }

    public IModelElement[] getModelElement() {
        return this.fModelElement;
    }

    private final class modelElementComparatorImplementation
    implements Comparator<IModelElement> {
        private modelElementComparatorImplementation() {
        }

        @Override
        public int compare(IModelElement object1, IModelElement object2) {
            if (object1 instanceof ISourceReference && object2 instanceof ISourceReference) {
                ISourceReference sourceReference2;
                ISourceReference sourceReference1;
                block8: {
                    block7: {
                        sourceReference1 = (ISourceReference)object1;
                        sourceReference2 = (ISourceReference)object2;
                        if (sourceReference1.getSourceRange() != null) break block7;
                        if (sourceReference2.getSourceRange() == null) {
                            return 0;
                        }
                        return 1;
                    }
                    if (sourceReference2.getSourceRange() != null) break block8;
                    return -1;
                }
                try {
                    return sourceReference1.getSourceRange().getOffset() - sourceReference2.getSourceRange().getOffset();
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
            }
            assert (false);
            return 0;
        }
    }
}

