/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.internal.core.format.IndentationObject;
import org.eclipse.php.internal.core.format.PhpIndentationFormatter;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;

public class PHPAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.text != null && c.text.length() > 1 && c.text.trim().length() > 1 && PHPAutoIndentStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            try {
                this.smartPaste(d, c);
            }
            catch (Exception e) {
                PHPUiPlugin.log(e);
            }
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return PHPUiPlugin.getDefault().getPreferenceStore();
    }

    protected void smartPaste(IDocument document, DocumentCommand command) {
        if (command.offset == -1 || document.getLength() == 0) {
            return;
        }
        IndentationObject indentationObject = null;
        String fakeFirstCharsAfterCommandText = "#";
        try {
            if (document instanceof IStructuredDocument) {
                indentationObject = new IndentationObject((IStructuredDocument)document);
                IRegion region = document.getLineInformation(document.getLineOfOffset(command.offset));
                if (command.offset != region.getOffset()) {
                    String textBeforeCommandOffset = document.get(region.getOffset(), command.offset - region.getOffset());
                    if (StringUtils.isBlank((CharSequence)textBeforeCommandOffset)) {
                        command.length += command.offset - region.getOffset();
                        command.offset = region.getOffset();
                    } else {
                        StringBuilder tempsb = new StringBuilder(textBeforeCommandOffset.length() + command.text.length());
                        tempsb.append(textBeforeCommandOffset).append(command.text);
                        command.text = tempsb.toString();
                        command.length += command.offset - region.getOffset();
                        command.offset = region.getOffset();
                    }
                }
                int selectionEndOffset = command.offset + command.length;
                region = document.getLineInformation(document.getLineOfOffset(selectionEndOffset));
                int i = selectionEndOffset;
                int lineEndOffset = region.getOffset() + region.getLength();
                while (i < lineEndOffset && (document.getChar(i) == ' ' || document.getChar(i) == '\t')) {
                    ++i;
                }
                if (i < lineEndOffset) {
                    int j = i + 1;
                    while (j < lineEndOffset && document.getChar(j) != ' ' && document.getChar(j) != '\t') {
                        ++j;
                    }
                    Document tempdocument = new Document(command.text);
                    int lines = tempdocument.getNumberOfLines();
                    if (lines > 1) {
                        command.length += i - selectionEndOffset;
                        fakeFirstCharsAfterCommandText = document.get(i, j - i);
                    }
                } else {
                    command.length += i - selectionEndOffset;
                }
            }
            JobSafeStructuredDocument newdocument = new JobSafeStructuredDocument((RegionParser)new PhpSourceParser());
            StringBuilder tempsb = new StringBuilder(command.offset + command.text.length() + 1);
            tempsb.append(document.get(0, command.offset)).append(command.text).append(fakeFirstCharsAfterCommandText);
            newdocument.set(tempsb.toString());
            PhpIndentationFormatter formatter = new PhpIndentationFormatter(command.offset, command.text.length(), indentationObject);
            formatter.format(newdocument.getRegionAtCharacterOffset(command.offset));
            if (fakeFirstCharsAfterCommandText.length() == 1 && newdocument.getChar(newdocument.getLength() - 1) == fakeFirstCharsAfterCommandText.charAt(0)) {
                command.text = newdocument.get(command.offset, newdocument.getLength() - command.offset - 1);
            } else {
                command.text = newdocument.get(command.offset, newdocument.getLength() - command.offset);
                command.text = command.text.substring(0, command.text.lastIndexOf(fakeFirstCharsAfterCommandText));
            }
        }
        catch (BadLocationException e) {
            PHPUiPlugin.log(e);
        }
    }
}

