/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.core.util.MethodOverrideTester;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.php.internal.ui.corext.util.SuperTypeHierarchyCache;
import org.eclipse.php.ui.CodeGeneration;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PhpDocAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final String PHPDOC_COMMENT_BLOCK_START = "/**";
    private static final String PHP_COMMENT_BLOCK_START = "/*";
    private static final String PHP_COMMENT_BLOCK_MID = " *";
    private static final String PHP_COMMENT_BLOCK_END = " */";
    private final String fPartitioning;

    public PhpDocAutoIndentStrategy(String partitioning) {
        this.fPartitioning = partitioning;
    }

    public PhpDocAutoIndentStrategy() {
        this("org.eclipse.php.PHP_DEFAULT");
    }

    private void indentAfterNewLine(IDocument d, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            Assert.isTrue((firstNonWS >= lineOffset ? 1 : 0) != 0, (String)"indentation must not be negative");
            StringBuffer buf = new StringBuffer(c.text);
            IRegion prefix = this.findPrefixRange(d, line);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            if (firstNonWS < offset && d.getChar(firstNonWS) == '/') {
                buf.append(" * ");
                if (TypingPreferences.closePhpdoc && this.isNewComment(d, offset)) {
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + buf.length();
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                    int replacementLength = 0;
                    String restOfLine = d.get(p, replacementLength);
                    String endTag = String.valueOf(lineDelimiter) + indentation + PHP_COMMENT_BLOCK_END;
                    if (this.getCommentEnd(d, offset) > 0) {
                        endTag = "";
                    }
                    if (TypingPreferences.addDocTags) {
                        d.replace(offset, replacementLength, endTag);
                        ISourceModule unit = PhpDocAutoIndentStrategy.getCompilationUnit();
                        if (unit != null) {
                            try {
                                ScriptModelUtil.reconcile((ISourceModule)unit);
                                String partitionType = FormatterUtils.getPartitionType((IStructuredDocument)((IStructuredDocument)d), (int)c.offset);
                                String commentBlockBody = partitionType == "org.eclipse.php.PHP_DOC" ? this.createScriptdocTags(d, c, indentation, lineDelimiter, unit) : PHP_COMMENT_BLOCK_MID;
                                buf.append(restOfLine);
                                if (commentBlockBody != null && !commentBlockBody.trim().equals("*")) {
                                    buf.append(commentBlockBody);
                                }
                            }
                            catch (CoreException e) {
                                Logger.logException(e);
                            }
                        }
                    } else {
                        c.length = replacementLength;
                        buf.append(restOfLine);
                        buf.append(endTag);
                    }
                }
            }
            if (lengthToAdd < prefix.getLength()) {
                c.caretOffset = offset + prefix.getLength() - lengthToAdd;
            }
            c.text = buf.toString();
        }
        catch (BadLocationException excp) {
            Logger.logException(excp);
        }
    }

    private boolean isPreferenceTrue(String preference) {
        return PHPUiPlugin.getDefault().getPreferenceStore().getBoolean(preference);
    }

    private IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.getChar(indentEnd) == '*') {
            ++indentEnd;
            while (indentEnd < lineEnd && document.getChar(indentEnd) == ' ') {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private IRegion findCommentBlockStartPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineOffset = line.getOffset();
        int lineEnd = lineOffset + line.getLength();
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset, lineEnd);
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private String createScriptdocTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, ISourceModule unit) throws CoreException, BadLocationException {
        int type;
        int nextElementOffset = this.getEndOfWhiteSpacesOffset(document, command.caretOffset, document.getLength());
        IModelElement element = this.getElementAt(unit, nextElementOffset);
        if (element == null) {
            return null;
        }
        if (this.getCodeDataOffset(element) <= command.caretOffset) {
            return null;
        }
        int n = type = element != null ? element.getElementType() : -1;
        if (type != 9 && type != 7 && type != 8 && type != 11) {
            assert (false);
            return null;
        }
        String comment = null;
        try {
            switch (type) {
                case 11: {
                    comment = this.createFileComment(unit, indentation, lineDelimiter);
                    break;
                }
                case 7: {
                    IType sourceType = (IType)element;
                    if (PHPFlags.isNamespace((int)sourceType.getFlags())) {
                        comment = this.createFileComment(unit, indentation, lineDelimiter);
                        break;
                    }
                    comment = this.createTypeTags(document, command, indentation, lineDelimiter, (IType)element);
                    break;
                }
                case 8: {
                    comment = this.creatFieldTags(document, command, indentation, lineDelimiter, (IField)element);
                    if (comment == null) {
                        comment = this.prepareTemplateComment("", indentation, element.getScriptProject(), lineDelimiter);
                    }
                    break;
                }
                case 9: {
                    comment = this.createMethodTags(document, command, indentation, lineDelimiter, (IMethod)element);
                    break;
                }
                default: {
                    comment = this.createDefaultComment(lineDelimiter);
                    break;
                }
            }
        }
        catch (CoreException e) {
            comment = this.createDefaultComment(lineDelimiter);
            Logger.logException(e);
        }
        return this.indentPattern(comment, indentation, lineDelimiter);
    }

    private int getEndOfWhiteSpacesOffset(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            if (!Character.isWhitespace(document.getChar(offset))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    private IModelElement getElementAt(ISourceModule unit, int nextElementOffset) throws ModelException {
        IModelElement modelElement = unit.getElementAt(nextElementOffset);
        if (modelElement == null && unit.getChildren().length != 0 && unit.getChildren()[0].getElementType() == 11) {
            return unit.getChildren()[0];
        }
        return modelElement;
    }

    private String prepareTemplateComment(String comment, String indentation, IScriptProject project, String lineDelimiter) {
        if (comment.endsWith("*/")) {
            comment = comment.substring(0, comment.length() - 2);
        }
        if ((comment = comment.trim()).startsWith(PHP_COMMENT_BLOCK_START)) {
            comment = comment.length() > 2 && comment.charAt(2) == '*' ? comment.substring(3) : comment.substring(2);
        }
        int nonSpace = 0;
        int len = comment.length();
        while (nonSpace < len && Character.getType(comment.charAt(nonSpace)) == 12) {
            ++nonSpace;
        }
        comment = comment.substring(nonSpace);
        return comment;
    }

    private String createFileComment(ISourceModule sourceModule, String indentation, String lineDelimiter) throws CoreException {
        String comment = CodeGeneration.getFileComment(sourceModule, lineDelimiter);
        if (comment != null) {
            comment = comment.trim();
            return this.prepareTemplateComment(comment.trim(), indentation, sourceModule.getScriptProject(), lineDelimiter);
        }
        return comment;
    }

    private String createTypeTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, IType type) throws CoreException, BadLocationException {
        String comment = this.createTypeComment(type, lineDelimiter);
        if (comment != null) {
            comment = comment.trim();
            return this.prepareTemplateComment(comment.trim(), indentation, type.getScriptProject(), lineDelimiter);
        }
        return null;
    }

    private String creatFieldTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, IField field) throws CoreException, BadLocationException {
        String comment = this.createFieldComment(field, lineDelimiter);
        if (comment != null) {
            comment = comment.trim();
            return this.prepareTemplateComment(comment.trim(), indentation, field.getScriptProject(), lineDelimiter);
        }
        return null;
    }

    private String createMethodTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, IMethod method) throws CoreException, BadLocationException {
        String comment = this.createMethodComment(method, lineDelimiter);
        if (comment != null) {
            comment = comment.trim();
            return this.prepareTemplateComment(comment, indentation, method.getScriptProject(), lineDelimiter);
        }
        return null;
    }

    private void indentAfterCommentEnd(IDocument d, DocumentCommand c) {
        if (c.offset < 2 || d.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(d.get(c.offset - 2, 2))) {
                int offset;
                int fixedOffset = offset = c.offset;
                if (offset == d.getLength()) {
                    --fixedOffset;
                }
                IStructuredDocumentRegion sdRegion = ((IStructuredDocument)d).getRegionAtCharacterOffset(fixedOffset);
                ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(fixedOffset);
                int regionOffset = offset;
                if (tRegion instanceof ITextRegionContainer) {
                    tRegion = ((ITextRegionContainer)tRegion).getRegionAtCharacterOffset(fixedOffset);
                    regionOffset -= sdRegion.getStartOffset(tRegion) + tRegion.getStart();
                }
                if (tRegion instanceof IPhpScriptRegion) {
                    int currentRegionEndOffset;
                    String tokenType;
                    IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                    ITextRegion commentRegion = scriptRegion.getPhpToken(regionOffset -= scriptRegion.getStart());
                    int phpScriptEndOffset = scriptRegion.getLength();
                    boolean isSpaceDeletionNeeded = false;
                    while (!PHPPartitionTypes.isPHPMultiLineCommentEndRegion((String)(tokenType = (commentRegion = scriptRegion.getPhpToken(currentRegionEndOffset = commentRegion.getEnd())).getType())) && !PHPPartitionTypes.isPHPDocEndRegion((String)tokenType)) {
                        if (currentRegionEndOffset < phpScriptEndOffset) continue;
                        isSpaceDeletionNeeded = true;
                        break;
                    }
                    if (isSpaceDeletionNeeded) {
                        ++c.length;
                        --c.offset;
                        return;
                    }
                }
            }
        }
        catch (BadLocationException excp) {
            Logger.logException(excp);
        }
    }

    private boolean isNewComment(IDocument document, int commandOffset) {
        ITypedRegion partition;
        block7: {
            int partitionEnd;
            block6: {
                int lineIndex;
                block5: {
                    try {
                        lineIndex = document.getLineOfOffset(commandOffset) + 1;
                        if (lineIndex < document.getNumberOfLines()) break block5;
                        return true;
                    }
                    catch (BadLocationException e) {
                        return false;
                    }
                }
                IRegion line = document.getLineInformation(lineIndex);
                partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)commandOffset, (boolean)false);
                partitionEnd = partition.getOffset() + partition.getLength();
                if (line.getOffset() < partitionEnd) break block6;
                return false;
            }
            if (document.getLength() != partitionEnd) break block7;
            return true;
        }
        String comment = document.get(partition.getOffset(), partition.getLength());
        return comment.indexOf(PHP_COMMENT_BLOCK_START, 2) != -1;
    }

    private boolean isSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = PHPUiPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 extension = (ITextEditorExtension3)part;
            return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.isSmartMode()) {
            return;
        }
        if (command.text != null) {
            if (command.length == 0) {
                String[] lineDelimiters = document.getLegalLineDelimiters();
                int index = TextUtilities.endsWith((String[])lineDelimiters, (String)command.text);
                int offset = command.offset;
                if (index > -1 && lineDelimiters[index].equals(command.text)) {
                    try {
                        IStructuredDocumentRegion sdRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(offset);
                        int fixedOffset = offset;
                        if (offset == document.getLength()) {
                            --fixedOffset;
                        }
                        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(fixedOffset);
                        int regionOffset = offset;
                        if (tRegion instanceof ITextRegionContainer) {
                            tRegion = ((ITextRegionContainer)tRegion).getRegionAtCharacterOffset(fixedOffset);
                            regionOffset -= sdRegion.getStartOffset(tRegion) + tRegion.getStart();
                        }
                        if (tRegion instanceof IPhpScriptRegion) {
                            boolean isEndRegionAtEOF;
                            IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                            ITextRegion commentRegion = scriptRegion.getPhpToken(regionOffset -= scriptRegion.getStart());
                            String tokenType = commentRegion.getType();
                            boolean isStartRegion = PHPPartitionTypes.isPHPDocStartRegion((String)commentRegion.getType()) || PHPPartitionTypes.isPHPMultiLineCommentStartRegion((String)commentRegion.getType());
                            boolean bl = isEndRegionAtEOF = document.getLength() == offset && (PHPPartitionTypes.isPHPDocEndRegion((String)tokenType) || PHPPartitionTypes.isPHPMultiLineCommentEndRegion((String)tokenType)) && document.get(offset - 2, 2).equals("*/");
                            if (isStartRegion || isEndRegionAtEOF) {
                                ITextRegion region = commentRegion;
                                while (!PHPPartitionTypes.isPHPDocStartRegion((String)region.getType()) && !PHPPartitionTypes.isPHPMultiLineCommentStartRegion((String)region.getType()) && region.getStart() > scriptRegion.getStart()) {
                                    region = scriptRegion.getPhpToken(region.getStart() - lineDelimiters[index].length());
                                }
                                IRegion line = document.getLineInformationOfOffset(region.getStart());
                                StringBuffer buf = new StringBuffer(command.text);
                                IRegion prefix = this.findCommentBlockStartPrefixRange(document, line);
                                String indentation = document.get(prefix.getOffset(), prefix.getLength());
                                buf.append(indentation);
                                command.shiftsCaret = false;
                                command.caretOffset = command.offset + buf.length();
                                command.text = buf.toString();
                                return;
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    if (lineDelimiters[index].equals(command.text)) {
                        this.indentAfterNewLine(document, command);
                    }
                    return;
                }
            }
            if (command.text.equals("/")) {
                this.indentAfterCommentEnd(document, command);
                return;
            }
        }
    }

    private static IMethod getInheritedMethod(IMethod method) throws ModelException {
        IType declaringType = method.getDeclaringType();
        if (declaringType == null) {
            return null;
        }
        MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(declaringType);
        return tester.findOverriddenMethod(method, true);
    }

    private static ISourceModule getCompilationUnit() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IWorkingCopyManager manager = PHPUiPlugin.getWorkingCopyManager();
        ISourceModule unit = manager.getWorkingCopy(editor.getEditorInput());
        if (unit == null) {
            return null;
        }
        return unit;
    }

    private int getCommentEnd(IDocument d, int offset) throws BadLocationException {
        int endOfDoc = d.getLength();
        while (offset + 1 < endOfDoc) {
            if (d.getChar(offset) == '*' && d.getChar(offset + 1) == '/') {
                return offset + 1;
            }
            if (d.getChar(offset) == '/' && d.getChar(offset + 1) == '*') {
                return -1;
            }
            ++offset;
        }
        return -2;
    }

    private String createTypeComment(IType type, String lineDelimiter) throws CoreException {
        return CodeGeneration.getTypeComment(type.getScriptProject(), type.getTypeQualifiedName(), null, lineDelimiter);
    }

    private String createMethodComment(IMethod meth, String lineDelimiter) throws CoreException {
        IType declaringType = meth.getDeclaringType();
        IMethod overridden = null;
        if (!meth.isConstructor() && declaringType != null) {
            try {
                ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(declaringType);
                MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
                overridden = tester.findOverriddenMethod(meth, true);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return CodeGeneration.getMethodComment(meth, overridden, lineDelimiter);
    }

    private String createFieldComment(IField field, String lineDelimiter) throws ModelException, CoreException {
        return CodeGeneration.getFieldComment(field.getScriptProject(), field, lineDelimiter);
    }

    private String createDefaultComment(String lineDelimiter) {
        return PHPDOC_COMMENT_BLOCK_START + lineDelimiter + PHP_COMMENT_BLOCK_MID + lineDelimiter + PHP_COMMENT_BLOCK_END;
    }

    private String getIndentString(IDocument document, IModelElement modelElem) throws BadLocationException {
        int elementOffset = 0;
        String leadingString = null;
        try {
            elementOffset = this.getCodeDataOffset(modelElem);
            int lineStartOffset = document.getLineInformationOfOffset(elementOffset).getOffset();
            leadingString = document.get(lineStartOffset, elementOffset - lineStartOffset);
        }
        catch (ModelException e) {
            Logger.logException(e);
            return null;
        }
        leadingString = leadingString.replaceAll("[^\\p{javaWhitespace}]", " ");
        return leadingString;
    }

    private int getCodeDataOffset(IModelElement modelElem) throws ModelException {
        if (modelElem instanceof ISourceModule) {
            ISourceReference primaryModelElem = (ISourceReference)((ISourceModule)modelElem).getPrimaryElement();
            return primaryModelElem != null ? primaryModelElem.getSourceRange().getOffset() + primaryModelElem.getSourceRange().getLength() : -1;
        }
        if (modelElem instanceof ISourceReference) {
            int dataOffset = ((ISourceReference)modelElem).getSourceRange().getOffset();
            return dataOffset;
        }
        assert (false);
        return -1;
    }

    private String indentPattern(String originalPattern, String indentation, String lineDelim) {
        String delimPlusIndent = String.valueOf(lineDelim) + indentation;
        String indentedPattern = originalPattern.replaceAll(Pattern.quote(lineDelim), delimPlusIndent);
        return indentedPattern;
    }
}

