/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.ScrolledPageContent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class OptionsConfigurationBlock {
    private static final String REBUILD_COUNT_KEY = "preferences_build_requested";
    private static final String SETTINGS_EXPANDED = "expanded";
    protected final ArrayList<Button> fCheckBoxes;
    protected final ArrayList<Combo> fComboBoxes;
    protected final ArrayList<Text> fTextBoxes;
    protected final ArrayList<Link> fLinks;
    protected final HashMap<Control, Label> fLabels;
    protected final ArrayList<ExpandableComposite> fExpandableComposites;
    private SelectionListener fSelectionListener;
    private ModifyListener fTextModifyListener;
    protected IStatusChangeListener fContext;
    protected final IProject fProject;
    protected final Key[] fAllKeys;
    private IScopeContext[] fLookupOrder;
    private Shell fShell;
    protected final IWorkingCopyManager fManager;
    private final IWorkbenchPreferenceContainer fContainer;
    private Map<Key, String> fDisabledProjectSettings;
    private int fRebuildCount;
    protected static final int HIGHLIGHT_FOCUS = 17;
    protected static final int HIGHLIGHT_MOUSE = 18;
    protected static final int HIGHLIGHT_NONE = 0;

    public OptionsConfigurationBlock(IStatusChangeListener context, IProject project, Key[] allKeys, IWorkbenchPreferenceContainer container) {
        this.fContext = context;
        this.fProject = project;
        this.fAllKeys = allKeys;
        this.fContainer = container;
        this.fManager = container == null ? new WorkingCopyManager() : container.getWorkingCopyManager();
        this.fLookupOrder = this.fProject != null ? new IScopeContext[]{new ProjectScope(this.fProject), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        this.testIfOptionsComplete(allKeys);
        if (this.fProject == null || this.hasProjectSpecificOptions(this.fProject)) {
            this.fDisabledProjectSettings = null;
        } else {
            this.fDisabledProjectSettings = new IdentityHashMap<Key, String>();
            int i = 0;
            while (i < allKeys.length) {
                Key curr = allKeys[i];
                this.fDisabledProjectSettings.put(curr, curr.getStoredValue(this.fLookupOrder, false, this.fManager));
                ++i;
            }
        }
        this.settingsUpdated();
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList(2);
        this.fLinks = new ArrayList(2);
        this.fLabels = new HashMap();
        this.fExpandableComposites = new ArrayList();
        this.fRebuildCount = this.getRebuildCount();
    }

    protected final IWorkbenchPreferenceContainer getPreferenceContainer() {
        return this.fContainer;
    }

    protected static Key getKey(String plugin, String key) {
        return new Key(plugin, key);
    }

    protected static final Key getLocalKey(String key) {
        return new LocalKey(key);
    }

    private void testIfOptionsComplete(Key[] allKeys) {
        int i = 0;
        while (i < allKeys.length) {
            Key key = allKeys[i];
            if (!(key instanceof LocalKey) && key.getStoredValue(this.fLookupOrder, false, this.fManager) == null) {
                PHPUiPlugin.logErrorMessage("preference option missing: " + key + " (" + this.getClass().getName() + ')');
            }
            ++i;
        }
    }

    private int getRebuildCount() {
        return this.fManager.getWorkingCopy(DefaultScope.INSTANCE.getNode("org.eclipse.php.ui")).getInt(REBUILD_COUNT_KEY, 0);
    }

    private void incrementRebuildCount() {
        ++this.fRebuildCount;
        this.fManager.getWorkingCopy(DefaultScope.INSTANCE.getNode("org.eclipse.php.ui")).putInt(REBUILD_COUNT_KEY, this.fRebuildCount);
    }

    protected void settingsUpdated() {
    }

    public void selectOption(String key, String qualifier) {
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            if (curr.getName().equals(key) && curr.getQualifier().equals(qualifier)) {
                this.selectOption(curr);
            }
            ++i;
        }
    }

    public void selectOption(Key key) {
        Control control = this.findControl(key);
        if (control != null) {
            ExpandableComposite expandable;
            if (!this.fExpandableComposites.isEmpty() && (expandable = this.getParentExpandableComposite(control)) != null) {
                int i = 0;
                while (i < this.fExpandableComposites.size()) {
                    ExpandableComposite curr;
                    curr.setExpanded((curr = this.fExpandableComposites.get(i)) == expandable);
                    ++i;
                }
                this.expandedStateChanged(expandable);
            }
            control.setFocus();
        }
    }

    public boolean hasProjectSpecificOptions(IProject project) {
        return OptionsConfigurationBlock.hasProjectSpecificOptions(project, this.fAllKeys, this.fManager);
    }

    public static boolean hasProjectSpecificOptions(IProject project, Key[] allKeys, IWorkingCopyManager manager) {
        if (project != null) {
            ProjectScope projectContext = new ProjectScope(project);
            int i = 0;
            while (i < allKeys.length) {
                if (allKeys[i].getStoredValue((IScopeContext)projectContext, manager) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected Button addCheckBox(Composite parent, String label, Key key, String[] values, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Button checkBox = new Button(parent, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setText(label);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.getSelectionListener());
        this.makeScrollableCompositeAware((Control)checkBox);
        this.updateCheckBox(checkBox);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    protected Button addCheckBoxWithLink(Composite parent, final String label, Key key, String[] values, int indent, int widthHint, final SelectionListener listener) {
        LinkControlData data = new LinkControlData(key, values);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        final Button checkBox = new Button(composite, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        gd = new GridData(4, 2, false, false);
        int offset = Util.isMac() ? -4 : (Util.isLinux() ? -2 : 3);
        gd.widthHint = checkBox.computeSize((int)-1, (int)-1).x + offset;
        checkBox.setLayoutData((Object)gd);
        checkBox.setData((Object)data);
        checkBox.addSelectionListener(this.getSelectionListener());
        checkBox.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LegacyActionTools.removeMnemonics((String)label.replaceAll("</?[aA][^>]*>", ""));
            }
        });
        gd = new GridData(4, 2, true, false);
        gd.widthHint = widthHint;
        Link link = new Link(composite, 0);
        link.setText(label);
        link.setLayoutData((Object)gd);
        link.setData((Object)key);
        data.setLink(link);
        final boolean[] linkSelected = new boolean[1];
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                linkSelected[0] = true;
                if (listener != null) {
                    listener.widgetSelected(e);
                }
            }
        });
        link.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                linkSelected[0] = false;
            }

            public void mouseUp(MouseEvent e) {
                if (!linkSelected[0]) {
                    checkBox.setSelection(!checkBox.getSelection());
                    checkBox.setFocus();
                    linkSelected[0] = false;
                    OptionsConfigurationBlock.this.controlChanged((Widget)checkBox);
                }
            }
        });
        link.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    checkBox.setSelection(!checkBox.getSelection());
                    checkBox.setFocus();
                    linkSelected[0] = false;
                    OptionsConfigurationBlock.this.controlChanged((Widget)checkBox);
                }
            }
        });
        this.makeScrollableCompositeAware((Control)link);
        this.makeScrollableCompositeAware((Control)checkBox);
        this.updateCheckBox(checkBox);
        this.fCheckBoxes.add(checkBox);
        this.fLinks.add(link);
        return checkBox;
    }

    protected Combo addComboBox(Composite parent, String label, Key key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(1, 2, true, false, 2, 1);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16384);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(parent, key, values, valueLabels);
        comboBox.setLayoutData((Object)new GridData(256));
        this.fLabels.put((Control)comboBox, labelControl);
        this.addHighlight(parent, labelControl, comboBox);
        return comboBox;
    }

    private void addHighlight(final Composite parent, final Label labelControl, final Combo comboBox) {
        comboBox.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                OptionsConfigurationBlock.this.highlight(parent, labelControl, comboBox, 0);
            }

            public void focusGained(FocusEvent e) {
                OptionsConfigurationBlock.this.highlight(parent, labelControl, comboBox, 17);
            }
        });
        MouseTrackAdapter labelComboListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                OptionsConfigurationBlock.this.highlight(parent, labelControl, comboBox, comboBox.isEnabled() ? (comboBox.isFocusControl() ? 17 : 18) : 0);
            }

            public void mouseExit(MouseEvent e) {
                if (!comboBox.isFocusControl()) {
                    OptionsConfigurationBlock.this.highlight(parent, labelControl, comboBox, 0);
                }
            }
        };
        comboBox.addMouseTrackListener((MouseTrackListener)labelComboListener);
        labelControl.addMouseTrackListener((MouseTrackListener)labelComboListener);
        class MouseMoveTrackListener
        extends MouseTrackAdapter
        implements MouseMoveListener,
        MouseListener {
            private final /* synthetic */ Combo val$comboBox;
            private final /* synthetic */ Composite val$parent;
            private final /* synthetic */ Label val$labelControl;

            MouseMoveTrackListener(Combo combo, Composite composite, Label label) {
                this.val$comboBox = combo;
                this.val$parent = composite;
                this.val$labelControl = label;
            }

            public void mouseExit(MouseEvent e) {
                if (!this.val$comboBox.isFocusControl()) {
                    OptionsConfigurationBlock.this.highlight(this.val$parent, this.val$labelControl, this.val$comboBox, 0);
                }
            }

            public void mouseMove(MouseEvent e) {
                int color = this.val$comboBox.isEnabled() ? (this.val$comboBox.isFocusControl() ? 17 : (this.isAroundLabel(e) ? 18 : 0)) : 0;
                OptionsConfigurationBlock.this.highlight(this.val$parent, this.val$labelControl, this.val$comboBox, color);
            }

            public void mouseDown(MouseEvent e) {
                if (this.isAroundLabel(e)) {
                    this.val$comboBox.setFocus();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }

            private boolean isAroundLabel(MouseEvent e) {
                int lx = this.val$labelControl.getLocation().x;
                Rectangle c = this.val$comboBox.getBounds();
                int x = e.x;
                int y = e.y;
                boolean isAroundLabel = lx - 5 < x && x < c.x && c.y - 2 < y && y < c.y + c.height + 2;
                return isAroundLabel;
            }
        }
        MouseMoveTrackListener parentListener = new MouseMoveTrackListener(comboBox, parent, labelControl);
        parent.addMouseMoveListener((MouseMoveListener)parentListener);
        parent.addMouseTrackListener((MouseTrackListener)parentListener);
        parent.addMouseListener((MouseListener)parentListener);
        MouseAdapter labelClickListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                comboBox.setFocus();
            }
        };
        labelControl.addMouseListener((MouseListener)labelClickListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void highlight(Composite parent, Label labelControl, Combo comboBox, int color) {
        Object data = labelControl.getData();
        if (data == null) {
            if (color == 0) return;
            HighlightPainter painter = new HighlightPainter(parent, labelControl, comboBox, color);
            parent.addPaintListener((PaintListener)painter);
            labelControl.setData((Object)painter);
        } else if (color == 0) {
            parent.removePaintListener((PaintListener)data);
            labelControl.setData(null);
        } else {
            if (color == ((HighlightPainter)data).fColor) return;
            ((HighlightPainter)data).fColor = color;
        }
        parent.redraw();
    }

    protected int getHighlight(Label labelControl) {
        Object data = labelControl.getData();
        if (data == null) {
            return 0;
        }
        return ((HighlightPainter)data).fColor;
    }

    protected Combo addInversedComboBox(Composite parent, String label, Key key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(composite, key, values, valueLabels);
        comboBox.setFont(JFaceResources.getDialogFont());
        comboBox.setLayoutData((Object)new GridData(256));
        Label labelControl = new Label(composite, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData());
        this.fLabels.put((Control)comboBox, labelControl);
        return comboBox;
    }

    protected Combo newComboControl(Composite composite, Key key, String[] values, String[] valueLabels) {
        ControlData data = new ControlData(key, values);
        Combo comboBox = new Combo(composite, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.addSelectionListener(this.getSelectionListener());
        comboBox.setFont(JFaceResources.getDialogFont());
        SWTUtil.setDefaultVisibleItemCount((Combo)comboBox);
        this.makeScrollableCompositeAware((Control)comboBox);
        this.updateCombo(comboBox);
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    protected Text addTextField(Composite parent, String label, Key key, int indent, int widthHint) {
        Label labelControl = new Label(parent, 64);
        labelControl.setText(label);
        labelControl.setFont(JFaceResources.getDialogFont());
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        this.makeScrollableCompositeAware((Control)textBox);
        this.fLabels.put((Control)textBox, labelControl);
        this.updateText(textBox);
        textBox.addModifyListener(this.getTextModifyListener());
        GridData data = new GridData(256);
        if (widthHint != 0) {
            data.widthHint = widthHint;
        }
        data.horizontalSpan = 2;
        textBox.setLayoutData((Object)data);
        this.fTextBoxes.add(textBox);
        return textBox;
    }

    protected Link addLink(Composite parent, String label, Key key, SelectionListener linkListener, int indent, int widthHint) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        gd.widthHint = widthHint;
        Link link = new Link(parent, 0);
        link.setFont(JFaceResources.getDialogFont());
        link.setText(label);
        link.setData((Object)key);
        link.setLayoutData((Object)gd);
        link.addSelectionListener(linkListener);
        this.makeScrollableCompositeAware((Control)link);
        this.fLinks.add(link);
        return link;
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected ExpandableComposite getParentExpandableComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ExpandableComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ExpandableComposite) {
            return (ExpandableComposite)parent;
        }
        return null;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        return this.createStyleSection(parent, label, nColumns, null);
    }

    protected ExpandableComposite createStyleSection(Composite parent, String label, int nColumns, Key key) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        if (key != null) {
            excomposite.setData((Object)key);
        }
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OptionsConfigurationBlock.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.fExpandableComposites.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    protected final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    protected void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandableComposites.size()) {
            ExpandableComposite excomposite = this.fExpandableComposites.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + String.valueOf(i)));
            }
            ++i;
        }
    }

    protected void storeSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandableComposites.size()) {
            ExpandableComposite curr = this.fExpandableComposites.get(i);
            settings.put(SETTINGS_EXPANDED + String.valueOf(i), curr.isExpanded());
            ++i;
        }
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OptionsConfigurationBlock.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.fTextModifyListener == null) {
            this.fTextModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OptionsConfigurationBlock.this.textChanged((Text)e.widget);
                }
            };
        }
        return this.fTextModifyListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            newValue = data.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        String oldValue = this.setValue(data.getKey(), newValue);
        this.validateSettings(data.getKey(), oldValue, newValue);
    }

    protected void textChanged(Text textControl) {
        Key key = (Key)textControl.getData();
        String number = textControl.getText();
        String oldValue = this.setValue(key, number);
        this.validateSettings(key, oldValue, number);
    }

    protected boolean checkValue(Key key, String value) {
        return value.equals(this.getValue(key));
    }

    protected String getValue(Key key) {
        if (this.fDisabledProjectSettings != null && this.fDisabledProjectSettings.get(key) != null) {
            return this.fDisabledProjectSettings.get(key);
        }
        return key.getStoredValue(this.fLookupOrder, false, this.fManager);
    }

    protected boolean getBooleanValue(Key key) {
        return Boolean.valueOf(this.getValue(key));
    }

    protected String setValue(Key key, String value) {
        if (this.fDisabledProjectSettings != null) {
            return this.fDisabledProjectSettings.put(key, value);
        }
        String oldValue = this.getValue(key);
        key.setStoredValue(this.fLookupOrder[0], value, this.fManager);
        return oldValue;
    }

    protected String setValue(Key key, boolean value) {
        return this.setValue(key, String.valueOf(value));
    }

    protected final void setDefaultValue(Key key, String value) {
        IScopeContext instanceScope = this.fLookupOrder[this.fLookupOrder.length - 1];
        key.setStoredValue(instanceScope, value, this.fManager);
    }

    protected String getStoredValue(Key key) {
        return key.getStoredValue(this.fLookupOrder, false, this.fManager);
    }

    protected String getOriginalStoredValue(Key key) {
        return key.getStoredValue(this.fLookupOrder, false, null);
    }

    protected void revertValues(Key[] keys) {
        int i = 0;
        while (i < keys.length) {
            Key curr = keys[i];
            String origValue = curr.getStoredValue(this.fLookupOrder, false, null);
            this.setValue(curr, origValue);
            ++i;
        }
    }

    protected abstract void validateSettings(Key var1, String var2, String var3);

    protected String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }

    private boolean getChanges(IScopeContext currContext, List<Key> changedSettings) {
        boolean completeSettings = this.fProject != null && this.fDisabledProjectSettings == null;
        boolean needsBuild = false;
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key key = this.fAllKeys[i];
            String oldVal = key.getStoredValue(currContext, null);
            String val = key.getStoredValue(currContext, this.fManager);
            if (val == null) {
                if (oldVal != null) {
                    changedSettings.add(key);
                    needsBuild |= !oldVal.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
                } else if (completeSettings) {
                    key.setStoredValue(currContext, key.getStoredValue(this.fLookupOrder, true, this.fManager), this.fManager);
                    changedSettings.add(key);
                }
            } else if (!val.equals(oldVal)) {
                changedSettings.add(key);
                needsBuild |= oldVal != null || !val.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
            }
            ++i;
        }
        return needsBuild;
    }

    public void useProjectSpecificSettings(boolean enable) {
        boolean hasProjectSpecificOption;
        boolean bl = hasProjectSpecificOption = this.fDisabledProjectSettings == null;
        if (enable != hasProjectSpecificOption && this.fProject != null) {
            if (enable) {
                int i = 0;
                while (i < this.fAllKeys.length) {
                    Key curr = this.fAllKeys[i];
                    String val = this.fDisabledProjectSettings.get(curr);
                    curr.setStoredValue(this.fLookupOrder[0], val, this.fManager);
                    ++i;
                }
                this.fDisabledProjectSettings = null;
                this.updateControls();
                this.validateSettings(null, null, null);
            } else {
                this.fDisabledProjectSettings = new IdentityHashMap<Key, String>();
                int i = 0;
                while (i < this.fAllKeys.length) {
                    Key curr = this.fAllKeys[i];
                    String oldSetting = curr.getStoredValue(this.fLookupOrder, false, this.fManager);
                    this.fDisabledProjectSettings.put(curr, oldSetting);
                    curr.setStoredValue(this.fLookupOrder[0], null, this.fManager);
                    ++i;
                }
            }
        }
    }

    public boolean areSettingsEnabled() {
        return this.fDisabledProjectSettings == null || this.fProject == null;
    }

    public boolean performOk() {
        return this.processChanges(this.fContainer);
    }

    public boolean performApply() {
        return this.processChanges(null);
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        String[] strings;
        int count;
        IScopeContext currContext = this.fLookupOrder[0];
        ArrayList<Key> changedOptions = new ArrayList<Key>();
        boolean needsBuild = this.getChanges(currContext, changedOptions);
        if (changedOptions.isEmpty()) {
            return true;
        }
        if (!this.checkChanges(currContext)) {
            return false;
        }
        if (needsBuild && (count = this.getRebuildCount()) > this.fRebuildCount) {
            needsBuild = false;
            this.fRebuildCount = count;
        }
        boolean doBuild = false;
        if (needsBuild && (strings = this.getFullBuildDialogStrings(this.fProject == null)) != null) {
            if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length == 0) {
                doBuild = true;
            } else {
                MessageDialog dialog = new MessageDialog(this.getShell(), strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int res = dialog.open();
                if (res == 0) {
                    doBuild = true;
                } else if (res != 1) {
                    return false;
                }
            }
        }
        if (container != null) {
            if (doBuild) {
                this.incrementRebuildCount();
                container.registerUpdateJob(CoreUtility.getBuildJob((IProject)this.fProject));
            }
        } else {
            try {
                this.fManager.applyChanges();
            }
            catch (BackingStoreException e) {
                PHPUiPlugin.log(e);
                return false;
            }
            if (doBuild) {
                CoreUtility.getBuildJob((IProject)this.fProject).schedule();
            }
        }
        return true;
    }

    protected boolean checkChanges(IScopeContext currContext) {
        return true;
    }

    protected abstract String[] getFullBuildDialogStrings(boolean var1);

    public void performDefaults() {
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            String defValue = curr.getStoredValue(this.fLookupOrder, true, this.fManager);
            this.setValue(curr, defValue);
            ++i;
        }
        this.settingsUpdated();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void performRevert() {
        this.revertValues(this.fAllKeys);
        this.settingsUpdated();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void dispose() {
    }

    protected void updateControls() {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            this.updateCheckBox(this.fCheckBoxes.get(i));
            --i;
        }
        i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            this.updateCombo(this.fComboBoxes.get(i));
            --i;
        }
        i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            this.updateText(this.fTextBoxes.get(i));
            --i;
        }
    }

    protected void updateCombo(Combo curr) {
        ControlData data = (ControlData)curr.getData();
        String currValue = this.getValue(data.getKey());
        curr.select(data.getSelection(currValue));
    }

    protected void updateCheckBox(Button curr) {
        String currValue;
        ControlData data = (ControlData)curr.getData();
        curr.setSelection(data.getSelection(currValue = this.getValue(data.getKey())) == 0);
    }

    protected void updateText(Text curr) {
        Key key = (Key)curr.getData();
        String currValue = this.getValue(key);
        if (currValue != null) {
            curr.setText(currValue);
        }
    }

    protected ExpandableComposite getExpandableComposite(Key key) {
        int i = this.fExpandableComposites.size() - 1;
        while (i >= 0) {
            ExpandableComposite curr = this.fExpandableComposites.get(i);
            Key data = (Key)curr.getData();
            if (key.equals(data)) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Button getCheckBox(Key key) {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            Button curr = this.fCheckBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Link getCheckBoxLink(Key key) {
        if (this.fCheckBoxes == null) {
            return null;
        }
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            Button curr = this.fCheckBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey()) && data instanceof LinkControlData) {
                return ((LinkControlData)data).getLink();
            }
            --i;
        }
        return null;
    }

    protected Combo getComboBox(Key key) {
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            Combo curr = this.fComboBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Text getTextControl(Key key) {
        int i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            Text curr = this.fTextBoxes.get(i);
            Key data = (Key)curr.getData();
            if (key.equals(data)) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Link getLink(Key key) {
        int i = this.fLinks.size() - 1;
        while (i >= 0) {
            Link curr = this.fLinks.get(i);
            Key data = (Key)curr.getData();
            if (key.equals(data)) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Control findControl(Key key) {
        Combo comboBox = this.getComboBox(key);
        if (comboBox != null) {
            return comboBox;
        }
        Button checkBox = this.getCheckBox(key);
        if (checkBox != null) {
            return checkBox;
        }
        Text text = this.getTextControl(key);
        if (text != null) {
            return text;
        }
        Link link = this.getLink(key);
        if (link != null) {
            return link;
        }
        return null;
    }

    protected void setComboEnabled(Key key, boolean enabled) {
        Combo combo = this.getComboBox(key);
        Label label = this.fLabels.get(combo);
        combo.setEnabled(enabled);
        label.setEnabled(enabled);
        if (!enabled) {
            this.highlight(combo.getParent(), label, combo, 0);
        }
    }

    protected void setTextFieldEnabled(Key key, boolean enabled) {
        Text text = this.getTextControl(key);
        Label label = this.fLabels.get(text);
        text.setEnabled(enabled);
        label.setEnabled(enabled);
    }

    protected static class ControlData {
        private final Key fKey;
        private final String[] fValues;

        public ControlData(Key key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public Key getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.fValues.length) {
                    if (value.equals(this.fValues[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.fValues.length - 1;
        }
    }

    private static class HighlightPainter
    implements PaintListener {
        private final Composite fParent;
        private final Label fLabelControl;
        private final Combo fComboBox;
        int fColor;

        public HighlightPainter(Composite parent, Label labelControl, Combo comboBox, int color) {
            this.fParent = parent;
            this.fLabelControl = labelControl;
            this.fComboBox = comboBox;
            this.fColor = color;
        }

        public void paintControl(PaintEvent e) {
            if (((GridData)this.fLabelControl.getLayoutData()).exclude) {
                this.fParent.removePaintListener((PaintListener)this);
                this.fLabelControl.setData(null);
                return;
            }
            int GAP = 7;
            int ARROW = 3;
            Rectangle l = this.fLabelControl.getBounds();
            Point c = this.fComboBox.getLocation();
            e.gc.setForeground(e.display.getSystemColor(this.fColor));
            int x2 = c.x - GAP;
            int y = l.y + l.height / 2 + 1;
            e.gc.drawLine(l.x + l.width + GAP, y, x2, y);
            e.gc.drawLine(x2 - ARROW, y - ARROW, x2, y);
            e.gc.drawLine(x2 - ARROW, y + ARROW, x2, y);
        }
    }

    protected static class LinkControlData
    extends ControlData {
        private Link fLink;

        public LinkControlData(Key key, String[] values) {
            super(key, values);
        }

        public void setLink(Link link) {
            this.fLink = link;
        }

        public Link getLink() {
            return this.fLink;
        }
    }

    private static class LocalKey
    extends Key {
        private final HashMap<IScopeContext, String> fValues = new HashMap();

        private LocalKey(String key) {
            super("local", key);
        }

        @Override
        public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
            return this.fValues.get(context);
        }

        @Override
        public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
            if (value != null) {
                this.fValues.put(context, value);
            } else {
                this.fValues.remove(context);
            }
        }
    }

    protected static class PreferenceTreeNode {
        public static final int NONE = 0;
        public static final int CHECKBOX = 1;
        public static final int COMBO = 2;
        public static final int EXPANDABLE_COMPOSITE = 3;
        public static final int TEXT_CONTROL = 4;
        public static final int LINK = 5;
        private final int fControlType;
        private final String fLabel;
        private final Key fKey;
        private final boolean fShowAllChildren;
        private boolean fVisible;
        private List<PreferenceTreeNode> fChildren;

        public PreferenceTreeNode(String label, Key key, int controlType, boolean showAllChildren) {
            if (controlType != 0 && (label == null || key == null)) {
                throw new IllegalArgumentException();
            }
            if (label == null) {
                label = "";
            }
            this.fLabel = LegacyActionTools.removeMnemonics((String)label);
            this.fKey = key;
            this.fControlType = controlType;
            this.fShowAllChildren = showAllChildren;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public Key getKey() {
            return this.fKey;
        }

        public int getControlType() {
            return this.fControlType;
        }

        public List<PreferenceTreeNode> getChildren() {
            return this.fChildren;
        }

        public boolean isShowAllChildren() {
            return this.fShowAllChildren;
        }

        public boolean isVisible() {
            return this.fVisible;
        }

        private void setVisible(boolean visible, boolean recursive) {
            this.fVisible = visible;
            if (!recursive) {
                return;
            }
            if (this.fChildren != null) {
                int i = 0;
                while (i < this.fChildren.size()) {
                    this.fChildren.get(i).setVisible(visible, recursive);
                    ++i;
                }
            }
        }

        public PreferenceTreeNode addChild(String label, Key key, int controlType, boolean showAllChildren) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList<PreferenceTreeNode>();
            }
            PreferenceTreeNode n = new PreferenceTreeNode(label, key, controlType, showAllChildren);
            this.fChildren.add(n);
            return n;
        }

        public boolean hasValue() {
            return this.fControlType == 2 || this.fControlType == 1 || this.fControlType == 4;
        }
    }
}

