/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class SaveActionsConfigurationBlock
extends PHPCoreOptionsConfigurationBlock {
    private static final int INDENT_VALUE = 20;
    private static final Key PREF_REMOVE_TRAILING_WHITESPACES = new Key("org.eclipse.php.ui", "cleanup.remove_trailing_whitespaces");
    private static final Key PREF_REMOVE_TRAILING_WHITESPACES_ALL = new Key("org.eclipse.php.ui", "cleanup.remove_trailing_whitespaces_all");
    private static final Key PREF_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY = new Key("org.eclipse.php.ui", "cleanup.remove_trailing_whitespaces_ignore_empty");
    private static final Key PREF_FORMAT_ON_SAVE = new Key("org.eclipse.php.ui", "cleanup.format.on.save");
    private Button removeTrailingWsCheckbox;
    private Button allCheckbox;
    private Button ignoreEmptyCheckbox;
    private Button formatOnSaveCheckbox;
    private boolean fRemoveWhitespaces;
    private boolean fAllLines;
    private boolean fIgnoreEmptyLines;
    private boolean fFormatOnSave;
    private IStatus fSaveActionsStatus = new StatusInfo();
    private Group removeWhitespacesGroup;

    private static Key[] getKeys() {
        return new Key[]{PREF_REMOVE_TRAILING_WHITESPACES, PREF_REMOVE_TRAILING_WHITESPACES_ALL, PREF_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY, PREF_FORMAT_ON_SAVE};
    }

    public SaveActionsConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, SaveActionsConfigurationBlock.getKeys(), container);
    }

    @Override
    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite removeWhiteSpaceComposite = this.createRemoveWhiteSpacesContent(parent);
        this.validateSettings(null, null, null);
        return removeWhiteSpaceComposite;
    }

    private Composite createRemoveWhiteSpacesContent(Composite parent) {
        Composite whiteSpacesComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 5;
        layout.marginBottom = 5;
        whiteSpacesComposite.setLayout((Layout)layout);
        whiteSpacesComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.removeTrailingWsCheckbox = new Button(whiteSpacesComposite, 32);
        this.removeTrailingWsCheckbox.setText(PHPUIMessages.SaveActionsConfigurationBlock_0);
        this.removeTrailingWsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveActionsConfigurationBlock.this.fRemoveWhitespaces = !SaveActionsConfigurationBlock.this.fRemoveWhitespaces;
                SaveActionsConfigurationBlock.this.updateValues();
            }
        });
        this.removeWhitespacesGroup = this.createGroup(2, whiteSpacesComposite, "");
        GridData data = new GridData();
        data.horizontalIndent += 20;
        this.removeWhitespacesGroup.setLayoutData((Object)data);
        this.allCheckbox = new Button((Composite)this.removeWhitespacesGroup, 16);
        this.allCheckbox.setText(PHPUIMessages.SaveActionsConfigurationBlock_2);
        this.allCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveActionsConfigurationBlock.this.fAllLines = true;
                SaveActionsConfigurationBlock.this.fIgnoreEmptyLines = false;
                SaveActionsConfigurationBlock.this.updateValues();
            }
        });
        this.ignoreEmptyCheckbox = new Button((Composite)this.removeWhitespacesGroup, 16);
        this.ignoreEmptyCheckbox.setText(PHPUIMessages.SaveActionsConfigurationBlock_3);
        this.ignoreEmptyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveActionsConfigurationBlock.this.fAllLines = false;
                SaveActionsConfigurationBlock.this.fIgnoreEmptyLines = true;
                SaveActionsConfigurationBlock.this.updateValues();
            }
        });
        this.formatOnSaveCheckbox = new Button(whiteSpacesComposite, 32);
        this.formatOnSaveCheckbox.setText(PHPUIMessages.SaveActionsConfigurationBlock_1);
        this.formatOnSaveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveActionsConfigurationBlock.this.fFormatOnSave = !SaveActionsConfigurationBlock.this.fFormatOnSave;
                SaveActionsConfigurationBlock.this.updateValues();
            }
        });
        this.updateControls();
        return whiteSpacesComposite;
    }

    @Override
    protected void updateControls() {
        this.initValues();
        this.updateValues();
    }

    private void initValues() {
        String remove = this.getValue(PREF_REMOVE_TRAILING_WHITESPACES);
        String all = this.getValue(PREF_REMOVE_TRAILING_WHITESPACES_ALL);
        String ignore = this.getValue(PREF_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY);
        String format = this.getValue(PREF_FORMAT_ON_SAVE);
        this.fRemoveWhitespaces = Boolean.valueOf(remove);
        this.fAllLines = Boolean.valueOf(all);
        this.fIgnoreEmptyLines = Boolean.valueOf(ignore);
        this.fFormatOnSave = Boolean.valueOf(format);
    }

    private void updateValues() {
        this.removeTrailingWsCheckbox.setSelection(this.fRemoveWhitespaces);
        this.removeWhitespacesGroup.setEnabled(this.fRemoveWhitespaces);
        if (this.fRemoveWhitespaces) {
            this.allCheckbox.setSelection(this.fAllLines);
            this.ignoreEmptyCheckbox.setSelection(this.fIgnoreEmptyLines);
        }
        this.allCheckbox.setEnabled(this.fRemoveWhitespaces);
        this.ignoreEmptyCheckbox.setEnabled(this.fRemoveWhitespaces);
        this.formatOnSaveCheckbox.setSelection(this.fFormatOnSave);
    }

    protected Group createGroup(int numColumns, Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        GridLayout layout = new GridLayout(numColumns, false);
        group.setLayout((Layout)layout);
        group.setText(text);
        return group;
    }

    @Override
    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (changedKey == null) {
            this.fSaveActionsStatus = new StatusInfo();
        }
        this.fContext.statusChanged(this.fSaveActionsStatus);
    }

    private void savePreferences() {
        this.setValue(PREF_REMOVE_TRAILING_WHITESPACES, this.fRemoveWhitespaces);
        this.setValue(PREF_REMOVE_TRAILING_WHITESPACES_ALL, this.fAllLines);
        this.setValue(PREF_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY, this.fIgnoreEmptyLines);
        this.setValue(PREF_FORMAT_ON_SAVE, this.fFormatOnSave);
    }

    @Override
    public boolean performApply() {
        this.savePreferences();
        return super.performApply();
    }

    @Override
    public boolean performOk() {
        this.savePreferences();
        return super.performOk();
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }
}

