/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.IPVariableElement;
import org.eclipse.php.internal.ui.preferences.includepath.IPVariableElementLabelProvider;
import org.eclipse.php.internal.ui.preferences.includepath.VariableCreationDialog;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class VariableBlock {
    private ListDialogField fVariablesList;
    private Control fControl;
    private boolean fHasChanges;
    private List fSelectedElements = new ArrayList(0);
    private boolean fAskToBuild;
    private boolean fInPreferencePage;

    public VariableBlock(boolean inPreferencePage, String initSelection) {
        this.fInPreferencePage = inPreferencePage;
        this.fAskToBuild = true;
        String[] buttonLabels = new String[]{PHPUIMessages.VariableBlock_vars_add_button, PHPUIMessages.VariableBlock_vars_edit_button, PHPUIMessages.VariableBlock_vars_remove_button};
        VariablesAdapter adapter = new VariablesAdapter();
        IPVariableElementLabelProvider labelProvider = new IPVariableElementLabelProvider(!inPreferencePage);
        this.fVariablesList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
        this.fVariablesList.setDialogFieldListener(adapter);
        this.fVariablesList.setLabelText(PHPUIMessages.VariableBlock_vars_label);
        this.fVariablesList.setRemoveButtonIndex(2);
        this.fVariablesList.enableButton(1, false);
        this.fVariablesList.setViewerSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IPVariableElement && e2 instanceof IPVariableElement) {
                    return ((IPVariableElement)e1).getName().compareTo(((IPVariableElement)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.refresh(initSelection);
    }

    public boolean hasChanges() {
        return this.fHasChanges;
    }

    public void setChanges(boolean hasChanges) {
        this.fHasChanges = hasChanges;
    }

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fVariablesList}, true, 0, 0);
        LayoutUtil.setHorizontalGrabbing(this.fVariablesList.getListControl(null));
        this.fControl = composite;
        return composite;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.fVariablesList.getTableViewer().addDoubleClickListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fVariablesList.getTableViewer().addSelectionChangedListener(listener);
    }

    private Shell getShell() {
        if (this.fControl != null) {
            return this.fControl.getShell();
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }

    private boolean containsReserved(List selected) {
        int i = selected.size() - 1;
        while (i >= 0) {
            if (((IPVariableElement)selected.get(i)).isReserved()) {
                return true;
            }
            --i;
        }
        return false;
    }

    private static void addAll(Object[] objs, Collection dest) {
        int i = 0;
        while (i < objs.length) {
            dest.add(objs[i]);
            ++i;
        }
    }

    private boolean canEdit(List selected, boolean containsReserved) {
        return selected.size() == 1 && !containsReserved;
    }

    private void doSelectionChanged(DialogField field) {
        List selected = this.fVariablesList.getSelectedElements();
        boolean containsReserved = this.containsReserved(selected);
        this.fVariablesList.enableButton(1, this.canEdit(selected, containsReserved));
        this.fVariablesList.enableButton(2, !containsReserved);
        this.fSelectedElements = selected;
    }

    private void editEntries(IPVariableElement entry) {
        List existingEntries = this.fVariablesList.getElements();
        VariableCreationDialog dialog = new VariableCreationDialog(this.getShell(), entry, existingEntries);
        if (dialog.open() != 0) {
            return;
        }
        IPVariableElement newEntry = dialog.getIncludePathElement();
        if (entry == null) {
            this.fVariablesList.addElement(newEntry);
            entry = newEntry;
            this.fHasChanges = true;
        } else {
            boolean hasChanges;
            boolean bl = hasChanges = !entry.getName().equals(newEntry.getName()) || !entry.getPath().equals((Object)newEntry.getPath());
            if (hasChanges) {
                this.fHasChanges = true;
                entry.setName(newEntry.getName());
                entry.setPath(newEntry.getPath());
                this.fVariablesList.refresh();
            }
        }
        this.fVariablesList.selectElements((ISelection)new StructuredSelection((Object)entry));
    }

    public List getSelectedElements() {
        return this.fSelectedElements;
    }

    public void performDefaults() {
        this.fVariablesList.removeAllElements();
        String[] reservedName = new String[]{};
        int i = 0;
        while (i < reservedName.length) {
            IPVariableElement elem = new IPVariableElement(reservedName[i], (IPath)Path.EMPTY, true);
            elem.setReserved(true);
            this.fVariablesList.addElement(elem);
            ++i;
        }
        this.fHasChanges = true;
    }

    public boolean performOk() {
        ArrayList removedVariables = new ArrayList();
        ArrayList<String> changedVariables = new ArrayList<String>();
        List changedElements = this.fVariablesList.getElements();
        List unchangedElements = this.fVariablesList.getElements();
        int i = changedElements.size() - 1;
        while (i >= 0) {
            IPVariableElement curr = (IPVariableElement)changedElements.get(i);
            if (curr.isReserved()) {
                changedElements.remove(curr);
            } else {
                IPath path = curr.getPath();
                Object prevPath = null;
                if (prevPath != null && prevPath.equals((Object)path)) {
                    changedElements.remove(curr);
                } else {
                    changedVariables.add(curr.getName());
                    unchangedElements.remove(curr);
                }
            }
            removedVariables.remove(curr.getName());
            --i;
        }
        int steps = changedElements.size() + removedVariables.size();
        if (steps > 0) {
            boolean needsBuild = false;
            if (this.fAskToBuild && this.doesChangeRequireFullBuild(removedVariables, changedVariables)) {
                String title = PHPUIMessages.VariableBlock_needsbuild_title;
                String message = PHPUIMessages.VariableBlock_needsbuild_message;
                MessageDialog buildDialog = new MessageDialog(this.getShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int res = buildDialog.open();
                if (res != 0 && res != 1) {
                    return false;
                }
                needsBuild = res == 0;
            }
            final VariableBlockRunnable runnable = new VariableBlockRunnable(removedVariables, changedElements, unchangedElements, needsBuild);
            Job buildJob = new Job(PHPUIMessages.VariableBlock_job_description){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            runnable.setVariables(monitor);
                        }
                        catch (CoreException e) {
                            IStatus iStatus = e.getStatus();
                            monitor.done();
                            return iStatus;
                        }
                        catch (OperationCanceledException e) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            monitor.done();
                            return iStatus;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
            buildJob.setUser(true);
            buildJob.schedule();
            return true;
        }
        return true;
    }

    private boolean doesChangeRequireFullBuild(List removed, List changed) {
        return false;
    }

    public void setAskToBuild(boolean askToBuild) {
        this.fAskToBuild = askToBuild;
    }

    public void refresh(String initSelection) {
        Object initSelectedElement = null;
        if (initSelectedElement != null) {
            StructuredSelection sel = new StructuredSelection(initSelectedElement);
            this.fVariablesList.selectElements((ISelection)sel);
        } else {
            this.fVariablesList.selectFirstElement();
        }
        this.fHasChanges = false;
    }

    private class VariableBlockRunnable
    implements IRunnableWithProgress {
        private List fToRemove;
        private List fToChange;
        private List fUnchanged;
        private boolean fDoBuild;

        public VariableBlockRunnable(List toRemove, List toChange, List unchanged, boolean doBuild) {
            this.fToRemove = toRemove;
            this.fToChange = toChange;
            this.fUnchanged = unchanged;
            this.fDoBuild = doBuild;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(PHPUIMessages.VariableBlock_operation_desc, this.fDoBuild ? 2 : 1);
            try {
                try {
                    this.setVariables(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException();
                }
            }
            finally {
                monitor.done();
            }
        }

        public void setVariables(IProgressMonitor monitor) throws CoreException {
            IPVariableElement curr;
            int nVariables = this.fToChange.size() + this.fToRemove.size() + this.fUnchanged.size();
            String[] names = new String[nVariables];
            IPath[] paths = new IPath[nVariables];
            int k = 0;
            int i = 0;
            while (i < this.fUnchanged.size()) {
                curr = (IPVariableElement)this.fUnchanged.get(i);
                names[k] = curr.getName();
                paths[k] = curr.getPath();
                ++k;
                ++i;
            }
            i = 0;
            while (i < this.fToChange.size()) {
                curr = (IPVariableElement)this.fToChange.get(i);
                names[k] = curr.getName();
                paths[k] = curr.getPath();
                ++k;
                ++i;
            }
            i = 0;
            while (i < this.fToRemove.size()) {
                names[k] = (String)this.fToRemove.get(i);
                paths[k] = null;
                ++k;
                ++i;
            }
            if (this.fDoBuild) {
                ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
    }

    private class VariablesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        private VariablesAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    VariableBlock.this.editEntries(null);
                    break;
                }
                case 1: {
                    List selected = field.getSelectedElements();
                    VariableBlock.this.editEntries((IPVariableElement)selected.get(0));
                }
            }
        }

        public void selectionChanged(ListDialogField field) {
            VariableBlock.this.doSelectionChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
            List selected;
            if (VariableBlock.this.fInPreferencePage && VariableBlock.this.canEdit(selected = field.getSelectedElements(), VariableBlock.this.containsReserved(selected))) {
                VariableBlock.this.editEntries((IPVariableElement)selected.get(0));
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }
    }
}

