/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.wizards.NewElementWizard;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardFirstPage;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardSecondPage;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardThirdPage;
import org.eclipse.php.internal.ui.wizards.WizardModel;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class PHPProjectCreationWizard
extends NewElementWizard
implements INewWizard,
IExecutableExtension {
    public static final String SELECTED_PROJECT = "SelectedProject";
    public static final String WIZARD_ID = "org.eclipse.php.wizards.newproject";
    protected PHPProjectWizardFirstPage fFirstPage;
    protected PHPProjectWizardSecondPage fSecondPage;
    protected PHPProjectWizardThirdPage fThirdPage;
    protected PHPProjectWizardSecondPage fLastPage;
    protected IConfigurationElement fConfigElement;
    protected int fLastPageIndex = -1;

    public PHPProjectCreationWizard() {
        this.setDefaultPageImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_PHP_PROJECT);
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PHPUIMessages.PHPProjectCreationWizard_WizardTitle);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new PHPProjectWizardFirstPage();
        this.fFirstPage.setTitle(PHPUIMessages.PHPProjectCreationWizard_Page1Title);
        this.fFirstPage.setDescription(PHPUIMessages.PHPProjectCreationWizard_Page1Description);
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new PHPProjectWizardSecondPage(this.fFirstPage);
        this.fSecondPage.setTitle(PHPUIMessages.PHPProjectCreationWizard_Page2Title);
        this.fSecondPage.setDescription(PHPUIMessages.PHPProjectCreationWizard_Page2Description);
        this.addPage((IWizardPage)this.fSecondPage);
        this.fThirdPage = new PHPProjectWizardThirdPage(this.fFirstPage);
        this.fThirdPage.setTitle(PHPUIMessages.PHPProjectCreationWizard_Page3Title);
        this.fThirdPage.setDescription(PHPUIMessages.PHPProjectCreationWizard_Page3Description);
        this.addPage((IWizardPage)this.fThirdPage);
        this.fLastPage = this.fSecondPage;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.fFirstPage != null) {
            this.fFirstPage.performFinish(monitor);
        }
        if (this.fSecondPage != null) {
            this.fSecondPage.performFinish(monitor);
        }
        if (this.fThirdPage != null) {
            this.fThirdPage.performFinish(monitor);
        }
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            if (this.updatePerspective()) {
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            }
            this.selectAndReveal((IResource)this.fLastPage.getScriptProject().getProject());
            IProject project = this.fLastPage.getScriptProject().getProject();
            PHPVersion version = this.fFirstPage.getPHPVersionValue();
            if (version == null) {
                version = ProjectOptions.getDefaultPhpVersion();
            }
            try {
                PHPFacets.createFacetedProject((IProject)project, (PHPVersion)version, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                PHPCorePlugin.log((Throwable)ex);
            }
            WizardModel model = this.fFirstPage.getWizardData();
            Object eanblement = null;
            if (model != null) {
                eanblement = model.getObject("REMOTE_GROUP_REMOTE_PROJECT_ENABLED");
            }
            if (model != null && eanblement != null && ((Boolean)eanblement).booleanValue()) {
                model.putObject(SELECTED_PROJECT, this.fLastPage.getScriptProject().getProject());
                IRunnableWithProgress run = (IRunnableWithProgress)Platform.getAdapterManager().getAdapter((Object)model, IRunnableWithProgress.class);
                if (run != null) {
                    try {
                        this.getContainer().run(true, false, run);
                    }
                    catch (InvocationTargetException e) {
                        this.handleFinishException(this.getShell(), e);
                        return false;
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
            }
        }
        return res;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        if (!this.fFirstPage.isExistingLocation()) {
            this.fFirstPage.performCancel();
        }
        return super.performCancel();
    }

    public IModelElement getCreatedElement() {
        return DLTKCore.create((IProject)this.fFirstPage.getProjectHandle());
    }

    public int getLastPageIndex() {
        return this.fLastPageIndex;
    }

    public void setLastPageIndex(int current) {
        this.fLastPageIndex = current;
    }

    protected boolean updatePerspective() {
        return true;
    }
}

