/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.test;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.php.composer.test.ComposerCoreTestPlugin;
import org.eclipse.php.composer.test.ComposerModelTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.junit.Test;

public class NamespaceResolverTest
extends ComposerModelTests {
    public NamespaceResolverTest() {
        super("Namespace Resolver tests");
    }

    @Test
    public void testNamespaceResolver() throws CoreException, IOException {
        IScriptProject scriptProject = this.ensureScriptProject("namespace-resolver");
        NamespaceResolverTest.assertNotNull((Object)scriptProject);
        IProjectDescription desc = scriptProject.getProject().getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        scriptProject.getProject().setDescription(desc, null);
        ProjectOptions.setPhpVersion((PHPVersion)PHPVersion.PHP5_3, (IProject)scriptProject.getProject());
        PHPFacets.setFacetedVersion((IProject)scriptProject.getProject(), (PHPVersion)PHPVersion.PHP5_3);
        FacetManager.installFacets((IProject)scriptProject.getProject(), (PHPVersion)PHPVersion.PHP5_3, (IProgressMonitor)new NullProgressMonitor());
        scriptProject.getProject().refreshLocal(2, null);
        scriptProject.getProject().build(6, null);
        ComposerCoreTestPlugin.waitForIndexer();
        ComposerCoreTestPlugin.waitForAutoBuild();
        IComposerProject project = ComposerPlugin.getDefault().getComposerProject(scriptProject);
        IFile composerJson = project.getComposerJson();
        NamespaceResolverTest.assertNotNull((Object)composerJson);
        NamespaceResolverTest.assertTrue((boolean)scriptProject.getProject().hasNature("org.eclipse.php.core.PHPNature"));
        NamespaceResolverTest.assertTrue((boolean)FacetManager.hasComposerFacet((IProject)scriptProject.getProject()));
        NamespaceResolverTest.assertEquals((String)"Foo\\Bar", (String)project.getNamespace((IPath)new Path("src/Foo/Bar")));
        NamespaceResolverTest.assertEquals((String)"Foo\\Bar\\Baz", (String)project.getNamespace((IPath)new Path("src/Foo/Bar/Baz")));
        NamespaceResolverTest.assertEquals((String)"Hello\\World", (String)project.getNamespace((IPath)new Path("src/HelloWorld")));
        NamespaceResolverTest.assertEquals((String)"", (String)project.getNamespace((IPath)new Path("src/Null/")));
        NamespaceResolverTest.assertEquals((String)"Wurst", (String)project.getNamespace((IPath)new Path("src/Null/Wurst")));
        NamespaceResolverTest.assertEquals((String)"Blut\\Wurst", (String)project.getNamespace((IPath)new Path("src/Null/Blut/Wurst")));
    }
}

