/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.parts.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.composer.api.ComposerConstants;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.RepositoryPackage;
import org.eclipse.php.composer.api.collection.Versions;
import org.eclipse.php.composer.api.entities.Version;
import org.eclipse.php.composer.api.packages.AsyncPackagistDownloader;
import org.eclipse.php.composer.api.packages.PackageListenerInterface;
import org.eclipse.php.composer.ui.parts.composer.Messages;
import org.eclipse.php.composer.ui.utils.WidgetFactory;
import org.eclipse.php.composer.ui.utils.WidgetHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class VersionSuggestion {
    private static final int RECENT = 0;
    private static final int CUSTOM = 1;
    private Text target;
    private Composite body;
    private Button recentMinor;
    private Button recentMajor;
    private Button noConstraint;
    private Map<String, Button> constraintButtons = new HashMap<String, Button>();
    private boolean uiFinished = false;
    private boolean dataArrived = false;
    private RepositoryPackage pkg;
    private String majorVersion;
    private String minorVersion;
    private Version version = new Version();
    private Version customVersion = new Version();
    private int lastUpdate;
    private boolean updatingTarget = false;
    private TableViewer versions;
    private Combo stabilityOverride;
    private Group custom;
    private Composite right;
    private ComposerPackage composerPackage;

    public VersionSuggestion(String name, Composite parent, Text target, ComposerPackage composerPackage, FormToolkit toolkit) {
        this(name, parent, target, composerPackage, new WidgetFactory(toolkit));
    }

    public VersionSuggestion(String name, Composite parent, Text target, ComposerPackage composerPackage, WidgetFactory factory) {
        this.target = target;
        this.composerPackage = composerPackage;
        AsyncPackagistDownloader downloader = new AsyncPackagistDownloader();
        downloader.addPackageListener(new PackageListenerInterface(){

            public void packageLoaded(RepositoryPackage repositoryPackage) {
                VersionSuggestion.this.dataArrived = true;
                VersionSuggestion.this.pkg = repositoryPackage;
                Versions versions = VersionSuggestion.this.pkg.getVersions();
                VersionSuggestion.this.majorVersion = versions.getRecentMajor();
                VersionSuggestion.this.minorVersion = versions.getRecentMinor(VersionSuggestion.this.majorVersion);
                if (!VersionSuggestion.this.updatingTarget) {
                    VersionSuggestion.this.updateUI();
                }
            }

            public void errorOccured(Exception e) {
                e.printStackTrace();
            }

            public void aborted(String url) {
            }
        });
        downloader.loadPackage(name);
        this.create(parent, factory);
    }

    private void create(Composite parent, WidgetFactory factory) {
        this.body = factory.createComposite(parent);
        this.body.setLayoutData((Object)new GridData(4, 4, true, false));
        this.body.setLayout((Layout)new GridLayout());
        this.body.setBackground(parent.getBackground());
        WidgetHelper.trimComposite(this.body, 0, 0, 0, 0, 0, 0);
        Group suggestions = new Group(this.body, 4);
        suggestions.setText(Messages.VersionSuggestion_SuggestionsLabel);
        suggestions.setLayoutData((Object)new GridData(4, 4, true, true));
        suggestions.setLayout((Layout)new GridLayout(2, true));
        suggestions.setBackground(parent.getBackground());
        WidgetHelper.trimComposite((Composite)suggestions, 0, 0, 0, 0, 0, 5);
        this.recentMajor = factory.createButton((Composite)suggestions);
        this.recentMajor.setAlignment(0x1000000);
        this.recentMajor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.recentMajor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionSuggestion.this.lastUpdate = 0;
                VersionSuggestion.this.version.setVersion("~" + VersionSuggestion.this.recentMajor.getData());
            }
        });
        this.recentMinor = factory.createButton((Composite)suggestions);
        this.recentMinor.setAlignment(0x1000000);
        this.recentMinor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.recentMinor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionSuggestion.this.lastUpdate = 0;
                VersionSuggestion.this.version.setVersion("~" + VersionSuggestion.this.recentMajor.getData() + "." + VersionSuggestion.this.recentMinor.getData());
            }
        });
        this.custom = new Group(this.body, 16);
        this.custom.setText(Messages.VersionSuggestion_CustomLabel);
        this.custom.setLayoutData((Object)new GridData(4, 4, true, true));
        this.custom.setLayout((Layout)new GridLayout(2, false));
        this.custom.setBackground(parent.getBackground());
        WidgetHelper.trimComposite((Composite)this.custom, 0, 0, 0, 0, 0, 5);
        VersionController controller = new VersionController();
        this.versions = new TableViewer((Composite)this.custom, 2820);
        this.versions.getTable().setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.versions.setContentProvider((IContentProvider)controller);
        this.versions.setLabelProvider((IBaseLabelProvider)controller);
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = 65;
        this.versions.getTable().setLayoutData((Object)gd);
        this.versions.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object elem = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (elem instanceof Version) {
                    VersionSuggestion.this.prepareCustomVersion();
                    Version v = (Version)elem;
                    VersionSuggestion.this.customVersion.setMajor(v.getMajor());
                    VersionSuggestion.this.customVersion.setMinor(v.getMinor());
                    VersionSuggestion.this.customVersion.setFix(v.getFix());
                    VersionSuggestion.this.customVersion.setDevPosition(v.getDevPosition());
                    VersionSuggestion.this.customVersion.setStability(v.getStability());
                    VersionSuggestion.this.customVersion.setSuffix(v.getSuffix());
                    VersionSuggestion.this.version.from(VersionSuggestion.this.customVersion);
                }
            }
        });
        this.versions.setComparator((ViewerComparator)new VersionSorter());
        this.right = factory.createComposite((Composite)this.custom, 0);
        this.right.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.right.setLayout((Layout)new GridLayout(3, false));
        this.right.setBackground(parent.getBackground());
        WidgetHelper.trimComposite(this.right, -5, -5, -5, -5, 0, 0);
        Label constraintsLbl = factory.createLabel(this.right, 0);
        constraintsLbl.setText(Messages.VersionSuggestion_ConstraintsLabel);
        constraintsLbl.setBackground(this.right.getBackground());
        constraintsLbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.noConstraint = factory.createButton(this.right, 16);
        this.noConstraint.setText(Messages.VersionSuggestion_NoneLabel);
        this.noConstraint.setBackground(this.right.getBackground());
        this.noConstraint.setSelection(true);
        this.noConstraint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (VersionSuggestion.this.prepareCustomVersion()) {
                    VersionSuggestion.this.customVersion.setConstraint("");
                    VersionSuggestion.this.version.from(VersionSuggestion.this.customVersion);
                }
            }
        });
        String[] stringArray = new String[]{"~", ">", ">=", "!=", "<", ">="};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String constraint = stringArray[n2];
            Button c = factory.createButton(this.right, 16);
            c.setText(constraint);
            c.setBackground(this.right.getBackground());
            c.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (VersionSuggestion.this.prepareCustomVersion()) {
                        VersionSuggestion.this.customVersion.setConstraint(((Button)e.getSource()).getText());
                        VersionSuggestion.this.version.from(VersionSuggestion.this.customVersion);
                    }
                }
            });
            this.constraintButtons.put(constraint, c);
            ++n2;
        }
        Label stabilityLbl = factory.createLabel(this.right);
        stabilityLbl.setText(Messages.VersionSuggestion_StabilityLabel);
        stabilityLbl.setBackground(this.custom.getBackground());
        gd = new GridData(4, 0x1000000, true, false, 3, 1);
        gd.verticalIndent = 10;
        stabilityLbl.setLayoutData((Object)gd);
        this.stabilityOverride = factory.createCombo(this.right, 0x800008);
        this.stabilityOverride.setItems((String[])ArrayUtils.addAll((Object[])new String[]{""}, (Object[])ComposerConstants.STABILITIES));
        this.stabilityOverride.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.stabilityOverride.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (VersionSuggestion.this.prepareCustomVersion()) {
                    VersionSuggestion.this.customVersion.setStabilityModifier(VersionSuggestion.this.stabilityOverride.getItem(VersionSuggestion.this.stabilityOverride.getSelectionIndex()));
                    VersionSuggestion.this.version.from(VersionSuggestion.this.customVersion);
                }
            }
        });
        this.uiFinished = true;
        this.updateUI();
        this.version.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                VersionSuggestion.this.updateTarget();
            }
        });
    }

    private void updateUI() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (VersionSuggestion.this.uiFinished) {
                    VersionSuggestion.this.recentMajor.setText(String.valueOf(Messages.VersionSuggestion_MajorLabel) + (VersionSuggestion.this.dataArrived && VersionSuggestion.this.majorVersion != null ? "~" + VersionSuggestion.this.majorVersion : Messages.VersionSuggestion_NAValue));
                    VersionSuggestion.this.recentMajor.setEnabled(VersionSuggestion.this.dataArrived && VersionSuggestion.this.majorVersion != null);
                    VersionSuggestion.this.recentMajor.setData((Object)VersionSuggestion.this.majorVersion);
                    VersionSuggestion.this.recentMinor.setText(String.valueOf(Messages.VersionSuggestion_MinorLabel) + (VersionSuggestion.this.dataArrived && VersionSuggestion.this.majorVersion != null && VersionSuggestion.this.minorVersion != null ? "~" + VersionSuggestion.this.majorVersion + "." + VersionSuggestion.this.minorVersion : Messages.VersionSuggestion_NAValue));
                    VersionSuggestion.this.recentMinor.setEnabled(VersionSuggestion.this.dataArrived && VersionSuggestion.this.minorVersion != null);
                    VersionSuggestion.this.recentMinor.setData((Object)VersionSuggestion.this.minorVersion);
                    VersionSuggestion.this.custom.setEnabled(VersionSuggestion.this.dataArrived);
                    VersionSuggestion.this.versions.getTable().setEnabled(VersionSuggestion.this.dataArrived);
                    VersionSuggestion.this.stabilityOverride.setEnabled(VersionSuggestion.this.dataArrived);
                    Control[] controlArray = VersionSuggestion.this.right.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        if (child instanceof Button) {
                            ((Button)child).setEnabled(VersionSuggestion.this.dataArrived);
                        }
                        ++n2;
                    }
                    if (VersionSuggestion.this.dataArrived) {
                        VersionSuggestion.this.versions.setInput((Object)VersionSuggestion.this.pkg.getVersions());
                    }
                }
            }
        });
    }

    private void updateTarget() {
        String v;
        this.updatingTarget = true;
        if ((this.lastUpdate == 0 || this.version.getMajor() != null && !this.version.getMajor().isEmpty() && this.version.getMajor() != "null") && (v = this.version.toString()) != null) {
            this.target.setText(v);
        }
        this.updatingTarget = false;
    }

    private boolean prepareCustomVersion() {
        if (this.updatingTarget) {
            return false;
        }
        if (this.lastUpdate == 0) {
            this.version.clear();
        }
        this.lastUpdate = 1;
        return true;
    }

    public Composite getBody() {
        return this.body;
    }

    private class VersionController
    extends StyledCellLabelProvider
    implements IStructuredContentProvider {
        private Versions versions;

        private VersionController() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.versions = (Versions)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.versions.getDetailedVersions().toArray();
        }

        public void update(ViewerCell cell) {
            Object obj = cell.getElement();
            if (obj instanceof Version) {
                Version v = (Version)obj;
                StyledString styledString = new StyledString(v.toString());
                styledString.append(" : " + v.getStability(), StyledString.QUALIFIER_STYLER);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
                super.update(cell);
            }
        }
    }

    private class VersionSorter
    extends ViewerComparator {
        private VersionSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Version && e2 instanceof Version) {
                return ((Version)e1).compareTo((Version)e2) * -1;
            }
            return 0;
        }
    }
}

