/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.FinallyClause;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class TryStatement
extends Statement {
    private Block tryStatement;
    private ASTNode.NodeList<CatchClause> catchClauses = new ASTNode.NodeList(this, CATCH_CLAUSES_PROPERTY);
    private FinallyClause finallyClause;
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(TryStatement.class, "tryStatement", Block.class, true, true);
    public static final ChildListPropertyDescriptor CATCH_CLAUSES_PROPERTY = new ChildListPropertyDescriptor(TryStatement.class, "catchClauses", CatchClause.class, true);
    public static final ChildPropertyDescriptor FINALLY_CLAUSE_PROPERTY = new ChildPropertyDescriptor(TryStatement.class, "finallyClause", FinallyClause.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(3);
        propertyList.add(BODY_PROPERTY);
        propertyList.add(CATCH_CLAUSES_PROPERTY);
        propertyList.add(FINALLY_CLAUSE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public static List<StructuralPropertyDescriptor> propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public TryStatement(int start, int end, AST ast, Block tryStatement, List<CatchClause> catchClauses) {
        super(start, end, ast);
        if (tryStatement == null || catchClauses == null) {
            throw new IllegalArgumentException();
        }
        this.setBody(tryStatement);
        this.catchClauses.addAll(catchClauses);
    }

    public TryStatement(int start, int end, AST ast, Block tryStatement, List<CatchClause> catchClauses, FinallyClause finallyClause) {
        super(start, end, ast);
        if (tryStatement == null || catchClauses == null) {
            throw new IllegalArgumentException();
        }
        this.setBody(tryStatement);
        this.catchClauses.addAll(catchClauses);
        this.setFinallyClause(finallyClause);
    }

    public TryStatement(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.tryStatement.accept(visitor);
        for (ASTNode aSTNode : this.catchClauses) {
            aSTNode.accept(visitor);
        }
        if (this.finallyClause != null) {
            this.finallyClause.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.tryStatement.traverseTopDown(visitor);
        for (ASTNode aSTNode : this.catchClauses) {
            aSTNode.traverseTopDown(visitor);
        }
        if (this.finallyClause != null) {
            this.finallyClause.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.tryStatement.traverseBottomUp(visitor);
        for (ASTNode aSTNode : this.catchClauses) {
            aSTNode.traverseBottomUp(visitor);
        }
        if (this.finallyClause != null) {
            this.finallyClause.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<TryStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.tryStatement.toString(buffer, "\t" + tab);
        buffer.append("\n");
        for (ASTNode aSTNode : this.catchClauses) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        if (this.finallyClause != null) {
            this.finallyClause.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</TryStatement>");
    }

    @Override
    public int getType() {
        return 58;
    }

    public Block getBody() {
        return this.tryStatement;
    }

    public void setBody(Block body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        Block oldChild = this.tryStatement;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.tryStatement = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public FinallyClause finallyClause() {
        return this.finallyClause;
    }

    public void setFinallyClause(FinallyClause clause) {
        FinallyClause oldChild = this.finallyClause;
        this.preReplaceChild(oldChild, clause, FINALLY_CLAUSE_PROPERTY);
        this.finallyClause = clause;
        this.postReplaceChild(oldChild, clause, FINALLY_CLAUSE_PROPERTY);
    }

    public List<CatchClause> catchClauses() {
        return this.catchClauses;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Block body = ASTNode.copySubtree(target, this.getBody());
        List<CatchClause> catchs = ASTNode.copySubtrees(target, this.catchClauses);
        FinallyClause finallyClause = ASTNode.copySubtree(target, this.finallyClause);
        return new TryStatement(this.getStart(), this.getEnd(), target, body, catchs, finallyClause);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        if (property == FINALLY_CLAUSE_PROPERTY) {
            if (get) {
                return this.finallyClause();
            }
            this.setFinallyClause((FinallyClause)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == CATCH_CLAUSES_PROPERTY) {
            return this.catchClauses();
        }
        return super.internalGetChildListProperty(property);
    }
}

