/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class UseStatement
extends Statement {
    public static final int T_NONE = 0;
    public static final int T_FUNCTION = 1;
    public static final int T_CONST = 2;
    private final ASTNode.NodeList<UseStatementPart> parts = new ASTNode.NodeList(this, PARTS_PROPERTY);
    private int statementType;
    private NamespaceName namespace;
    public static final ChildListPropertyDescriptor PARTS_PROPERTY = new ChildListPropertyDescriptor(UseStatement.class, "parts", UseStatementPart.class, false);
    public static final SimplePropertyDescriptor STATEMENT_TYPE_PROPERTY = new SimplePropertyDescriptor(UseStatement.class, "statementType", Integer.class, false);
    public static final ChildPropertyDescriptor NAMESPACE_PROPERTY = new ChildPropertyDescriptor(UseStatement.class, "namespace", NamespaceName.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(3);
        properyList.add(PARTS_PROPERTY);
        properyList.add(STATEMENT_TYPE_PROPERTY);
        properyList.add(NAMESPACE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public UseStatement(AST ast) {
        super(ast);
    }

    public UseStatement(int start, int end, AST ast, List<UseStatementPart> parts) {
        this(start, end, ast, parts, 0);
    }

    public UseStatement(int start, int end, AST ast, List<UseStatementPart> parts, int statementType) {
        this(start, end, ast, null, parts, statementType);
    }

    public UseStatement(int start, int end, AST ast, NamespaceName namespace, List<UseStatementPart> parts) {
        this(start, end, ast, namespace, parts, 0);
    }

    public UseStatement(int start, int end, AST ast, NamespaceName namespace, List<UseStatementPart> parts, int statementType) {
        super(start, end, ast);
        if (parts == null || parts.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.setNamespace(namespace);
        Iterator<UseStatementPart> it = parts.iterator();
        while (it.hasNext()) {
            this.parts.add(it.next());
        }
        this.setStatementType(statementType);
    }

    public UseStatement(int start, int end, AST ast, UseStatementPart[] parts, int statementType) {
        super(start, end, ast);
        if (parts == null || parts.length == 0) {
            throw new IllegalArgumentException();
        }
        UseStatementPart[] useStatementPartArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatementPart part = useStatementPartArray[n2];
            this.parts.add(part);
            ++n2;
        }
        this.setStatementType(statementType);
    }

    public UseStatement(int start, int end, AST ast, UseStatementPart[] parts) {
        this(start, end, ast, parts, 0);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        if (this.getNamespace() != null) {
            this.getNamespace().accept(visitor);
        }
        for (ASTNode aSTNode : this.parts) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.getNamespace() != null) {
            this.getNamespace().traverseTopDown(visitor);
        }
        for (ASTNode aSTNode : this.parts) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.getNamespace() != null) {
            this.getNamespace().traverseBottomUp(visitor);
        }
        for (ASTNode aSTNode : this.parts) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<UseStatement");
        this.appendInterval(buffer);
        if (this.getStatementType() != 0) {
            buffer.append(" statementType='").append(this.getStatementType()).append("'");
        }
        buffer.append(">\n");
        if (this.getNamespace() != null) {
            this.getNamespace().toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        for (UseStatementPart part : this.parts) {
            part.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</UseStatement>");
    }

    @Override
    public int getType() {
        return 67;
    }

    public List<UseStatementPart> parts() {
        return this.parts;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public void setStatementType(int statementType) {
        this.preValueChange(STATEMENT_TYPE_PROPERTY);
        this.statementType = statementType;
        this.postValueChange(STATEMENT_TYPE_PROPERTY);
    }

    public NamespaceName getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceName namespace) {
        NamespaceName oldChild = this.namespace;
        this.preReplaceChild(oldChild, namespace, NAMESPACE_PROPERTY);
        this.namespace = namespace;
        this.postReplaceChild(oldChild, namespace, NAMESPACE_PROPERTY);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == PARTS_PROPERTY) {
            return this.parts();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAMESPACE_PROPERTY) {
            if (get) {
                return this.getNamespace();
            }
            this.setNamespace((NamespaceName)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == STATEMENT_TYPE_PROPERTY) {
            if (get) {
                return this.getStatementType();
            }
            this.setStatementType(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List<UseStatementPart> parts = ASTNode.copySubtrees(target, this.parts());
        NamespaceName namespace = ASTNode.copySubtree(target, this.getNamespace());
        return new UseStatement(this.getStart(), this.getEnd(), target, namespace, parts, this.getStatementType());
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

