/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.CaseDefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.CommentIndentationStrategy;
import org.eclipse.php.internal.core.format.CurlyCloseIndentationStrategy;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.php.internal.core.format.IndentationObject;
import org.eclipse.php.internal.core.format.PHPCloseTagIndentationStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.text.rules.SimpleStructuredRegion;

public class PhpIndentationFormatter {
    private final IIndentationStrategy defaultIndentationStrategy;
    private final IIndentationStrategy curlyCloseIndentationStrategy;
    private final IIndentationStrategy caseDefaultIndentationStrategy;
    private final IIndentationStrategy commentIndentationStrategy;
    private final IIndentationStrategy phpCloseTagIndentationStrategy;
    private final int length;
    private final int start;
    private static final byte CHAR_TAB = 9;
    private static final byte CHAR_SPACE = 32;
    private final StringBuffer resultBuffer = new StringBuffer();
    private final StringBuffer lastEmptyLineIndentationBuffer = new StringBuffer();
    private int lastEmptyLineNumber;
    private boolean isInHeredoc;
    @Deprecated
    private Set<Integer> ignoreLines = new HashSet<Integer>();

    public PhpIndentationFormatter(int start, int length, IndentationObject indentationObject) {
        this.start = start;
        this.length = length;
        this.defaultIndentationStrategy = new DefaultIndentationStrategy(indentationObject);
        this.curlyCloseIndentationStrategy = new CurlyCloseIndentationStrategy();
        this.caseDefaultIndentationStrategy = new CaseDefaultIndentationStrategy(indentationObject);
        this.commentIndentationStrategy = new CommentIndentationStrategy(indentationObject);
        this.phpCloseTagIndentationStrategy = new PHPCloseTagIndentationStrategy(indentationObject);
    }

    protected void reset() {
        this.resultBuffer.setLength(0);
        this.lastEmptyLineIndentationBuffer.setLength(0);
        this.lastEmptyLineNumber = -1;
        this.isInHeredoc = false;
    }

    public void format(IStructuredDocumentRegion sdRegion) {
        assert (sdRegion != null);
        this.reset();
        int regionStart = sdRegion.getStartOffset();
        int regionEnd = sdRegion.getEndOffset();
        int formatRequestStart = this.getStart();
        int formatRequestEnd = formatRequestStart + this.getLength();
        int startFormat = Math.max(formatRequestStart, regionStart);
        int endFormat = Math.min(formatRequestEnd, regionEnd);
        IStructuredDocument document = sdRegion.getParentDocument();
        int lineIndex = document.getLineOfOffset(startFormat);
        int endLineIndex = document.getLineOfOffset(endFormat);
        while (lineIndex <= endLineIndex) {
            this.formatLine(document, lineIndex);
            ++lineIndex;
        }
        this.reset();
    }

    private void doEmptyLineIndentation(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset, int forLength) throws BadLocationException {
        if (this.lastEmptyLineNumber >= 0 && this.lastEmptyLineNumber == lineNumber - 1) {
            result.append(this.lastEmptyLineIndentationBuffer);
        } else {
            this.getDefaultIndentationStrategy().placeMatchingBlanks(document, result, lineNumber, forOffset);
            this.lastEmptyLineIndentationBuffer.setLength(0);
            this.lastEmptyLineIndentationBuffer.append(result);
        }
        this.lastEmptyLineNumber = lineNumber;
        if (forLength != 0 || result.length() != 0) {
            document.replace(forOffset, forLength, result.toString());
        }
    }

    private void formatLine(IStructuredDocument document, int lineNumber) {
        this.resultBuffer.setLength(0);
        try {
            int startLine;
            boolean formatThisLine;
            int regionStart;
            IRegion originalLineInfo = document.getLineInformation(lineNumber);
            int originalLineStart = originalLineInfo.getOffset();
            int originalLineLength = originalLineInfo.getLength();
            String lineText = document.get(originalLineStart, originalLineLength);
            IRegion formattedLineInformation = this.getFormattedLineInformation(originalLineInfo, lineText);
            if (!this.shouldReformat(document, formattedLineInformation)) {
                return;
            }
            if (originalLineLength == 0) {
                this.doEmptyLineIndentation(document, this.resultBuffer, lineNumber, originalLineStart, originalLineLength);
                return;
            }
            int formattedLineStart = formattedLineInformation.getOffset();
            int formattedTextEnd = formattedLineStart + formattedLineInformation.getLength();
            if (formattedTextEnd != originalLineStart + originalLineLength) {
                if (formattedLineStart == formattedTextEnd) {
                    this.doEmptyLineIndentation(document, this.resultBuffer, lineNumber, originalLineStart, originalLineLength);
                    return;
                }
                document.replace(formattedTextEnd, originalLineStart + originalLineLength - formattedTextEnd, "");
                originalLineLength = formattedTextEnd - originalLineStart;
            }
            int endingWhiteSpaces = formattedLineStart - originalLineStart;
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(formattedLineStart);
            int scriptRegionPos = sdRegion.getStartOffset();
            ITextRegion firstTokenInLine = sdRegion.getRegionAtCharacterOffset(formattedLineStart);
            ITextRegion lastTokenInLine = null;
            int n = regionStart = firstTokenInLine != null ? sdRegion.getStartOffset(firstTokenInLine) : 0;
            if (firstTokenInLine instanceof ITextRegionContainer) {
                scriptRegionPos = regionStart;
                ITextRegionContainer container = (ITextRegionContainer)firstTokenInLine;
                firstTokenInLine = container.getRegionAtCharacterOffset(formattedLineStart);
                regionStart += firstTokenInLine.getStart();
            }
            if (firstTokenInLine instanceof IPhpScriptRegion) {
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)firstTokenInLine;
                if (regionStart + scriptRegion.getEnd() <= formattedLineStart) {
                    this.doEmptyLineIndentation(document, this.resultBuffer, lineNumber, originalLineStart, 0);
                    return;
                }
                scriptRegionPos = regionStart;
                firstTokenInLine = scriptRegion.getPhpToken(formattedLineStart - regionStart);
                if (regionStart + firstTokenInLine.getStart() < originalLineStart && firstTokenInLine.getType() == "WHITESPACE") {
                    firstTokenInLine = scriptRegion.getPhpToken(firstTokenInLine.getEnd());
                }
                if (formattedTextEnd <= regionStart + scriptRegion.getEnd() && regionStart + (lastTokenInLine = scriptRegion.getPhpToken(formattedTextEnd - regionStart - 1)).getEnd() > originalLineStart + originalLineLength && lastTokenInLine.getType() == "WHITESPACE" && lastTokenInLine.getStart() > 0) {
                    lastTokenInLine = scriptRegion.getPhpToken(lastTokenInLine.getStart() - 1);
                }
            }
            if (firstTokenInLine == null) {
                this.doEmptyLineIndentation(document, this.resultBuffer, lineNumber, originalLineStart, 0);
                return;
            }
            String firstTokenType = firstTokenInLine.getType();
            boolean bl = formatThisLine = !this.isInHeredoc;
            if (firstTokenType == "PHP_HEREDOC_TAG" || lastTokenInLine != null && lastTokenInLine.getType() == "PHP_HEREDOC_TAG") {
                boolean bl2 = this.isInHeredoc = !this.isInHeredoc;
            }
            if (firstTokenType == "PHP_CONSTANT_ENCAPSED_STRING" && (startLine = document.getLineOfOffset(scriptRegionPos + firstTokenInLine.getStart())) < lineNumber) {
                this.ignoreLines.add(lineNumber);
                return;
            }
            if (!formatThisLine) {
                this.ignoreLines.add(lineNumber);
                return;
            }
            IIndentationStrategy insertionStrategy = firstTokenType == "PHP_CASE" || firstTokenType == "PHP_DEFAULT" ? this.caseDefaultIndentationStrategy : (this.isInsideOfPHPCommentRegion(firstTokenType) ? this.commentIndentationStrategy : (firstTokenType == "PHP_CLOSETAG" ? this.phpCloseTagIndentationStrategy : this.getIndentationStrategy(lineText.charAt(endingWhiteSpaces))));
            insertionStrategy.placeMatchingBlanks(document, this.resultBuffer, lineNumber, originalLineStart);
            String newIndentation = this.resultBuffer.toString();
            String oldIndentation = lineText.substring(0, endingWhiteSpaces);
            if (!StringUtils.equals((CharSequence)oldIndentation, (CharSequence)newIndentation)) {
                document.replace(originalLineStart, endingWhiteSpaces, newIndentation);
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private boolean isInsideOfPHPCommentRegion(String tokenType) {
        return PHPPartitionTypes.isPHPMultiLineCommentRegion(tokenType) || PHPPartitionTypes.isPHPMultiLineCommentEndRegion(tokenType) || PHPPartitionTypes.isPHPDocRegion(tokenType) || PHPPartitionTypes.isPHPDocEndRegion(tokenType);
    }

    private IRegion getFormattedLineInformation(IRegion lineInfo, String lineText) {
        int leftNonWhitespaceChar = 0;
        int rightNonWhitespaceChar = lineText.length() - 1;
        char[] chars = lineText.toCharArray();
        while (leftNonWhitespaceChar <= rightNonWhitespaceChar) {
            if (chars[leftNonWhitespaceChar] != ' ' && chars[leftNonWhitespaceChar] != '\t') break;
            ++leftNonWhitespaceChar;
        }
        while (leftNonWhitespaceChar <= rightNonWhitespaceChar) {
            if (chars[rightNonWhitespaceChar] != ' ' && chars[rightNonWhitespaceChar] != '\t') break;
            --rightNonWhitespaceChar;
        }
        if (leftNonWhitespaceChar > rightNonWhitespaceChar) {
            return new SimpleStructuredRegion(lineInfo.getOffset(), 0);
        }
        return leftNonWhitespaceChar == 0 && rightNonWhitespaceChar == lineText.length() - 1 ? lineInfo : new SimpleStructuredRegion(lineInfo.getOffset() + leftNonWhitespaceChar, rightNonWhitespaceChar - leftNonWhitespaceChar + 1);
    }

    private boolean shouldReformat(IStructuredDocument document, IRegion lineInfo) {
        String checkedLineBeginState = FormatterUtils.getPartitionType(document, lineInfo.getOffset());
        return checkedLineBeginState == "org.eclipse.php.PHP_DEFAULT" || checkedLineBeginState == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_SINGLE_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_DOC" || checkedLineBeginState == "org.eclipse.php.PHP_QUOTED_STRING";
    }

    protected final int getStart() {
        return this.start;
    }

    protected final int getLength() {
        return this.length;
    }

    @Deprecated
    public Set<Integer> getIgnoreLines() {
        return this.ignoreLines;
    }

    protected IIndentationStrategy getIndentationStrategy(char c) {
        if (c == '}') {
            return this.curlyCloseIndentationStrategy;
        }
        return this.getDefaultIndentationStrategy();
    }

    private IIndentationStrategy getDefaultIndentationStrategy() {
        return this.defaultIndentationStrategy;
    }
}

