/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.session;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.Base64;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpCommand;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.EngineTypes;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.Event;
import org.w3c.dom.Node;

public class DBGpSession {
    public static final String DEFAULT_SESSION_ENCODING = "ISO-8859-1";
    public static final String DEFAULT_BINARY_ENCODING = Charset.defaultCharset().name();
    public static final String DEFAULT_OUTPUT_ENCODING = Charset.defaultCharset().name();
    private final ISchedulingRule schedulingRule = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private Socket DBGpSocket;
    private ResponseReader responseHandler;
    private DBGpCommand DBGpCmd;
    private DataInputStream DBGpReader;
    private boolean sessionActive = false;
    private DBGpTarget debugTarget;
    private Hashtable<Integer, Object> savedResponses = new Hashtable();
    private String ideKey;
    private String sessionId;
    private String initialScript;
    private EngineTypes engineType;
    private String engineVersion;
    private String threadId;
    private long creationTime = System.currentTimeMillis();
    private String sessionEncoding;
    private String outputEncoding;
    private String binaryEncoding;

    public long getCreationTime() {
        return this.creationTime;
    }

    public DBGpSession(Socket connection) {
        this.DBGpSocket = connection;
        this.sessionEncoding = DEFAULT_SESSION_ENCODING;
        boolean isGood = false;
        try {
            this.DBGpCmd = new DBGpCommand(this.DBGpSocket);
            this.DBGpReader = new DataInputStream(this.DBGpSocket.getInputStream());
            this.sessionActive = true;
            byte[] response = this.readResponse();
            if (response != null) {
                DBGpResponse parsedResponse = new DBGpResponse();
                parsedResponse.parseResponse(response);
                if (1 == parsedResponse.getType()) {
                    this.ideKey = parsedResponse.getIdekey();
                    this.sessionId = parsedResponse.getSession();
                    this.initialScript = DBGpUtils.getFilenameFromURIString(parsedResponse.getFileUri());
                    this.engineVersion = parsedResponse.getEngineVersion();
                    this.engineType = parsedResponse.getEngineType();
                    this.threadId = parsedResponse.getThreadId();
                    isGood = true;
                } else {
                    DBGpLogger.logError("Init response not received. XML=" + parsedResponse.getRawXML(), this, null);
                }
            } else {
                DBGpLogger.logError("Unexpected null from readResponse waiting for Init", this, null);
            }
            if (!isGood) {
                this.endSession();
            }
        }
        catch (UnsupportedEncodingException e) {
            DBGpLogger.logException("UnsupportedEncodingException - 1", this, e);
            this.endSession();
        }
        catch (IOException e) {
            DBGpLogger.logException("IOException - 1", this, e);
            this.endSession();
        }
    }

    public void startSession() {
        this.responseHandler = new ResponseReader();
        this.responseHandler.schedule();
    }

    public void sendAsyncCmd(String cmd) {
        this.sendAsyncCmd(cmd, null);
    }

    public DBGpResponse sendSyncCmd(String cmd) {
        return this.sendSyncCmd(cmd, null);
    }

    public void sendAsyncCmd(String cmd, String arguments) {
        if (this.sessionActive) {
            int id = DBGpCommand.getNextId();
            try {
                this.DBGpCmd.send(cmd, arguments, id, this.sessionEncoding);
            }
            catch (IOException iOException) {
                this.endSession();
            }
        }
    }

    public DBGpResponse sendSyncCmd(String cmd, String arguments) {
        if (this.sessionActive) {
            int id = DBGpCommand.getNextId();
            Event idev = new Event();
            Integer idObj = id;
            this.savedResponses.put(idObj, idev);
            try {
                this.DBGpCmd.send(cmd, arguments, id, this.sessionEncoding);
                idev.waitForEvent();
                return (DBGpResponse)this.savedResponses.remove(idObj);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (IOException iOException) {
                this.endSession();
                return null;
            }
        }
        return null;
    }

    public synchronized void endSession() {
        this.unblockAllCallers(null);
        if (this.sessionActive) {
            this.sessionActive = false;
            try {
                this.DBGpSocket.shutdownInput();
            }
            catch (IOException iOException) {}
            try {
                this.DBGpSocket.shutdownOutput();
            }
            catch (IOException iOException) {}
            try {
                this.DBGpSocket.close();
            }
            catch (IOException e) {
                DBGpLogger.debugException(e);
            }
        }
        if (this.debugTarget != null) {
            this.debugTarget.sessionEnded();
            this.debugTarget = null;
        }
    }

    public String getIdeKey() {
        return this.ideKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public boolean isActive() {
        return this.sessionActive;
    }

    public String getInitialScript() {
        return this.initialScript;
    }

    public DBGpTarget getDebugTarget() {
        return this.debugTarget;
    }

    public void setDebugTarget(DBGpTarget debugTarget) {
        this.debugTarget = debugTarget;
        this.determineEncodings();
    }

    public String getSessionEncoding() {
        return this.sessionEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public String getBinaryEncoding() {
        return this.binaryEncoding;
    }

    public void setSessionEncoding(String sessionEncoding) {
        this.sessionEncoding = sessionEncoding;
    }

    public EngineTypes getEngineType() {
        return this.engineType;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public int getRemotePort() {
        return this.DBGpSocket.getPort();
    }

    public InetAddress getRemoteAddress() {
        return this.DBGpSocket.getInetAddress();
    }

    public String getRemoteHostname() {
        return this.DBGpSocket.getInetAddress().getHostName();
    }

    public String toString() {
        StringBuilder strBuf = new StringBuilder(this.getIdeKey());
        if (this.getSessionId() != null) {
            strBuf.append(" - Session:");
            strBuf.append(this.getSessionId());
        } else {
            strBuf.append(" - Web Server Session");
        }
        return strBuf.toString();
    }

    private void unblockAllCallers(DBGpResponse parsedResponse) {
        if (parsedResponse == null) {
            parsedResponse = new DBGpResponse();
            parsedResponse.parseResponse((byte[])null);
        }
        Set<Integer> keys = this.savedResponses.keySet();
        for (Integer idObj : keys) {
            this.postAndSignalCaller(idObj, parsedResponse);
        }
    }

    private void postAndSignalCaller(Integer idObj, DBGpResponse parsedResponse) {
        Object responder = this.savedResponses.get(idObj);
        if (responder instanceof Event) {
            Event idev = (Event)responder;
            this.savedResponses.put(idObj, parsedResponse);
            idev.signalEvent();
        }
    }

    private byte[] readResponse() {
        byte[] byteArray;
        int remainingBytesToRead = 0;
        try {
            byte receivedByte;
            while ((receivedByte = this.DBGpReader.readByte()) != 0) {
                remainingBytesToRead = remainingBytesToRead * 10 + receivedByte - 48;
            }
            byteArray = new byte[remainingBytesToRead];
            int totalBytesSoFar = 0;
            while (remainingBytesToRead > 0) {
                int bytesReceived = this.DBGpReader.read(byteArray, totalBytesSoFar, remainingBytesToRead);
                remainingBytesToRead -= bytesReceived;
                totalBytesSoFar += bytesReceived;
            }
            if (this.DBGpReader.readByte() != 0) {
                this.endSession();
                return null;
            }
        }
        catch (IOException iOException) {
            this.endSession();
            return null;
        }
        try {
            if (DBGpLogger.debugResp()) {
                DBGpLogger.debug("Response: " + new String(byteArray, this.sessionEncoding));
            }
            return byteArray;
        }
        catch (UnsupportedEncodingException e) {
            DBGpLogger.logException("UnsupportedEncodingException - 2", this, e);
            this.endSession();
            return null;
        }
    }

    private void determineEncodings() {
        ILaunch launch = this.getDebugTarget().getLaunch();
        ILaunchConfiguration launchConfig = launch.getLaunchConfiguration();
        this.outputEncoding = this.getCharset("debugOutputEncoding", launchConfig);
        this.binaryEncoding = this.getCharset("debugTransferEncoding", launchConfig);
    }

    private String getCharset(String encodingKey, ILaunchConfiguration launchConfig) {
        String charset = null;
        String outputEncoding = null;
        if (launchConfig != null) {
            try {
                outputEncoding = launchConfig.getAttribute(encodingKey, "");
            }
            catch (CoreException coreException) {}
        }
        if (outputEncoding == null || outputEncoding.length() == 0) {
            outputEncoding = encodingKey == "debugOutputEncoding" ? PHPProjectPreferences.getOutputEncoding(null) : PHPProjectPreferences.getTransferEncoding(null);
        }
        charset = outputEncoding == null || !Charset.isSupported(outputEncoding) ? Charset.defaultCharset().name() : outputEncoding;
        return charset;
    }

    private class ResponseHandler
    extends Job {
        private ResponseHandlerAction actionType;
        private DBGpResponse response;

        public ResponseHandler() {
            super("DBGp Response Handler");
            this.setSystem(true);
            this.setUser(false);
            this.setRule(DBGpSession.this.schedulingRule);
        }

        protected IStatus run(IProgressMonitor monitor) {
            switch (this.actionType) {
                case HANDLE_BREAK: {
                    this.handleBreak();
                    break;
                }
                case HANDLE_STREAM: {
                    this.handleStream();
                    break;
                }
                case HANDLE_STOPPING: 
                case HANDLE_STOP: {
                    this.handleStop();
                    break;
                }
            }
            return Status.OK_STATUS;
        }

        void perform(ResponseHandlerAction actionType, DBGpResponse response) {
            this.actionType = actionType;
            this.response = response;
            this.schedule();
        }

        private void handleStream() {
            String data = this.response.getStreamData();
            if (data != null) {
                String streamStr;
                byte[] streamData = Base64.decode(data);
                try {
                    streamStr = new String(streamData, DBGpSession.this.outputEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    DBGpLogger.logException("invalid encoding: " + DBGpSession.this.outputEncoding, (Object)this, e);
                    streamStr = new String(streamData);
                }
                if (DBGpSession.this.debugTarget != null) {
                    DBGpSession.this.debugTarget.getOutputBuffer().append(streamStr);
                }
            }
        }

        private void handleStop() {
            DBGpSession.this.endSession();
        }

        private void handleBreak() {
            if (this.response.getStatus().equals("break")) {
                Node breakData = this.response.getParentNode().getFirstChild();
                String exception = DBGpResponse.getAttribute(breakData, "exception");
                if (this.response.getReason().equals("ok")) {
                    String cmd = this.response.getCommand();
                    if (cmd.equals("run") || !exception.isEmpty()) {
                        this.response = DBGpSession.this.sendSyncCmd("stack_get", null);
                        if (this.response != null) {
                            if (this.response.getStatus().equals("stopped")) {
                                this.handleStop();
                            } else {
                                Node stackData = this.response.getParentNode().getFirstChild();
                                String line = DBGpResponse.getAttribute(stackData, "lineno");
                                int lineno = 0;
                                try {
                                    lineno = Integer.parseInt(line);
                                    String filename = DBGpUtils.getFilenameFromURIString(DBGpResponse.getAttribute(stackData, "filename"));
                                    filename = DBGpSession.this.debugTarget.mapToWorkspaceFileIfRequired(filename);
                                    if (DBGpSession.this.debugTarget != null) {
                                        DBGpSession.this.debugTarget.breakpointHit(filename, lineno, exception);
                                    }
                                }
                                catch (NumberFormatException nfe) {
                                    DBGpLogger.logException("Unexpected number format exception", (Object)this, nfe);
                                }
                            }
                        }
                    } else if ((cmd.equals("step_into") || cmd.equals("step_out") || cmd.equals("step_over")) && DBGpSession.this.debugTarget != null) {
                        DBGpSession.this.debugTarget.suspended(8);
                    }
                }
            }
        }
    }

    private static enum ResponseHandlerAction {
        HANDLE_BREAK,
        HANDLE_STOPPING,
        HANDLE_STOP,
        HANDLE_STREAM;

    }

    private class ResponseReader
    extends Job {
        public ResponseReader() {
            super("DBGp Response Reader");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            byte[] response = null;
            while (DBGpSession.this.sessionActive) {
                try {
                    response = DBGpSession.this.readResponse();
                    if (response == null) continue;
                    DBGpResponse parsedResponse = new DBGpResponse();
                    parsedResponse.parseResponse(response);
                    int respErrorCode = parsedResponse.getErrorCode();
                    if (respErrorCode == 0 || respErrorCode == 10003) {
                        int respType = parsedResponse.getType();
                        if (respType == 2) {
                            if (parsedResponse.getStatus().equals("stopped")) {
                                new ResponseHandler().perform(ResponseHandlerAction.HANDLE_STOP, parsedResponse);
                            } else if (parsedResponse.getStatus().equals("break")) {
                                new ResponseHandler().perform(ResponseHandlerAction.HANDLE_BREAK, parsedResponse);
                            } else if (parsedResponse.getStatus().equals("stopping")) {
                                new ResponseHandler().perform(ResponseHandlerAction.HANDLE_STOPPING, parsedResponse);
                            }
                        } else if (respType == 3 && respErrorCode != 10003) {
                            new ResponseHandler().perform(ResponseHandlerAction.HANDLE_STREAM, parsedResponse);
                        } else {
                            DBGpLogger.logWarning("Unknown type of XML: " + response, DBGpSession.this, null);
                        }
                    }
                    this.unblockSyncCaller(parsedResponse);
                }
                catch (Throwable t) {
                    DBGpLogger.logException("Unexpected exception. Terminating the debug session", (Object)this, t);
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            DBGpSession.this.endSession();
            return Status.OK_STATUS;
        }

        private void unblockSyncCaller(DBGpResponse parsedResponse) {
            Integer idObj;
            block4: {
                idObj = null;
                try {
                    idObj = Integer.valueOf(parsedResponse.getId());
                }
                catch (NumberFormatException numberFormatException) {
                    idObj = DBGpSession.this.DBGpCmd.getLastIdSent();
                    if (!DBGpLogger.debugResp()) break block4;
                    DBGpLogger.debug("no txn id, using last which was" + idObj.toString());
                }
            }
            if (DBGpSession.this.savedResponses.containsKey(idObj) && parsedResponse.getType() == 2) {
                DBGpSession.this.postAndSignalCaller(idObj, parsedResponse);
            } else {
                DBGpUtils.isGoodDBGpResponse((Object)this, parsedResponse);
            }
        }
    }
}

