/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.debug.core.pathmapper.LocalFileSearchEngine;
import org.eclipse.php.internal.debug.core.pathmapper.LocalFileSearchResult;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.zend.communication.IFileContentRequestor;
import org.eclipse.php.internal.debug.core.zend.communication.Messages;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugSessionStartedNotification;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenRemoteFileRequestor
implements IFileContentRequestor {
    private static final String OPTION_SERVER_ADDRESS = "server_address";
    private DebugSessionStartedNotification notification;

    public OpenRemoteFileRequestor(DebugSessionStartedNotification notification) {
        this.notification = notification;
    }

    @Override
    public void fileContentReceived(byte[] content, String fileName, final int lineNumber) {
        final String localFile = this.getLocalFile(content, fileName);
        if (localFile == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OpenRemoteFileRequestor.this.openEditor(localFile, lineNumber);
            }
        });
    }

    @Override
    public void requestCompleted(Exception e) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLocalFile(byte[] content, String remoteFile) {
        PathEntry entry;
        block9: {
            PathMapper mapper = null;
            entry = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFileForLocation((IPath)new Path(remoteFile));
            if (file != null) {
                return file.getLocation().toOSString();
            }
            String serverAddress = this.extractParameterFromQuery(this.notification.getOptions(), OPTION_SERVER_ADDRESS);
            try {
                Server server;
                String serverURL = "http://" + serverAddress;
                Server serverMatch = ServersManager.findByURL((String)serverURL);
                if (serverMatch != null) {
                    mapper = PathMapperRegistry.getByServer(serverMatch);
                    entry = mapper.getLocalFile(remoteFile);
                    if (entry == null) {
                        LocalFileSearchEngine searchEngine = new LocalFileSearchEngine();
                        LocalFileSearchResult searchResult = searchEngine.find((IResource)root, remoteFile, serverMatch.getUniqueId());
                        if (searchResult == null) {
                            File localFile = new File(remoteFile);
                            if (localFile.exists()) {
                                return remoteFile;
                            }
                            this.openNoMatchDialog(remoteFile);
                            return null;
                        }
                        entry = searchResult.getPathEntry();
                    }
                    break block9;
                }
                Server[] serverArray = ServersManager.getServers();
                int n = serverArray.length;
                int n2 = 0;
                while (n2 < n && (entry = (mapper = PathMapperRegistry.getByServer(server = serverArray[n2])).getLocalFile(remoteFile)) == null) {
                    ++n2;
                }
            }
            catch (InterruptedException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        if (entry != null) {
            return entry.getResolvedPath();
        }
        return null;
    }

    private void openEditor(String localFile, int lineNumber) {
        try {
            EditorUtility.openLocalFile((String)localFile, (int)lineNumber);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (shell != null) {
                shell.forceActive();
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
    }

    private String extractParameterFromQuery(String query, String parameter) {
        int queryStartIndex = query.indexOf(String.valueOf(parameter) + "=");
        if (queryStartIndex > -1) {
            String value = query.substring(queryStartIndex + parameter.length() + 1);
            int paramSeparatorIndex = value.indexOf(38);
            if (paramSeparatorIndex > -1) {
                value = value.substring(0, paramSeparatorIndex);
            }
            return value;
        }
        return null;
    }

    private void openNoMatchDialog(final String remoteFile) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (shell != null) {
                    shell.forceActive();
                }
                MessageDialog.openInformation((Shell)shell, (String)Messages.OpenRemoteFileRequestor_Open_remote_file_request, (String)MessageFormat.format(Messages.OpenRemoteFileRequestor_No_match_could_be_found, remoteFile));
            }
        });
    }
}

