/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.php.formatter.core.CodeFormatterPreferences;
import org.eclipse.php.formatter.core.CodeFormatterVisitor;
import org.eclipse.php.formatter.core.HtmlFormatterForPhpCode;
import org.eclipse.php.formatter.core.Logger;
import org.eclipse.php.formatter.core.MarkerUtilities;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.format.ICodeFormattingProcessor;
import org.eclipse.php.internal.core.format.IContentFormatter2;
import org.eclipse.php.internal.core.format.IFormatterProcessorFactory;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.osgi.service.prefs.Preferences;

public class PHPCodeFormatter
implements IContentFormatter,
IContentFormatter2,
IFormatterProcessorFactory {
    private CodeFormatterPreferences fCodeFormatterPreferences = CodeFormatterPreferences.getDefaultPreferences();
    private static final Map<String, Object> defaultPrefrencesValues = CodeFormatterPreferences.getDefaultPreferences().getMap();

    private CodeFormatterPreferences getPreferences(IProject project) throws Exception {
        IEclipsePreferences node = null;
        if (project != null) {
            ProjectScope scope = new ProjectScope(project);
            node = scope.getNode("org.eclipse.php.formatter.core");
        }
        HashMap<String, Object> p = new HashMap<String, Object>(defaultPrefrencesValues);
        if (node != null && node.keys().length > 0 && node.get("formatterProfile", null) != null) {
            Set propetiesNames = p.keySet();
            for (String property : propetiesNames) {
                String value = node.get(property, null);
                if (value == null) continue;
                p.put(property, value);
            }
        } else {
            IPreferencesService service = Platform.getPreferencesService();
            String[] lookup = service.getLookupOrder("org.eclipse.php.formatter.core", null);
            Preferences[] nodes = new Preferences[lookup.length];
            int i = 0;
            while (i < lookup.length) {
                nodes[i] = service.getRootNode().node(lookup[i]).node("org.eclipse.php.formatter.core");
                ++i;
            }
            for (String property : p.keySet()) {
                String value = service.get(property, null, nodes);
                if (value == null) continue;
                p.put(property, value);
            }
        }
        this.fCodeFormatterPreferences.setPreferencesValues(p);
        return this.fCodeFormatterPreferences;
    }

    public void format(IDocument document, IRegion region) {
        block13: {
            IStructuredTextUndoManager undoManager = null;
            IStructuredModel structuredModel = null;
            try {
                if (!(document instanceof IStructuredDocument)) break block13;
                IStructuredDocument structuredDocument = (IStructuredDocument)document;
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                IProject project = null;
                if (structuredModel != null) {
                    project = PHPCodeFormatter.getProject(structuredModel);
                }
                if (project == null) {
                    Logger.logException(new IllegalStateException("Cann't resolve file name"));
                    return;
                }
                try {
                    List<ReplaceEdit> changes;
                    undoManager = structuredDocument.getUndoManager();
                    undoManager.beginRecording((Object)this, "php format document", "format PHP document", 0, document.getLength());
                    HtmlFormatterForPhpCode htmlFormatter = new HtmlFormatterForPhpCode();
                    try {
                        htmlFormatter.formatDocument(document, region.getOffset(), region.getLength());
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                    PHPVersion version = ProjectOptions.getPhpVersion((IProject)project);
                    boolean useShortTags = ProjectOptions.useShortTags((IProject)project);
                    ICodeFormattingProcessor codeFormatterVisitor = this.getCodeFormattingProcessor(project, document, version, useShortTags, region);
                    if (codeFormatterVisitor instanceof CodeFormatterVisitor && (changes = ((CodeFormatterVisitor)codeFormatterVisitor).getChanges()).size() > 0) {
                        this.replaceAll(document, changes, structuredModel);
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            finally {
                if (undoManager != null) {
                    undoManager.endRecording((Object)this);
                }
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
    }

    private static final IProject getProject(IStructuredModel doModelForPHP) {
        IFile file;
        String id;
        if (doModelForPHP != null && (id = doModelForPHP.getId()) != null && (file = PHPCodeFormatter.getFile(id)) != null) {
            return file.getProject();
        }
        return null;
    }

    private static IFile getFile(String id) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(id));
    }

    public ICodeFormattingProcessor getCodeFormattingProcessor(IDocument document, PHPVersion phpVersion, boolean useShortTags, IRegion region) throws Exception {
        IProject project = this.getProject(document);
        return this.getCodeFormattingProcessor(project, document, phpVersion, useShortTags, region);
    }

    private ICodeFormattingProcessor getCodeFormattingProcessor(IProject project, IDocument document, PHPVersion phpVersion, boolean useShortTags, IRegion region) throws Exception {
        CodeFormatterPreferences fCodeFormatterPreferences = this.getPreferences(project);
        CodeFormatterVisitor codeFormattingProcessor = new CodeFormatterVisitor(document, fCodeFormatterPreferences, PHPModelUtils.getLineSeparator((IProject)project), phpVersion, useShortTags, region);
        return codeFormattingProcessor;
    }

    private IProject getProject(IDocument document) {
        IProject project = null;
        IStructuredModel structuredModel = null;
        if (document instanceof IStructuredDocument) {
            try {
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                project = PHPCodeFormatter.getProject(structuredModel);
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        return project;
    }

    private void replaceAll(IDocument document, List<ReplaceEdit> changes, IStructuredModel domModelForPHP) throws BadLocationException {
        StringBuilder buffer = new StringBuilder(document.get());
        int i = changes.size() - 1;
        while (i >= 0) {
            ReplaceEdit replace = changes.get(i);
            buffer.replace(replace.getOffset(), replace.getExclusiveEnd(), replace.getText());
            --i;
        }
        document.set(buffer.toString());
    }

    @Deprecated
    private void reinsertMarkers(IMarker[] allMarkers, IFile file) throws CoreException {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (allMarkers != null) {
            IMarker[] iMarkerArray = allMarkers;
            int n = allMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String markerType = MarkerUtilities.getMarkerType(marker);
                if (markerType != null) {
                    IBreakpoint breakpoint = breakpointManager.getBreakpoint(marker);
                    if (breakpoint != null) {
                        IMarker createdMarker = file.createMarker(markerType);
                        createdMarker.setAttributes(breakpoint.getMarker().getAttributes());
                        breakpointManager.removeBreakpoint(breakpoint, true);
                        breakpoint.setMarker(createdMarker);
                        breakpointManager.addBreakpoint(breakpoint);
                    } else {
                        MarkerUtilities.createMarker((IResource)file, marker.getAttributes(), markerType);
                    }
                }
                marker.delete();
                ++n2;
            }
        }
    }

    public IFormattingStrategy getFormattingStrategy(String contentType) {
        return null;
    }

    @Deprecated
    public void format(IDocument document, IRegion region, PHPVersion version) {
        block13: {
            IStructuredTextUndoManager undoManager = null;
            IStructuredModel structuredModel = null;
            try {
                if (!(document instanceof IStructuredDocument)) break block13;
                IStructuredDocument structuredDocument = (IStructuredDocument)document;
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                IProject project = null;
                if (structuredModel != null) {
                    project = PHPCodeFormatter.getProject(structuredModel);
                }
                if (project == null) {
                    Logger.logException(new IllegalStateException("Cann't resolve file name"));
                    return;
                }
                try {
                    List<ReplaceEdit> changes;
                    undoManager = structuredDocument.getUndoManager();
                    undoManager.beginRecording((Object)this, "php format document", "format PHP document", 0, document.getLength());
                    HtmlFormatterForPhpCode htmlFormatter = new HtmlFormatterForPhpCode();
                    try {
                        htmlFormatter.formatDocument(document);
                    }
                    catch (Exception exception) {}
                    boolean useShortTags = ProjectOptions.useShortTags((IProject)project);
                    ICodeFormattingProcessor codeFormatterVisitor = this.getCodeFormattingProcessor(project, document, version, useShortTags, region);
                    if (codeFormatterVisitor instanceof CodeFormatterVisitor && (changes = ((CodeFormatterVisitor)codeFormatterVisitor).getChanges()).size() > 0) {
                        this.replaceAll(document, changes, structuredModel);
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            finally {
                if (undoManager != null) {
                    undoManager.endRecording((Object)this);
                }
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
    }
}

