/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.changes.DummyDocument;
import org.eclipse.php.refactoring.core.changes.ProgramDocumentChange;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProgramDocumentChangeTest
extends AbstractRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"project1");
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        this.file = TestUtils.createFile((IFolder)folder, (String)"ProgramDocument.php", (String)"<?php class Item { public static function foo(){} } class ItemEx extends Item{public static function foo(){}} ItemEx::foo();?>");
        folder.getFile("ProgramDocument.php");
        TestUtils.waitForIndexer();
    }

    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testGetProgram() throws Exception {
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        ProgramDocumentChange change = new ProgramDocumentChange("TestProgram", (IDocument)new DummyDocument(), program);
        Assert.assertEquals((Object)program, (Object)change.getProgram());
        Assert.assertEquals((Object)program, (Object)change.getAdapter(Program.class));
    }
}

