/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename.logic;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.search.text.TextSearcherFactory;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.changes.ProgramFileChange;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public abstract class AbstractRename
extends AbstractVisitor {
    protected String oldName;
    protected final List<TextEditGroup> groups = new LinkedList<TextEditGroup>();
    protected final IFile changedFile;
    protected final String newName;
    protected final boolean searchTextual;
    protected static final String GLOBAL = "Global";
    private final Pattern pattern;

    public AbstractRename(IFile file, String oldName, String newName, boolean searchTextual) {
        if (newName == null || file == null || oldName == null) {
            throw new IllegalArgumentException();
        }
        this.oldName = oldName;
        this.newName = newName;
        this.changedFile = file;
        this.searchTextual = searchTextual;
        this.pattern = Pattern.compile(this.getTextualSearchPattern());
    }

    protected void addChange(Identifier identifier) {
        this.addChange(identifier.getStart());
    }

    protected void addChange(Scalar scalar) {
        char charAt = scalar.getStringValue().charAt(0);
        int isQuotedOffset = charAt == '\"' || charAt == '\'' ? 1 : 0;
        this.addChange(scalar.getStart() + isQuotedOffset);
    }

    protected void addChange(int start) {
        this.addChange(start, this.getRenameDescription());
    }

    public boolean hasChanges() {
        return this.groups.size() != 0;
    }

    public void updateChange(TextFileChange change) {
        if (!this.hasChanges()) {
            return;
        }
        AbstractRename.addGroups(change, this.groups);
    }

    private static final void addGroups(TextFileChange change, List<TextEditGroup> groups) {
        assert (change != null && groups != null);
        TextEditChangeGroup[] textEditChangeGroups = change.getTextEditChangeGroups();
        block0: for (TextEditGroup editGroup : groups) {
            TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)change, editGroup);
            TextEdit textEdit = editGroup.getTextEdits()[0];
            TextEditChangeGroup[] textEditChangeGroupArray = textEditChangeGroups;
            int n = textEditChangeGroups.length;
            int n2 = 0;
            while (n2 < n) {
                TextEditChangeGroup existingTextEditChangeGroup = textEditChangeGroupArray[n2];
                TextEdit existingTextEdit = existingTextEditChangeGroup.getTextEdits()[0];
                if (existingTextEdit.getOffset() == textEdit.getOffset()) continue block0;
                ++n2;
            }
            change.addTextEditChangeGroup(textEditChangeGroup);
            change.addEdit(textEdit);
        }
    }

    public final void mergeGroups(ProgramFileChange change) {
        AbstractRename.addGroups(change, this.groups);
    }

    public boolean visit(Program program) {
        List statements = program.statements();
        for (Statement element : statements) {
            element.accept((Visitor)this);
        }
        if (this.searchTextual) {
            this.searchTextualOccurrences(program);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void searchTextualOccurrences(Program program) {
        searcher = TextSearcherFactory.createSearcher((IResource)this.changedFile, (String)this.getTextualSearchPattern());
        searcher.search(null);
        searchIterator = searcher.getResults().iterator();
        currentMatch = searchIterator.hasNext() != false ? searchIterator.next() : null;
        commentIterator = program.comments().iterator();
        currentComment = commentIterator.hasNext() != false ? (Comment)commentIterator.next() : null;
        ** GOTO lbl19
        {
            if (this.textInsideComment(currentComment, currentMatch)) {
                this.addChange(currentMatch.getOffset() + 1, PhpRefactoringCoreMessages.getString("AbstractRename_0"));
            }
            currentMatch = searchIterator.hasNext() != false ? searchIterator.next() : null;
            do {
                if (this.isInside(currentComment, currentMatch)) continue block0;
                while (this.isCommentBefore(currentMatch, currentComment)) {
                    v0 = currentComment = commentIterator.hasNext() != false ? (Comment)commentIterator.next() : null;
                }
                while (this.isMatchBefore(currentMatch, currentComment)) {
                    currentMatch = searchIterator.hasNext() != false ? searchIterator.next() : null;
                }
lbl19:
                // 2 sources

            } while (currentComment != null && currentMatch != null);
        }
    }

    protected void addChange(int start, String name) {
        TextEditGroup textEditGroup = new TextEditGroup(name);
        ReplaceEdit replaceEdit = new ReplaceEdit(start, this.oldName.length(), this.newName);
        textEditGroup.addTextEdit((TextEdit)replaceEdit);
        this.groups.add(textEditGroup);
    }

    protected String getTextualSearchPattern() {
        return "\\W" + this.oldName + "\\W";
    }

    private final boolean isMatchBefore(FileMatch currentMatch, Comment currentComment) {
        return currentComment != null && currentMatch != null && currentMatch.getOffset() + currentMatch.getLength() <= currentComment.getStart();
    }

    private final boolean isCommentBefore(FileMatch currentMatch, Comment currentComment) {
        return currentComment != null && currentMatch != null && currentComment.getEnd() <= currentMatch.getOffset();
    }

    protected final boolean isInside(Comment currentComment, FileMatch currentMatch) {
        return currentComment != null && currentMatch != null && currentComment.getStart() <= currentMatch.getOffset() && currentComment.getEnd() >= currentMatch.getOffset();
    }

    protected boolean textInsideComment(Comment currentComment, FileMatch currentMatch) {
        return currentComment.getStart() <= currentMatch.getOffset() + 1 && currentComment.getEnd() > currentMatch.getOffset() + 1;
    }

    public boolean visit(Scalar scalar) {
        if (this.searchTextual) {
            String stringValue = scalar.getStringValue();
            if (scalar.getScalarType() == 2 && stringValue != null) {
                Matcher matcher = this.pattern.matcher(stringValue);
                while (matcher.find()) {
                    this.addChange(scalar.getStart() + matcher.start() + matcher.group().indexOf(this.oldName), PhpRefactoringCoreMessages.getString("AbstractRename_0"));
                }
            }
        }
        return true;
    }

    public abstract String getRenameDescription();
}

