/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.actions;

import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.actions.IPHPActionDelegator;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.refactoring.core.utils.ASTUtils;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;
import org.eclipse.php.refactoring.ui.RefactoringUIPlugin;
import org.eclipse.php.refactoring.ui.actions.Messages;
import org.eclipse.php.refactoring.ui.rename.RefactoringExecutionStarter;
import org.eclipse.php.refactoring.ui.rename.RenameLinkedMode;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class RenamePHPElementActionDelegate
implements IPHPActionDelegator {
    private static final String DIALOG_TITLE = Messages.RenamePHPElementActionDelegate_0;
    private IWorkbenchWindow fWindow;
    private ISelection selection;

    public void run(IAction action) {
        if (this.selection instanceof ITextSelection) {
            this.execute((ITextSelection)this.selection);
        } else if (this.selection instanceof IStructuredSelection) {
            this.execute((IStructuredSelection)this.selection);
        }
    }

    private void execute(ITextSelection selection) {
        this.setWindowIfEmpty();
        IEditorPart fEditor = this.fWindow.getActivePage().getActiveEditor();
        if (fEditor != null && fEditor instanceof PHPStructuredEditor) {
            IModelElement source = ((PHPStructuredEditor)fEditor).getModelElement();
            if (!(source instanceof ISourceModule)) {
                MessageDialog.openError((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.RenamePHPElementActionDelegate_1);
                return;
            }
            Program program = null;
            try {
                program = ASTUtils.createProgramFromSource((ISourceModule)((ISourceModule)source));
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)("Unexpected error happenned:" + e.getMessage()));
            }
            if (program == null) {
                MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.RenamePHPElementActionDelegate_2);
                return;
            }
            IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
            boolean isInline = store.getBoolean("Refactor.lightweight");
            StructuredTextViewer viewer = ((PHPStructuredEditor)fEditor).getTextViewer();
            Point originalSelection = viewer.getSelectedRange();
            if (originalSelection != null) {
                this.run(source.getResource(), program, originalSelection.x, originalSelection.y, fEditor, isInline);
            } else {
                this.run(source.getResource(), program, selection.getOffset(), selection.getLength(), fEditor, isInline);
            }
        }
    }

    private void setWindowIfEmpty() {
        if (this.fWindow == null) {
            this.fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
    }

    private void run(IResource resource, Program program, int offset, int length, IEditorPart fEditor, boolean isInline) {
        ASTNode selectedNode = this.getSelectedNode(program, offset, length);
        Shell activeShell = null;
        activeShell = this.fWindow != null ? this.fWindow.getShell() : PlatformUI.getWorkbench().getDisplay().getActiveShell();
        if (selectedNode != null) {
            if (isInline) {
                new RenameLinkedMode(null, (PHPStructuredEditor)fEditor).start();
            } else {
                try {
                    RefactoringExecutionStarter.startRenameRefactoring(resource, selectedNode, activeShell);
                }
                catch (CoreException coreException) {
                    MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.RenamePHPElementActionDelegate_2);
                }
            }
        } else {
            MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.RenamePHPElementActionDelegate_2);
        }
    }

    protected ASTNode getSelectedNode(Program program, int offset, int length) {
        ASTNode selectedNode = NodeFinder.perform((ASTNode)program, (int)offset, (int)length);
        if (selectedNode != null && selectedNode.getType() == 38) {
            selectedNode = selectedNode.getProgramRoot();
        }
        return selectedNode;
    }

    private void execute(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        this.setWindowIfEmpty();
        if (object instanceof IResource) {
            object = DLTKCore.create((IResource)((IResource)object));
        }
        if (this.isScriptContainer(object)) {
            IModelElement element = (IModelElement)object;
            try {
                RefactoringExecutionStarter.startRenameRefactoring(element.getResource(), null, this.fWindow.getShell());
            }
            catch (CoreException coreException) {
                MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.RenamePHPElementActionDelegate_2);
            }
            return;
        }
        if (this.isSourceReference(object) && this.isModelElement(object) && PHPToolkitUtil.isFromPhpProject((IModelElement)((IModelElement)object))) {
            IModelElement element = (IModelElement)object;
            IModelElement type = element.getPrimaryElement();
            ISourceModule source = RefactoringUtility.getSourceModule((IModelElement)type);
            if (source == null) {
                MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.RenamePHPElementActionDelegate_2);
                return;
            }
            Program program = null;
            try {
                program = ASTUtils.createProgramFromSource((ISourceModule)source);
            }
            catch (ModelException modelException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {}
            if (program == null) {
                MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.RenamePHPElementActionDelegate_2);
                return;
            }
            try {
                int offset = this.getSourceOffset(element);
                this.run(element.getResource(), program, offset, 0, this.fWindow.getActivePage().getActiveEditor(), false);
            }
            catch (ModelException modelException) {
                MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.RenamePHPElementActionDelegate_2);
                return;
            }
        }
        RenameResourceAction renameAction = new RenameResourceAction(new IShellProvider(){

            public Shell getShell() {
                return RenamePHPElementActionDelegate.this.fWindow.getShell();
            }
        });
        renameAction.selectionChanged(selection);
        renameAction.run();
    }

    protected boolean isModelElement(Object object) {
        return object instanceof IModelElement;
    }

    protected int getSourceOffset(IModelElement element) throws ModelException {
        if (element instanceof SourceField) {
            return ((SourceField)element).getNameRange().getOffset();
        }
        return ((ISourceReference)element).getSourceRange().getOffset();
    }

    protected boolean isSourceReference(Object object) {
        return object instanceof ISourceReference;
    }

    protected boolean isScriptContainer(Object object) {
        return object instanceof IScriptFolder || object instanceof IScriptProject || object instanceof ProjectFragment;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }
}

