/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtilities;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PHPWebPageLaunchDialog
extends TitleAreaDialog {
    private final Server server;
    private final IScriptProject project;
    private Text fFile;
    private Button fileButton;
    private final String mode;
    private Button breakOnFirstLine;
    private Button autoGeneratedURL;
    private Label fURLLabel;
    private Text fURLHost;
    private Text fURLPath;
    private WidgetListener fListener = new WidgetListener();
    private boolean isBreakAtFirstLine;
    private String pathString;
    private String fileName;

    public PHPWebPageLaunchDialog(String mode, IScriptProject obj) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.mode = mode;
        this.project = obj;
        this.server = ServersManager.getDefaultServer((IProject)obj.getProject());
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        this.setDialogTitle(this.mode);
        this.setTitle(this.getActionTitle(this.mode));
        this.setMessage(this.getActionMessage(this.mode));
        this.setTitleImage(ServersPluginImages.DESC_WIZ_SERVER.createImage());
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData gd = new GridData(1808);
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)gd);
        this.createFileComponent(content);
        this.createBreakControl(content);
        this.createURLControl(content);
        this.initializeURLControl();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.debugging");
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control createContents = super.createContents(parent);
        this.disableOkButton();
        return createContents;
    }

    private void disableOkButton() {
        this.getButton(0).setEnabled(false);
    }

    private void enableOkButton() {
        this.getButton(0).setEnabled(true);
    }

    private String getActionMessage(String mode) {
        if ("debug".equals(mode)) {
            return PHPServerUIMessages.getString("PHPWebPageLaunchDialog.0");
        }
        if ("run".equals(mode)) {
            return PHPServerUIMessages.getString("PHPWebPageLaunchDialog.1");
        }
        if ("profile".equals(mode)) {
            return PHPServerUIMessages.getString("PHPWebPageLaunchDialog.2");
        }
        throw new IllegalArgumentException();
    }

    private String getActionTitle(String mode) {
        if ("debug".equals(mode)) {
            return PHPServerUIMessages.getString("PHPWebPageLaunchDialog.3");
        }
        if ("run".equals(mode)) {
            return PHPServerUIMessages.getString("PHPWebPageLaunchDialog.4");
        }
        if ("profile".equals(mode)) {
            return PHPServerUIMessages.getString("PHPWebPageLaunchDialog.5");
        }
        throw new IllegalArgumentException();
    }

    private void setDialogTitle(String mode) {
        if ("debug".equals(mode)) {
            this.getShell().setText(PHPServerUIMessages.getString("PHPWebPageLaunchDialog.3"));
        } else if ("run".equals(mode)) {
            this.getShell().setText(PHPServerUIMessages.getString("PHPWebPageLaunchDialog.4"));
        } else if ("profile".equals(mode)) {
            this.getShell().setText(PHPServerUIMessages.getString("PHPWebPageLaunchDialog.5"));
        }
    }

    protected void createBreakControl(Composite parent) {
        if (!"debug".equals(this.mode)) {
            return;
        }
        Group group = new Group(parent, 0);
        group.setText(PHPServerUIMessages.getString("PHPWebPageLaunchDialog.6"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.breakOnFirstLine = this.createCheckButton(group, PHPServerUIMessages.getString("PHPWebPageLaunchDialog.7"));
        this.breakOnFirstLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPWebPageLaunchDialog.this.isBreakAtFirstLine = PHPWebPageLaunchDialog.this.breakOnFirstLine.getSelection();
            }
        });
    }

    private Button createCheckButton(Group group, String string) {
        return SWTFactory.createCheckButton((Composite)group, (String)string, null, (boolean)false, (int)1);
    }

    protected void createFileComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String projectLabel = PHPServerUIMessages.getString("ServerTab.file_project");
        group.setText(projectLabel);
        GridLayout layout = new GridLayout(3, false);
        GridData gd = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        this.fFile = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fFile.setLayoutData((Object)gd);
        this.fFile.addModifyListener((ModifyListener)this.fListener);
        this.fileButton = this.createPushButton(group, PHPServerUIMessages.getString("ServerTab.browse"));
        gd = (GridData)this.fileButton.getLayoutData();
        gd.horizontalSpan = 1;
        this.fileButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public void createURLControl(Composite composite) {
        Group group = new Group(composite, 0);
        String projectLabel = PHPServerUIMessages.getString("ServerTab.url");
        group.setText(projectLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.autoGeneratedURL = new Button((Composite)group, 32);
        this.autoGeneratedURL.setText(PHPServerUIMessages.getString("ServerTab.autoGenerate"));
        this.autoGeneratedURL.setSelection(true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.autoGeneratedURL.setLayoutData((Object)gridData);
        this.autoGeneratedURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPWebPageLaunchDialog.this.initializeURLControl();
            }
        });
        this.fURLLabel = new Label((Composite)group, 0);
        this.fURLLabel.setText(PHPServerUIMessages.getString("ServerTab.urlLabel"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 1;
        this.fURLLabel.setLayoutData((Object)gridData);
        Composite urlComposite = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        urlComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        urlComposite.setLayoutData((Object)gridData);
        this.fURLHost = new Text(urlComposite, 2052);
        gridData = new GridData(768);
        this.fURLHost.setLayoutData((Object)gridData);
        this.fURLHost.setEnabled(false);
        this.fURLPath = new Text(urlComposite, 2052);
        gridData = new GridData(768);
        this.fURLPath.setLayoutData((Object)gridData);
        this.fURLPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
    }

    private Button createPushButton(Group group, String string) {
        return SWTFactory.createPushButton((Composite)group, (String)string, null);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    public Server getServer() {
        return this.server;
    }

    public String getPhpPathString() {
        return this.pathString;
    }

    protected void handleFileButtonSelected() {
        IResource file = null;
        file = this.getFileFromDialog(this.project.getProject());
        if (file == null) {
            return;
        }
        String fName = file.getFullPath().toString();
        this.fFile.setText(fName);
        if (this.autoGeneratedURL.getSelection()) {
            this.updateURLComponents(this.computeURL(this.formatFileName(fName)));
        }
    }

    private IResource getFileFromDialog(IProject project) {
        String contenttypeidPhp = ContentTypeIdForPHP.ContentTypeID_PHP;
        IContentType contentType = Platform.getContentTypeManager().getContentType(contenttypeidPhp);
        String[] fileSpecs = contentType.getFileSpecs(8);
        return LaunchUtilities.getFileFromDialog((IProject)project, (Shell)this.getShell(), (String[])fileSpecs, (String[])new String[]{"org.eclipse.php.core.PHPNature"}, (boolean)false);
    }

    protected void initializeURLControl() {
        if (this.fFile == null || this.fURLPath == null || this.fURLHost == null) {
            return;
        }
        String file = this.autoGeneratedURL.getSelection() ? this.formatFileName(this.fFile.getText()) : this.fURLPath.getText();
        this.fURLPath.setEnabled(!this.autoGeneratedURL.getSelection());
        this.updateURLComponents(this.computeURL(file));
    }

    protected String computeURL(String fileName) {
        if (this.server == null) {
            return "";
        }
        String urlString = this.server.getBaseURL();
        if (urlString.equals("")) {
            urlString = "http://localhost";
        }
        StringBuffer url = new StringBuffer(urlString);
        if (!fileName.equals("")) {
            url.append(fileName);
        }
        return url.toString();
    }

    private String formatFileName(String fileName) {
        String formatFile = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(fileName);
        if (resource == null) {
            return fileName;
        }
        int type = resource.getType();
        formatFile = type == 1 || type == 2 ? resource.getFullPath().toString() : "/";
        if (!formatFile.startsWith("/")) {
            formatFile = "/" + formatFile;
        }
        return formatFile;
    }

    protected void updateURLComponents(String urlStr) {
        try {
            URL url = new URL(urlStr);
            String port = url.getPort() == -1 ? "" : ":" + url.getPort();
            this.fURLHost.setText(String.valueOf(url.getProtocol()) + "://" + url.getHost() + port + "/");
            if (url.getQuery() != null) {
                this.fURLPath.setText(String.valueOf(url.getPath()) + "?" + url.getQuery());
            } else {
                this.fURLPath.setText(url.getPath());
            }
        }
        catch (MalformedURLException e) {
            Logger.logException((Throwable)e);
        }
    }

    public boolean isBreakAtFirstLine() {
        return this.isBreakAtFirstLine;
    }

    private boolean validate() {
        String fileName = this.fFile.getText();
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fileName);
        if (!(resource instanceof IFile)) {
            this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.file_project_doesNotExist"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void setErrorMessage(String newErrorMessage) {
        if (newErrorMessage != null) {
            this.disableOkButton();
        } else {
            this.enableOkButton();
        }
        super.setErrorMessage(newErrorMessage);
    }

    protected void okPressed() {
        String urlPath = this.fURLPath.getText().replace('\\', '/');
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        this.pathString = String.valueOf(this.fURLHost.getText()) + urlPath;
        this.fileName = this.fFile.getText();
        super.okPressed();
    }

    public String getFilename() {
        return this.fileName;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            PHPWebPageLaunchDialog.this.initializeURLControl();
            PHPWebPageLaunchDialog.this.validate();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == PHPWebPageLaunchDialog.this.fileButton) {
                PHPWebPageLaunchDialog.this.handleFileButtonSelected();
            }
            PHPWebPageLaunchDialog.this.validate();
        }
    }
}

