/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class CommandsTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    protected static final char SELECTION_CHAR = '|';
    protected IProject project;
    protected IFile testFile;
    protected IFile[] otherFiles = new IFile[0];
    protected PHPVersion phpVersion;
    protected PHPStructuredEditor fEditor;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();

    static {
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/commands/php53"});
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    public CommandsTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = TestUtils.createProject((String)("Content Assist_" + this.phpVersion));
        DefaultScope.INSTANCE.getNode("org.eclipse.php.ui").putBoolean("contentAssistAutoinsert", true);
        TestUtils.setProjectPhpVersion((IProject)this.project, (PHPVersion)this.phpVersion);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject((IProject)this.project);
    }

    @After
    public void tearDown() throws Exception {
        if (this.testFile != null) {
            TestUtils.deleteFile((IFile)this.testFile);
        }
        if (this.otherFiles != null) {
            IFile[] iFileArray = this.otherFiles;
            int n = this.otherFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                TestUtils.deleteFile((IFile)f);
                ++n2;
            }
            this.otherFiles = null;
        }
    }

    @Test
    public void assist(String fileName) throws Exception {
        final PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        pdttFile.applyPreferences();
        final Exception[] err = new Exception[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ISourceRange range = CommandsTests.this.createFile(pdttFile.getFile(), Long.toString(System.currentTimeMillis()), CommandsTests.this.prepareOtherStreams(pdttFile));
                    CommandsTests.this.openEditor();
                    String result = CommandsTests.this.selectAndExecute(CommandsTests.this.getCommandId(pdttFile), range.getOffset(), range.getLength());
                    CommandsTests.this.closeEditor();
                    if (!pdttFile.getExpected().trim().equals(result.trim())) {
                        StringBuilder errorBuf = new StringBuilder();
                        errorBuf.append("\nEXPECTED RESULT:\n-----------------------------\n");
                        errorBuf.append(pdttFile.getExpected());
                        errorBuf.append("\nACTUAL RESULT:\n-----------------------------\n");
                        errorBuf.append(result);
                        Assert.fail((String)errorBuf.toString());
                    }
                }
                catch (Exception e) {
                    err[0] = e;
                }
            }
        });
        if (err[0] != null) {
            throw err[0];
        }
    }

    protected InputStream[] prepareOtherStreams(PdttFile file) {
        String[] contents = file.getOtherFiles();
        InputStream[] result = new InputStream[contents.length];
        int i = 0;
        while (i < contents.length) {
            result[i] = new ByteArrayInputStream(contents[i].getBytes());
            ++i;
        }
        return result;
    }

    protected void openEditor() throws Exception {
        FileEditorInput input;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)(input = new FileEditorInput(this.testFile)), "org.eclipse.php.test.editor", false);
        if (part instanceof PHPStructuredEditor) {
            this.fEditor = (PHPStructuredEditor)part;
        } else {
            Assert.assertTrue((String)"Unable to open php editor", (boolean)false);
        }
    }

    protected void closeEditor() {
        this.fEditor.doSave(null);
        this.fEditor.getSite().getPage().closeEditor((IEditorPart)this.fEditor, false);
        this.fEditor = null;
        if (this.testFile.exists()) {
            TestUtils.deleteFile((IFile)this.testFile);
        }
    }

    protected String selectAndExecute(String commandId, int offset, int length) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        StructuredTextViewer viewer = null;
        Display display = Display.getDefault();
        long timeout = System.currentTimeMillis() + 3000L;
        while (System.currentTimeMillis() < timeout && (viewer = this.fEditor.getTextViewer()) == null) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (viewer == null) {
            Assert.fail((String)("fEditor.getTextViewer() returns null for file " + this.testFile.getFullPath() + "(" + this.testFile.getLocation() + ")"));
        }
        viewer.setSelectedRange(offset, length);
        IWorkbench serviceLocator = PlatformUI.getWorkbench();
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        if (commandId == null) {
            Assert.fail((String)"command_id configuration entry is not added.");
        }
        handlerService.executeCommand(commandId, new Event());
        return this.fEditor.getDocument().get();
    }

    private String getCommandId(PdttFile pdttFile) {
        Map config = pdttFile.getConfig();
        return (String)config.get("command_id");
    }

    protected ISourceRange createFile(String data, String fileName, InputStream[] other) throws Exception {
        int left = data.indexOf(124);
        if (left == -1) {
            throw new IllegalArgumentException("Selection characters are not set");
        }
        int right = (data = String.valueOf(data.substring(0, left)) + data.substring(left + 1)).indexOf(124);
        if (right == -1) {
            throw new IllegalArgumentException("Selection is not closed");
        }
        data = String.valueOf(data.substring(0, right)) + data.substring(right + 1);
        this.testFile = TestUtils.createFile((IProject)this.project, (String)new Path(fileName).removeFileExtension().addFileExtension("php").lastSegment(), (String)data);
        this.otherFiles = new IFile[other.length];
        int i = 0;
        while (i < other.length) {
            this.otherFiles[i] = this.project.getFile(new Path(String.valueOf(i) + fileName).addFileExtension("php").lastSegment());
            this.otherFiles[i].create(other[i], true, null);
            ++i;
        }
        TestUtils.waitForIndexer();
        return new SourceRange(left, right - left);
    }
}

