/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPhp;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public class PHPSourceViewer
extends Composite
implements IPropertyChangeListener {
    private Color fDefaultBackground;
    private Color fDefaultForeground;
    private String fInput = "";
    private IStructuredDocumentRegion fNodes = null;
    private RegionParser fParser = null;
    private StyledText fText = null;
    private LineStyleProviderForPhp styleProvider;
    private IPreferenceStore editorStore = EditorsPlugin.getDefault().getPreferenceStore();

    public PHPSourceViewer(Composite parent, int style) {
        super(parent, style);
        this.fDefaultBackground = this.editorStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : new Color((Device)this.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)this.editorStore, (String)"AbstractTextEditor.Color.Background"));
        this.fDefaultForeground = this.editorStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : new Color((Device)this.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)this.editorStore, (String)"AbstractTextEditor.Color.Foreground"));
        this.editorStore.addPropertyChangeListener((IPropertyChangeListener)this);
        FillLayout layout = new FillLayout();
        this.setLayout((Layout)layout);
        this.createControls(this);
        this.setupViewer();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("AbstractTextEditor.Color.Background.SystemDefault".equals(event.getProperty())) {
            this.fDefaultBackground = this.editorStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)this.editorStore, (String)"AbstractTextEditor.Color.Background"));
            this.refresh();
        } else if ("AbstractTextEditor.Color.Foreground.SystemDefault".equals(event.getProperty())) {
            this.fDefaultForeground = this.editorStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)this.editorStore, (String)"AbstractTextEditor.Color.Foreground"));
            this.refresh();
        } else if ("AbstractTextEditor.Color.Background".equals(event.getProperty())) {
            this.fDefaultBackground = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)this.editorStore, (String)"AbstractTextEditor.Color.Background"));
            this.refresh();
        } else if ("AbstractTextEditor.Color.Foreground".equals(event.getProperty())) {
            this.fDefaultForeground = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)this.editorStore, (String)"AbstractTextEditor.Color.Foreground"));
            this.refresh();
        }
    }

    public void createControls(Composite parent) {
        this.fText = new StyledText(parent, 2818);
        this.fText.getContent().addTextChangeListener(new TextChangeListener(){
            DocumentReader docReader;
            Document document;

            public void textChanging(TextChangingEvent event) {
            }

            public void textChanged(TextChangedEvent event) {
                if (this.docReader == null) {
                    this.document = new Document();
                    this.docReader = new DocumentReader();
                }
                PHPSourceViewer.this.fInput = PHPSourceViewer.this.getText();
                this.document.set(PHPSourceViewer.this.fInput);
                this.docReader.reset((IDocument)this.document, 0);
                PHPSourceViewer.this.getParser().reset((Reader)this.docReader);
                PHPSourceViewer.this.fNodes = PHPSourceViewer.this.getParser().getDocumentRegions();
                PHPSourceViewer.this.applyStyles();
            }

            public void textSet(TextChangedEvent event) {
            }
        });
        this.fText.setBackground(this.fDefaultBackground);
        this.fText.setForeground(this.fDefaultForeground);
        this.fText.setFont(JFaceResources.getTextFont());
        this.setAccessible((Control)this.fText, SSEUIMessages.Sample_text__UI_);
    }

    public void setEditable(boolean editable) {
        this.fText.setEditable(editable);
    }

    public Color getDefaultBackground() {
        return this.fDefaultBackground;
    }

    public Color getDefaultForeground() {
        return this.fDefaultForeground;
    }

    public Font getFont() {
        return this.fText.getFont();
    }

    public RegionParser getParser() {
        return this.fParser;
    }

    public String getText() {
        return this.fText.getText();
    }

    public void refresh() {
        if (!this.fText.isDisposed()) {
            this.fText.setRedraw(false);
            this.fText.setBackground(this.fDefaultBackground);
            this.fText.setForeground(this.fDefaultForeground);
            this.fText.setFont(JFaceResources.getTextFont());
            this.applyStyles();
            this.fText.setRedraw(true);
        }
    }

    public void releasePickerResources() {
    }

    private void setAccessible(Control control, String name) {
        if (control == null) {
            return;
        }
        final String n = name;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = n;
                }
            }
        });
    }

    public void setDefaultBackground(Color newDefaultBackground) {
        this.fDefaultBackground = newDefaultBackground;
    }

    public void setDefaultForeground(Color newDefaultForeground) {
        this.fDefaultForeground = newDefaultForeground;
    }

    public void setFont(Font font) {
        this.fText.setFont(font);
        this.fText.redraw();
    }

    public void setParser(RegionParser newParser) {
        this.fParser = newParser;
    }

    public TextAttribute getAttribute(String namedStyle) {
        TextAttribute ta = new TextAttribute(this.getDefaultForeground(), this.getDefaultBackground(), 0);
        if (namedStyle != null && this.styleProvider != null) {
            ta = this.styleProvider.getTextAttributeForColor(namedStyle);
        }
        return ta;
    }

    public void applyStyles() {
        if (this.fText == null || this.fText.isDisposed() || this.fInput == null || this.fInput.length() == 0) {
            return;
        }
        this.styleProvider.loadColors();
        IStructuredDocumentRegion documentRegion = this.fNodes;
        while (documentRegion != null) {
            ArrayList<StyleRange> holdResults = new ArrayList<StyleRange>();
            this.styleProvider.prepareTextRegions(documentRegion, 0, documentRegion.getEnd(), holdResults);
            for (StyleRange element : holdResults) {
                this.fText.setStyleRange(element);
            }
            documentRegion = documentRegion.getNext();
        }
    }

    public void setText(String s) {
        this.fInput = s;
        DocumentReader docReader = new DocumentReader((IDocument)new Document(this.fInput));
        this.getParser().reset((Reader)docReader);
        this.fNodes = this.getParser().getDocumentRegions();
        if (this.fText != null) {
            this.fText.setText(s);
        }
        this.applyStyles();
    }

    public void setupViewer() {
        IModelManager mmanager = StructuredModelManager.getModelManager();
        this.setParser(mmanager.createStructuredDocumentFor(ContentTypeIdForPHP.ContentTypeID_PHP).getParser());
        this.styleProvider = new LineStyleProviderForPhp();
    }

    public StyledText getTextWidget() {
        return this.fText;
    }

    public void dispose() {
        this.editorStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fDefaultBackground.dispose();
        this.fDefaultForeground.dispose();
        super.dispose();
    }
}

