/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.templates.ScriptTemplateAccess;
import org.eclipse.dltk.ui.templates.ScriptTemplateCompletionProcessor;
import org.eclipse.dltk.ui.templates.ScriptTemplateContextType;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.window.Window;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateAccess;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateProposal;
import org.eclipse.php.internal.ui.text.template.contentassist.TemplateInformationControlCreator;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PhpTemplateCompletionProcessor
extends ScriptTemplateCompletionProcessor {
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";
    private static final ICompletionProposal[] EMPTY = new ICompletionProposal[0];
    private String contextTypeId = "php";
    private static char[] IGNORE = new char[]{'.', ':', '@', '$'};
    private IDocument document;
    private boolean explicit;
    private boolean isSelection;
    private final Map<IDocument, Position> fPositions = new HashMap<IDocument, Position>();
    private IMethod enclosingMethod;
    private IType enclosingType;

    public PhpTemplateCompletionProcessor(ScriptContentAssistInvocationContext context, boolean explicit) {
        super(context);
        this.explicit = explicit;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.document = viewer.getDocument();
        try {
            String type = TextUtilities.getContentType((IDocument)this.document, (String)"org.eclipse.wst.sse.core.default_structured_text_partitioning", (int)offset, (boolean)true);
            if (!"org.eclipse.php.PHP_DEFAULT".equals(type)) {
                return EMPTY;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (this.isInDocOrCommentOrString(viewer, offset)) {
            return EMPTY;
        }
        ISourceModule sourceModule = this.getContext().getSourceModule();
        if (sourceModule == null) {
            return EMPTY;
        }
        ArrayList<String> contextIds = new ArrayList<String>();
        contextIds.add(this.contextTypeId);
        try {
            IModelElement enclosingElement = sourceModule.getElementAt(offset);
            while (enclosingElement instanceof IField) {
                enclosingElement = enclosingElement.getParent();
            }
            if (enclosingElement instanceof IMethod) {
                this.enclosingMethod = (IMethod)enclosingElement;
            }
            boolean isFieldAccess = false;
            try {
                String accessPrefix;
                if (offset > 2 && ("->".equals(accessPrefix = this.document.get(offset - 2, 2)) || "::".equals(accessPrefix))) {
                    isFieldAccess = true;
                }
            }
            catch (BadLocationException badLocationException) {}
            while (enclosingElement != null && !(enclosingElement instanceof IType)) {
                enclosingElement = enclosingElement.getParent();
            }
            this.enclosingType = (IType)enclosingElement;
            if (this.enclosingMethod == null && this.enclosingType == null && !isFieldAccess) {
                contextIds.add("php-statements");
                contextIds.add("php-global-members");
            } else if (this.enclosingMethod == null && this.enclosingType != null && !isFieldAccess) {
                if (!PHPFlags.isNamespace((int)this.enclosingType.getFlags())) {
                    contextIds.add("php-type-members");
                    if (PHPFlags.isClass((int)this.enclosingType.getFlags())) {
                        contextIds.add("php-class-members");
                    }
                } else {
                    contextIds.add("php-statements");
                    contextIds.add("php-global-members");
                }
            } else if (this.enclosingMethod != null && this.enclosingType != null && !isFieldAccess) {
                if (!PHPFlags.isNamespace((int)this.enclosingType.getFlags())) {
                    contextIds.add("php-type-method-statements");
                }
                contextIds.add("php-statements");
            } else if (this.enclosingMethod != null && this.enclosingType == null) {
                contextIds.add("php-statements");
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log((Throwable)e);
        }
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        ICompletionProposal[] selectionProposal = EMPTY;
        if (selection.getLength() != 0) {
            Position position;
            this.isSelection = true;
            int tempOffset = offset;
            if (selection.getOffset() == tempOffset) {
                tempOffset = selection.getOffset() + selection.getLength();
            }
            String prefix = this.extractPrefix(viewer, tempOffset);
            Region region = new Region(selection.getOffset(), 0);
            TemplateContext context = this.createContext(viewer, (IRegion)region, position = new Position(offset, selection.getLength()));
            if (context == null) {
                return new ICompletionProposal[0];
            }
            try {
                this.document.addPosition(position);
                this.fPositions.put(this.document, position);
            }
            catch (BadLocationException badLocationException) {}
            context.setVariable("selection", selection.getText());
            boolean multipleLinesSelected = this.areMultipleLinesSelected(viewer);
            ArrayList<TemplateProposal> matches = new ArrayList<TemplateProposal>();
            Template[] templates = this.getTemplates(contextIds);
            int i = 0;
            while (i != templates.length) {
                Template template = templates[i];
                if (context.canEvaluate(template) && (!multipleLinesSelected && template.getPattern().indexOf($_WORD_SELECTION) != -1 || multipleLinesSelected && template.getPattern().indexOf($_LINE_SELECTION) != -1)) {
                    matches.add((TemplateProposal)this.createProposal(templates[i], context, (IRegion)region, this.getRelevance(template, prefix)));
                }
                ++i;
            }
            selectionProposal = matches.toArray(new ICompletionProposal[matches.size()]);
        } else {
            this.isSelection = false;
        }
        String prefix = this.extractPrefix(viewer, offset);
        if (!this.isValidPrefix(prefix)) {
            return new ICompletionProposal[0];
        }
        Region region = new Region(offset - prefix.length(), prefix.length());
        TemplateContext context = this.createContext(viewer, (IRegion)region);
        if (context == null) {
            return new ICompletionProposal[0];
        }
        context.setVariable("selection", selection.getText());
        ArrayList<TemplateProposal> matches = new ArrayList<TemplateProposal>();
        Template[] templates = this.getTemplates(contextIds);
        int i = 0;
        while (i < templates.length) {
            block41: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block41;
                }
                if (template.getName().startsWith(prefix)) {
                    matches.add((TemplateProposal)this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                }
            }
            ++i;
        }
        IInformationControlCreator controlCreator = this.getInformationControlCreator();
        for (TemplateProposal proposal : matches) {
            proposal.setInformationControlCreator(controlCreator);
        }
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        int i2 = 0;
        while (i2 < selectionProposal.length) {
            result.add(selectionProposal[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < matches.size()) {
            result.add((ICompletionProposal)matches.get(i2));
            ++i2;
        }
        return result.toArray(new ICompletionProposal[matches.size()]);
    }

    private Template[] getTemplates(List<String> contextIds) {
        ArrayList<Template> result = new ArrayList<Template>();
        for (String id : contextIds) {
            Template[] templates = this.getTemplates(id);
            result.addAll(Arrays.asList(templates));
        }
        return result.toArray(new Template[result.size()]);
    }

    public void reset() {
        for (Map.Entry<IDocument, Position> entry : this.fPositions.entrySet()) {
            IDocument doc = entry.getKey();
            Position position = entry.getValue();
            doc.removePosition(position);
        }
        this.fPositions.clear();
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region, Position position) {
        TemplateContextType contextType = this.getContextType(viewer, region);
        if (contextType instanceof ScriptTemplateContextType) {
            IDocument document = viewer.getDocument();
            ISourceModule sourceModule = this.getContext().getSourceModule();
            if (sourceModule == null) {
                return null;
            }
            return ((ScriptTemplateContextType)contextType).createContext(document, position, sourceModule);
        }
        return null;
    }

    protected boolean isValidPrefix(String prefix) {
        return this.explicit && !this.isSelection || prefix != null && prefix.length() != 0;
    }

    private boolean isInDocOrCommentOrString(ITextViewer viewer, int offset) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager != null) {
            IStructuredModel structuredModel = null;
            try {
                structuredModel = modelManager.getExistingModelForRead(viewer.getDocument());
                if (structuredModel instanceof DOMModelForPHP) {
                    IPhpScriptRegion phpScriptRegion;
                    String type;
                    IStructuredDocument document = structuredModel.getStructuredDocument();
                    IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
                    if (sdRegion == null) {
                        return false;
                    }
                    ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(offset);
                    if (textRegion == null) {
                        return false;
                    }
                    IStructuredDocumentRegion container = sdRegion;
                    if (textRegion instanceof ITextRegionContainer) {
                        container = (ITextRegionContainer)textRegion;
                        textRegion = container.getRegionAtCharacterOffset(offset);
                    }
                    if (textRegion.getType() == "PHP_CONTENT" && (PHPPartitionTypes.isPHPCommentState((String)(type = (textRegion = (phpScriptRegion = (IPhpScriptRegion)textRegion).getPhpToken(offset - container.getStartOffset() - phpScriptRegion.getStart())).getType())) || PHPPartitionTypes.isPHPQuotesState((String)type))) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected String extractPrefix(ITextViewer viewer, int offset) {
        i = offset;
        document = viewer.getDocument();
        if (i <= document.getLength()) ** GOTO lbl7
        return "";
        {
            while (Character.isLetterOrDigit(ch = document.getChar(i - 1)) || '@' == ch || '_' == ch || '$' == ch) {
                --i;
lbl7:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }

    protected Template[] getTemplates(String contextTypeId) {
        Template[] templates = null;
        TemplateStore store = this.getTemplateStore();
        if (store != null) {
            templates = store.getTemplates(contextTypeId);
        }
        return templates;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        TemplateContextType type = null;
        ContextTypeRegistry registry = this.getTemplateContextRegistry();
        if (registry != null) {
            type = registry.getContextType(this.contextTypeId);
        }
        return type;
    }

    protected Image getImage(Template template) {
        return PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_TEMPLATE);
    }

    protected ContextTypeRegistry getTemplateContextRegistry() {
        return PHPUiPlugin.getDefault().getTemplateContextRegistry();
    }

    protected TemplateStore getTemplateStore() {
        return PHPUiPlugin.getDefault().getTemplateStore();
    }

    public void setContextTypeId(String contextTypeId) {
        this.contextTypeId = contextTypeId;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new PhpTemplateProposal(template, context, region, this.getImage(template), relevance);
    }

    protected IInformationControlCreator getInformationControlCreator() {
        int orientation = Window.getDefaultOrientation();
        IEditorPart editor = this.getContext().getEditor();
        if (editor == null) {
            editor = DLTKUIPlugin.getActivePage().getActiveEditor();
        }
        if (editor instanceof IWorkbenchPartOrientation) {
            orientation = ((IWorkbenchPartOrientation)editor).getOrientation();
        }
        return new TemplateInformationControlCreator(orientation);
    }

    protected String getContextTypeId() {
        return this.contextTypeId;
    }

    protected char[] getIgnore() {
        return IGNORE;
    }

    protected ScriptTemplateAccess getTemplateAccess() {
        return PhpTemplateAccess.getInstance();
    }

    private boolean areMultipleLinesSelected(ITextViewer viewer) {
        if (viewer == null) {
            return false;
        }
        Point s = viewer.getSelectedRange();
        if (s.y == 0) {
            return false;
        }
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(s.x);
            int endLine = document.getLineOfOffset(s.x + s.y);
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || s.x == line.getOffset() && s.y == line.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected int getRelevance(Template template, String prefix) {
        return 80;
    }
}

