/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.ui.editor.SharedASTProvider;

public class PHPSelectionUtil {
    public static IModelElement getSelectionModelElement(int offset, int length, ISourceModule sourceModule) {
        IModelElement element;
        block11: {
            block10: {
                try {
                    if (sourceModule == null || !sourceModule.isConsistent()) {
                        return null;
                    }
                }
                catch (Exception e) {
                    if (DLTKCore.DEBUG) {
                        Logger.logException(e);
                    }
                    return null;
                }
                element = null;
                try {
                    IBinding binding;
                    ASTNode selectedNode;
                    Program ast = SharedASTProvider.getAST(sourceModule, SharedASTProvider.WAIT_NO, null);
                    if (ast != null && (selectedNode = NodeFinder.perform((ASTNode)ast, (int)offset, (int)length)) != null && selectedNode.getType() == 33 && (binding = ((Identifier)selectedNode).resolveBinding()) != null) {
                        element = binding.getPHPElement();
                    }
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG) break block10;
                    Logger.logException(e);
                }
            }
            if (element != null) {
                return element;
            }
            try {
                IModelElement[] selected = sourceModule.codeSelect(offset, length);
                element = selected.length > 0 ? selected[0] : sourceModule.getElementAt(offset);
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block11;
                Logger.logException(e);
            }
        }
        return element;
    }
}

