/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.buildpath.BuildPathParser;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.php.composer.test.ComposerCoreTestPlugin;
import org.eclipse.php.composer.test.ComposerModelTests;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.junit.Assert;
import org.junit.Test;

public class BuildPathTest
extends ComposerModelTests {
    public BuildPathTest() {
        super("BuildPath tests");
    }

    @Test
    public void testBuildpathParser() throws CoreException, IOException, InterruptedException {
        IScriptProject scriptProject = this.ensureScriptProject("buildpath");
        BuildPathTest.assertNotNull((Object)scriptProject);
        IProjectDescription desc = scriptProject.getProject().getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        scriptProject.getProject().setDescription(desc, null);
        ProjectOptions.setPHPVersion((PHPVersion)PHPVersion.PHP5_3, (IProject)scriptProject.getProject());
        PHPFacets.setFacetedVersion((IProject)scriptProject.getProject(), (PHPVersion)PHPVersion.PHP5_3);
        FacetManager.installFacets((IProject)scriptProject.getProject(), (PHPVersion)PHPVersion.PHP5_3, (IProgressMonitor)new NullProgressMonitor());
        scriptProject.getProject().refreshLocal(2, null);
        scriptProject.getProject().build(6, null);
        ComposerCoreTestPlugin.waitForIndexer();
        ComposerCoreTestPlugin.waitForAutoBuild();
        IFile file = scriptProject.getProject().getFile("composer.json");
        BuildPathTest.assertNotNull((Object)file);
        BuildPathTest.assertTrue((boolean)scriptProject.getProject().hasNature("org.eclipse.php.core.PHPNature"));
        BuildPathTest.assertTrue((boolean)FacetManager.hasComposerFacet((IProject)scriptProject.getProject()));
        IComposerProject composerProject = ComposerPlugin.getDefault().getComposerProject(scriptProject.getProject());
        BuildPathParser parser = new BuildPathParser(composerProject);
        List paths = parser.getPaths();
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("mordor/composer", "mordor/gossi/ldap/src", "mordor/phing/phing/classes/phing", "mordor/propel/propel1/generator/lib", "mordor/propel/propel1/runtime/lib", "mordor/symfony/console", "nother", "src", "test"));
        Assert.assertArrayEquals((Object[])paths.toArray(), (Object[])expected.toArray());
        Thread.sleep(2000L);
    }
}

