/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.TryStatement;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.YieldExpression;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP54;
import org.eclipse.php.core.tests.dom_ast.rewrite.NodeDeletionTestsPHP55;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

public class ASTRewriteTestsPHP55
extends ASTRewriteTestsPHP54 {
    @Override
    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP5_5;
    }

    @Test
    public void tryCatchFinallyStatement() throws Exception {
        String str = "<?php try { $error = 'Always throw this error'; } finally { echo '' }\n ?>";
        this.initialize(str);
        List<TryStatement> statements = this.getAllOfType(this.program, TryStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Block newBlock = this.ast.newBlock();
        newBlock.statements().add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Hello'")));
        statements.get(0).catchClauses().add(this.ast.newCatchClause(this.ast.newIdentifier("Boobo"), this.ast.newVariable("b"), newBlock));
        this.rewrite();
        this.checkResult("<?php try { $error = 'Always throw this error'; } catch (Boobo $b) {\necho 'Hello';\n} finally { echo '' }\n  ?>");
    }

    @Test
    public void yieldExpressionAdd() throws Exception {
        String str = "<?php yield; ?>";
        this.initialize(str);
        List<YieldExpression> yieldStatements = this.getAllOfType(this.program, YieldExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (yieldStatements.size() == 1 ? 1 : 0) != 0);
        yieldStatements.get(0).setExpression((Expression)this.ast.newVariable("a"));
        this.rewrite();
        String string = this.document.get();
        this.checkResult("<?php yield $a; ?>");
    }

    @Test
    public void yieldKeyAdd() throws Exception {
        String str = "<?php yield $a; ?>";
        this.initialize(str);
        List<YieldExpression> yieldStatements = this.getAllOfType(this.program, YieldExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (yieldStatements.size() == 1 ? 1 : 0) != 0);
        yieldStatements.get(0).setKey((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php yield $b => $a; ?>");
    }

    @Test
    public void yieldExprChange() throws Exception {
        String str = "<?php yield $a; ?>";
        this.initialize(str);
        List<YieldExpression> yieldStatements = this.getAllOfType(this.program, YieldExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (yieldStatements.size() == 1 ? 1 : 0) != 0);
        ((Variable)yieldStatements.get(0).getExpression()).setName((Expression)this.ast.newScalar("b"));
        this.rewrite();
        this.checkResult("<?php yield $b; ?>");
    }

    @Test
    public void yieldKeyChange() throws Exception {
        String str = "<?php yield $a => $b; ?>";
        this.initialize(str);
        List<YieldExpression> yieldStatements = this.getAllOfType(this.program, YieldExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (yieldStatements.size() == 1 ? 1 : 0) != 0);
        ((Variable)yieldStatements.get(0).getKey()).setName((Expression)this.ast.newScalar("c"));
        this.rewrite();
        this.checkResult("<?php yield $c => $b; ?>");
    }

    @RunWith(value=org.junit.runners.Suite.class)
    @Suite.SuiteClasses(value={ASTRewriteTestsPHP55.class, NodeDeletionTestsPHP55.class})
    public static class Suite {
    }
}

