/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.markoccurrence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.OccurrencesFinderFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class MarkOccurrenceTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    protected static final char OFFSET_CHAR = '|';
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    protected IFile testFile;
    protected final PHPVersion phpVersion;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/markoccurrence/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/markoccurrence/php5", "/workspace/markoccurrence/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/markoccurrence/php5", "/workspace/markoccurrence/php53", "/workspace/markoccurrence/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/markoccurrence/php5", "/workspace/markoccurrence/php53", "/workspace/markoccurrence/php54", "/workspace/markoccurrence/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/markoccurrence/php5", "/workspace/markoccurrence/php53", "/workspace/markoccurrence/php54", "/workspace/markoccurrence/php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/markoccurrence/php5", "/workspace/markoccurrence/php53", "/workspace/markoccurrence/php54", "/workspace/markoccurrence/php56"});
        TESTS.put(PHPVersion.PHP7_1, new String[]{"/workspace/markoccurrence/php5", "/workspace/markoccurrence/php53", "/workspace/markoccurrence/php54", "/workspace/markoccurrence/php56", "/workspace/markoccurrence/php71"});
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = TestUtils.createProject("MarkOccurrenceTests_" + this.phpVersion.toString());
        TestUtils.setProjectPHPVersion(this.project, this.phpVersion);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject(this.project);
    }

    @Test
    public void occurrences(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(fileName);
        pdttFile.applyPreferences();
        this.compareProposals(pdttFile.getFile());
    }

    @After
    public void after() throws CoreException {
        if (this.testFile != null) {
            this.testFile.delete(true, null);
            this.testFile = null;
        }
    }

    public MarkOccurrenceTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    protected void compareProposals(String data) throws Exception {
        IOccurrencesFinder finder;
        int type;
        int offset = data.lastIndexOf(124);
        if (offset == -1) {
            throw new IllegalArgumentException("Offset character is not set");
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int startIndex = -1;
        while ((startIndex = data.indexOf(37, startIndex + 1)) >= 0) {
            starts.add(startIndex);
        }
        if (starts.size() % 2 != 0) {
            throw new IllegalArgumentException("% must be paired");
        }
        ArrayList<Integer> newStarts = new ArrayList<Integer>();
        int i = 0;
        while (i < starts.size()) {
            int oldstart = (Integer)starts.get(i) - i;
            if ((Integer)starts.get(i) > offset) {
                --oldstart;
            }
            newStarts.add(oldstart);
            ++i;
        }
        data = data.replaceAll("%", "");
        offset = data.lastIndexOf(124);
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        this.testFile = TestUtils.createFile(this.project, "test.php", data);
        TestUtils.waitForIndexer();
        Program astRoot = this.createProgramFromSource(this.testFile);
        ASTNode selectedNode = NodeFinder.perform((ASTNode)astRoot, (int)offset, (int)0);
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        if (selectedNode != null && (selectedNode instanceof Identifier || MarkOccurrenceTests.isScalarButNotInString(selectedNode)) && MarkOccurrenceTests.markOccurrencesOfType(type = PHPElementConciliator.concile((ASTNode)selectedNode)) && (finder = OccurrencesFinderFactory.getOccurrencesFinder((int)type)) != null && finder.initialize(astRoot, selectedNode) == null) {
            locations = finder.getOccurrences();
        }
        MarkOccurrenceTests.compareProposals(locations, newStarts);
    }

    public static boolean markOccurrencesOfType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isScalarButNotInString(ASTNode node) {
        return node.getType() == 51 && node.getParent().getType() != 47;
    }

    public Program createProgramFromSource(IFile file) throws Exception {
        ISourceModule source = DLTKCore.createSourceModuleFrom((IFile)file);
        return this.createProgramFromSource(source);
    }

    public Program createProgramFromSource(ISourceModule source) throws Exception {
        PHPVersion version = this.project != null ? ProjectOptions.getPHPVersion((IProject)this.project) : ProjectOptions.getDefaultPHPVersion();
        ASTParser newParser = ASTParser.newParser((PHPVersion)version, (ISourceModule)source);
        return newParser.createAST(null);
    }

    protected ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)this.testFile);
    }

    public static void compareProposals(IOccurrencesFinder.OccurrenceLocation[] proposals, List<Integer> starts) throws Exception {
        proposals = MarkOccurrenceTests.olderLocations(proposals);
        boolean proposalsEqual = true;
        if (proposals != null || starts.size() != 0) {
            if (proposals != null && proposals.length == starts.size() / 2) {
                int i = 0;
                while (i < proposals.length) {
                    if (proposals[i].getOffset() != starts.get(i * 2).intValue() || proposals[i].getOffset() + proposals[i].getLength() != starts.get(i * 2 + 1)) {
                        proposalsEqual = false;
                        break;
                    }
                    ++i;
                }
            } else {
                proposalsEqual = false;
            }
        }
        if (!proposalsEqual) {
            StringBuilder errorBuf = new StringBuilder();
            errorBuf.append("\nEXPECTED COMPLETIONS LIST:\n-----------------------------\n");
            int i = 0;
            while (i < starts.size() / 2) {
                errorBuf.append('[').append(starts.get(i * 2)).append(',').append(starts.get(i * 2 + 1) - starts.get(i * 2)).append(']').append("\n");
                ++i;
            }
            errorBuf.append("\nACTUAL COMPLETIONS LIST:\n-----------------------------\n");
            IOccurrencesFinder.OccurrenceLocation[] occurrenceLocationArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                IOccurrencesFinder.OccurrenceLocation p = occurrenceLocationArray[n2];
                errorBuf.append('[').append(p.getOffset()).append(',').append(p.getLength()).append(']').append("\n");
                ++n2;
            }
            Assert.fail((String)errorBuf.toString());
        }
    }

    private static IOccurrencesFinder.OccurrenceLocation[] olderLocations(IOccurrencesFinder.OccurrenceLocation[] proposals) {
        if (proposals == null) {
            return new IOccurrencesFinder.OccurrenceLocation[0];
        }
        ArrayList<IOccurrencesFinder.OccurrenceLocation> result = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
        int i = 0;
        while (i < proposals.length) {
            result.add(proposals[i]);
            ++i;
        }
        Collections.sort(result, new Comparator<IOccurrencesFinder.OccurrenceLocation>(){

            @Override
            public int compare(IOccurrencesFinder.OccurrenceLocation o1, IOccurrencesFinder.OccurrenceLocation o2) {
                return o1.getOffset() - o2.getOffset();
            }
        });
        return result.toArray(new IOccurrencesFinder.OccurrenceLocation[result.size()]);
    }
}

