/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.model.VariablesUtil;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpContainerValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpEvalVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;

public class DBGpObjectValue
extends AbstractDBGpContainerValue {
    public DBGpObjectValue(DBGpVariable owner) {
        super(owner);
    }

    @Override
    protected void fetchVariables() {
        super.fetchVariables();
        VariablesUtil.sortObjectMembers(this.fCurrentVariables);
    }

    @Override
    protected IVariable createVariable(Node descriptor) {
        switch (this.getOwner().getKind()) {
            case EVAL: {
                return this.createEvalVariable(descriptor);
            }
        }
        return this.createStackVariable(descriptor);
    }

    @Override
    protected String createValueString(AbstractDBGpValue.DBGpValueData valueData) {
        return DBGpResponse.getAttribute(this.fDescriptor, "classname");
    }

    @Override
    protected boolean supportsValueModification() {
        return false;
    }

    @Override
    protected boolean verifyValue(String expression) {
        return false;
    }

    protected IVariable createStackVariable(Node descriptor) {
        return new DBGpStackVariable((DBGpTarget)this.getDebugTarget(), descriptor, this.getOwner().getStackLevel(), IVariableFacet.Facet.KIND_OBJECT_MEMBER);
    }

    protected IVariable createEvalVariable(Node descriptor) {
        DBGpEvalVariable variable = new DBGpEvalVariable((IDebugTarget)((DBGpTarget)this.getDebugTarget()), descriptor, IVariableFacet.Facet.KIND_OBJECT_MEMBER);
        variable.fFullName = String.valueOf(this.getOwner().getFullName()) + "->" + variable.fName;
        return variable;
    }

    @Override
    public String getValueDetail() throws DebugException {
        String toString = String.valueOf(this.fOwner.getFullName()) + "->__toString()";
        Node resp = ((DBGpTarget)this.fOwner.getDebugTarget()).eval(toString);
        if (resp == null) {
            return super.getValueDetail();
        }
        DBGpEvalVariable variable = new DBGpEvalVariable(this.fOwner.getDebugTarget(), toString, resp, new IVariableFacet.Facet[0]);
        return variable.getValue().getValueString();
    }
}

