/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.phpunit.ui.launch.AnyResourceTreeSelectionDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class OpenFileDialog {
    protected static final IStatus OK = new Status(0, "org.eclipse.php.phpunit", "");
    private ElementTreeSelectionDialog dialog;

    public OpenFileDialog(Shell shell, IContainer root, String title, String description, String newElemntDescription, String initialPath) {
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        AnyResourceTreeSelectionDialog dialog = new AnyResourceTreeSelectionDialog(shell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        this.dialog = dialog;
        IResource initialElement = null;
        if (!(initialPath == null || (initialElement = root.findMember((IPath)new Path(initialPath))) != null && initialElement.exists())) {
            initialElement = null;
        }
        dialog.setTitle(title);
        dialog.setMessage(description);
        dialog.setTextMessage(newElemntDescription);
        dialog.setInput(root);
        ISelectionStatusValidator validator = selection -> OK;
        dialog.setValidator(validator);
        dialog.setInitialSelection(initialElement);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setHelpAvailable(false);
    }

    public OpenFileDialog(Shell shell, IContainer root, String title, String description, String initialPath) {
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        this.dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        IResource initialElement = null;
        if (!(initialPath == null || initialPath.isEmpty() || (initialElement = root.findMember((IPath)new Path(initialPath))) != null && initialElement.exists())) {
            initialElement = null;
        }
        this.dialog.setTitle(title);
        this.dialog.setMessage(description);
        this.dialog.setInput((Object)root);
        ISelectionStatusValidator validator = selection -> OK;
        this.dialog.setValidator(validator);
        this.dialog.setInitialSelection((Object)initialElement);
        this.dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        this.dialog.setHelpAvailable(false);
    }

    public String openFile() {
        String[] out = this.open(false, new Class[]{IResource.class}, IFile.class);
        return out == null ? null : out[0];
    }

    public String openFolder() {
        String[] out = this.open(false, new Class[]{IContainer.class}, IFolder.class);
        return out == null ? null : out[0];
    }

    public String open() {
        String[] out = this.open(false, new Class[]{IResource.class}, IResource.class);
        return out == null ? null : out[0];
    }

    public String[] openMany() {
        return this.open(true, new Class[]{IResource.class}, IResource.class);
    }

    public static String openFile(Shell shell, IContainer root, String title, String description, String initialPath) {
        OpenFileDialog dialog = new OpenFileDialog(shell, root, title, description, initialPath);
        return dialog.openFile();
    }

    public static String openFolder(Shell shell, IContainer root, String title, String description, String initialPath) {
        OpenFileDialog dialog = new OpenFileDialog(shell, root, title, description, initialPath);
        return dialog.openFolder();
    }

    public static String open(Shell shell, IContainer root, String title, String description, String initialPath) {
        OpenFileDialog dialog = new OpenFileDialog(shell, root, title, description, initialPath);
        return dialog.open();
    }

    public static String[] openMany(Shell shell, IContainer root, String title, String description, String initialPath) {
        OpenFileDialog dialog = new OpenFileDialog(shell, root, title, description, initialPath);
        return dialog.openMany();
    }

    public static String[] openAny(Shell shell, IContainer root, String title, String description, String newElemLabel, String initialPath) {
        OpenFileDialog dialog = new OpenFileDialog(shell, root, title, description, newElemLabel, initialPath);
        return dialog.openMany();
    }

    private String[] open(boolean allowMultiple, final Class[] visibleTypes, Class selectable) {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                int i = 0;
                while (i < visibleTypes.length) {
                    if (visibleTypes[i].isAssignableFrom(element.getClass())) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
        this.dialog.addFilter(filter);
        this.dialog.setAllowMultiple(allowMultiple);
        if (this.dialog.open() == 0) {
            Object[] objects = this.dialog.getResult();
            if (objects.length == 0) {
                return null;
            }
            String[] paths = new String[objects.length];
            int i = 0;
            while (i < objects.length) {
                Object obj = objects[i];
                if (obj instanceof IResource) {
                    IResource file = (IResource)objects[i];
                    paths[i] = file.getFullPath().toString();
                } else if (obj instanceof IPath) {
                    paths[i] = ((IPath)obj).toPortableString();
                }
                ++i;
            }
            return paths;
        }
        return null;
    }
}

