/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.view;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestException;
import org.eclipse.php.phpunit.model.elements.PHPUnitTraceFrame;
import org.eclipse.php.phpunit.model.providers.PHPUnitTestTraceTreeContentProvider;
import org.eclipse.php.phpunit.ui.preference.PHPUnitPreferenceKeys;
import org.eclipse.php.phpunit.ui.view.PHPUnitView;
import org.eclipse.php.phpunit.ui.view.TestLabelProvider;
import org.eclipse.php.phpunit.ui.view.actions.EnableStackFilterAction;
import org.eclipse.php.phpunit.ui.view.actions.OpenEditorAction;
import org.eclipse.php.phpunit.ui.view.actions.OpenEditorAtLineAction;
import org.eclipse.php.phpunit.ui.view.actions.OpenTestAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;

public class FailureTrace
implements IMenuListener {
    private PHPUnitElement fInput;
    private final Image fStackIcon = PHPUnitPlugin.createImage("obj16/stkfrm_obj.png");
    private PHPUnitView fTestRunner;
    private TreeViewer fTreeViewer;

    public FailureTrace(Composite parent, PHPUnitView testRunner, ToolBar toolBar) {
        this.fTestRunner = testRunner;
        ToolBarManager failureToolBarmanager = new ToolBarManager(toolBar);
        failureToolBarmanager.add((IAction)new EnableStackFilterAction(this));
        failureToolBarmanager.update(true);
        this.fTreeViewer = new TreeViewer(parent, 772);
        this.fTreeViewer.setAutoExpandLevel(-1);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TestLabelProvider(this.fTestRunner));
        TestOpenListener testOpenListener = new TestOpenListener();
        this.fTreeViewer.getTree().addSelectionListener((SelectionListener)testOpenListener);
        this.initMenu();
        parent.addDisposeListener(e -> this.disposeIcons());
    }

    private void disposeIcons() {
        if (this.fStackIcon != null && !this.fStackIcon.isDisposed()) {
            this.fStackIcon.dispose();
        }
    }

    void handleDefaultSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        PHPUnitElement test = (PHPUnitElement)selection.getFirstElement();
        OpenEditorAction action = null;
        if (test instanceof PHPUnitTraceFrame) {
            PHPUnitTraceFrame frame = (PHPUnitTraceFrame)test;
            String methodName = frame.getFunction();
            action = new OpenEditorAtLineAction("", this.fTestRunner, frame.getFile(), frame.getLine(), methodName);
        } else if (test instanceof PHPUnitTestException) {
            PHPUnitTestException te = (PHPUnitTestException)test;
            PHPUnitTestCase parent = (PHPUnitTestCase)te.getParent();
            String methodName = parent.getName();
            action = new OpenEditorAtLineAction("", this.fTestRunner, test.getParent().getFile(), parent.getLine(), methodName);
        }
        if (action.isEnabled()) {
            action.run();
        }
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (!selection.isEmpty()) {
            PHPUnitElement test = (PHPUnitElement)selection.getFirstElement();
            String fileName = test.getLocalFile();
            int lineNumber = test.getLine();
            String methodName = null;
            if (test instanceof PHPUnitTraceFrame) {
                methodName = ((PHPUnitTraceFrame)test).getFunction();
            }
            if (test instanceof PHPUnitTestException) {
                manager.add((IAction)new OpenTestAction(OpenEditorAction.GOTO_CLASS, this.fTestRunner, ((PHPUnitTestException)test).getExceptionClass(), fileName, lineNumber));
            }
            if (test instanceof PHPUnitTraceFrame) {
                PHPUnitTraceFrame frame = (PHPUnitTraceFrame)test;
                String className = frame.getClassName();
                if (className != null && !className.equals("")) {
                    manager.add((IAction)new OpenTestAction(OpenEditorAction.GOTO_CLASS, this.fTestRunner, className, null, 0, null));
                    manager.add((IAction)new OpenTestAction(OpenEditorAction.GOTO_METHOD, this.fTestRunner, className, null, 0, methodName));
                } else {
                    manager.add((IAction)new OpenTestAction(OpenEditorAction.GOTO_FUNCTION, this.fTestRunner, null, null, 0, methodName));
                }
            }
        }
    }

    public void refresh() {
        this.showFailure(this.fInput);
    }

    public void showFailure(PHPUnitElement failure) {
        this.fTreeViewer.setContentProvider((IContentProvider)new PHPUnitTestTraceTreeContentProvider(PHPUnitPreferenceKeys.getFilterStack()));
        this.fTreeViewer.setInput((Object)failure);
        this.fInput = failure;
        this.fTreeViewer.refresh();
    }

    Composite getComposite() {
        return this.fTreeViewer.getTree();
    }

    private final class TestOpenListener
    extends SelectionAdapter {
        private TestOpenListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            FailureTrace.this.handleDefaultSelected();
        }
    }
}

