/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.AbstractRenameProcessor;
import org.eclipse.php.refactoring.core.rename.ITextUpdating;
import org.eclipse.php.refactoring.core.rename.logic.RenameGlobalConstant;

public class RenameGlobalConstantProcessor
extends AbstractRenameProcessor<IFile>
implements ITextUpdating {
    private static final String RENAME_IS_PROCESSING = PHPRefactoringCoreMessages.getString("RenameDefinedProcessor.0");
    private static final String CREATING_MODIFICATIONS_LABEL = PHPRefactoringCoreMessages.getString("RenameDefinedProcessor.1");
    private static final String CONSTANT_IS_USED = PHPRefactoringCoreMessages.getString("RenameDefinedProcessor.2");
    private static final String ID_RENAME_CONSTANT = "php.refactoring.ui.rename.constant";
    protected static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    public static final String RENAME_CONSTANT_PROCESSOR_NAME = PHPRefactoringCoreMessages.getString("RenameDefinedProcessor.3");
    private final Scalar scalar;
    private final String scalarName;
    private boolean isUpdateTextualMatches;

    public RenameGlobalConstantProcessor(IFile operatedFile, ASTNode locateNode) {
        super(operatedFile);
        this.scalar = this.getScalar(locateNode);
        String stringValue = this.scalar.getStringValue();
        char charAt = stringValue.charAt(0);
        this.scalarName = charAt != '\"' && charAt != '\'' ? stringValue : stringValue.substring(1, stringValue.length() - 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Scalar getScalar(ASTNode locateNode) {
        if (locateNode.getType() == 51) return (Scalar)locateNode;
        if (!(locateNode instanceof Identifier) || !"define".equals(((Identifier)locateNode).getName())) return null;
        FunctionInvocation inv = (FunctionInvocation)locateNode.getParent().getParent();
        List parameters = inv.parameters();
        if (parameters == null || parameters.size() <= 0) return null;
        return (Scalar)parameters.get(0);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange rootChange = new CompositeChange(PHPRefactoringCoreMessages.getString("RenameDefinedProcessor.4"));
        rootChange.markAsSynthetic();
        try {
            pm.beginTask(RENAME_IS_PROCESSING, this.participantFiles.size());
            pm.setTaskName(CREATING_MODIFICATIONS_LABEL);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            String newElementName = this.getNewElementName();
            for (Map.Entry entry : this.participantFiles.entrySet()) {
                IFile file = (IFile)entry.getKey();
                Program program = (Program)entry.getValue();
                RenameGlobalConstant rename = new RenameGlobalConstant(file, this.scalarName, newElementName, this.getUpdateTextualMatches());
                program.accept((Visitor)rename);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                pm.worked(1);
                if (!rename.hasChanges()) continue;
                TextFileChange change = this.acquireChange(file, program);
                rename.updateChange(change);
                rootChange.add((Change)change);
            }
            CompositeChange compositeChange = rootChange;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.scalar};
    }

    public String getIdentifier() {
        return ID_RENAME_CONSTANT;
    }

    public String getProcessorName() {
        return RENAME_CONSTANT_PROCESSOR_NAME;
    }

    @Override
    public Object getNewElement() {
        return this.getNewElementName();
    }

    @Override
    public String getCurrentElementName() {
        return this.scalarName;
    }

    @Override
    public boolean canEnableTextUpdating() {
        return true;
    }

    @Override
    public String getCurrentElementQualifier() {
        return this.scalarName;
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.isUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.isUpdateTextualMatches = update;
    }

    @Override
    public RefactoringStatus getRefactoringStatus(IFile key, Program program) {
        if (PHPElementConciliator.constantAlreadyExists((Program)program, (String)this.getNewElementName())) {
            String message = MessageFormat.format(CONSTANT_IS_USED, key.getName());
            return RefactoringStatus.createWarningStatus((String)message);
        }
        return null;
    }
}

