/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.internal.text.SelectionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension4;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.IPHPScriptReconcilingListener;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextAnnotationHover;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextProjectionAnnotationHover;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProcessor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.web.ui.SetupProjectsWizzard;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredDocumentToTextAdapter;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredRegionProcessor;

public class PHPStructuredTextViewer
extends StructuredTextViewer {
    public static final int SHOW_OUTLINE = 51;
    public static final int OPEN_STRUCTURE = 52;
    public static final int SHOW_HIERARCHY = 53;
    private static final String FORMAT_DOCUMENT_TEXT = SSEUIMessages.Format_Document_UI_;
    private SourceViewerConfiguration fViewerConfiguration;
    private ITextEditor fTextEditor;
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fHierarchyPresenter;
    private IAnnotationHover fProjectionAnnotationHover;
    private boolean fFireSelectionChanged = true;
    private IDocumentAdapter documentAdapter;
    private ContentAssistantFacade fContentAssistantFacade;
    private InternalCommandStackListener fInternalCommandStackListener;
    private int fPostSelectionLength;
    private int fPostSelectionOffset;

    public PHPStructuredTextViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
    }

    public PHPStructuredTextViewer(ITextEditor textEditor, Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.fTextEditor = textEditor;
        if (this.fTextEditor instanceof PHPStructuredEditor) {
            PHPStructuredEditor phpEditor = (PHPStructuredEditor)this.fTextEditor;
            phpEditor.addReconcileListener(new IPHPScriptReconcilingListener(){

                @Override
                public void reconciled(Program program, boolean forced, IProgressMonitor progressMonitor) {
                    if (PHPStructuredTextViewer.this.fPostSelectionLength != -1) {
                        Display.getDefault().syncExec(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                PHPStructuredTextViewer pHPStructuredTextViewer = PHPStructuredTextViewer.this;
                                synchronized (pHPStructuredTextViewer) {
                                    if (PHPStructuredTextViewer.this.fPostSelectionOffset >= 0 && PHPStructuredTextViewer.this.fPostSelectionLength >= 0 && PHPStructuredTextViewer.this.getDocument() != null) {
                                        PHPStructuredTextViewer.this.firePostSelectionChanged(PHPStructuredTextViewer.this.fPostSelectionOffset, PHPStructuredTextViewer.this.fPostSelectionLength);
                                    }
                                }
                            }
                        });
                    }
                }

                @Override
                public void aboutToBeReconciled() {
                }
            });
        }
    }

    public ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    public void doOperation(int operation) {
        Point selection = this.getTextWidget().getSelection();
        int cursorPosition = selection.x;
        int selectionLength = selection.y - selection.x;
        int topLine = this.getTextWidget().getTopIndex();
        switch (operation) {
            case 23: {
                try {
                    this.setRedraw(false);
                    this.beginRecording(FORMAT_DOCUMENT_TEXT, FORMAT_DOCUMENT_TEXT, cursorPosition, selectionLength);
                    Region region = selectionLength != 0 ? new Region(cursorPosition, selectionLength) : new Region(0, this.getDocument().getLength());
                    if (this.fContentFormatter instanceof IContentFormatterExtension) {
                        IContentFormatterExtension extension = (IContentFormatterExtension)this.fContentFormatter;
                        FormattingContext context = new FormattingContext();
                        context.setProperty((Object)"formatting.context.document", (Object)Boolean.TRUE);
                        context.setProperty((Object)"formatting.context.region", (Object)region);
                        extension.format(this.getDocument(), (IFormattingContext)context);
                    } else {
                        this.fContentFormatter.format(this.getDocument(), (IRegion)region);
                    }
                }
                finally {
                    selection = this.getTextWidget().getSelection();
                    selectionLength = selection.y - selection.x;
                    this.endRecording(cursorPosition, selectionLength);
                    this.getTextWidget().setSelection(cursorPosition);
                    this.getTextWidget().setTopIndex(topLine);
                    this.setRedraw(true);
                }
                return;
            }
            case 13: {
                if (this.fViewerConfiguration != null) {
                    IProject project = null;
                    boolean isJavaScriptRegion = false;
                    boolean hasJavaScriptNature = true;
                    try {
                        Shell activeWorkbenchShell;
                        int addJavaScriptSupport;
                        IScriptProject scriptProject;
                        PHPStructuredEditor phpEditor;
                        IModelElement modelElement;
                        IStructuredDocument sDoc = (IStructuredDocument)this.getDocument();
                        int selectionOffset = this.getSelectedRange().x;
                        IStructuredDocumentRegion sdRegion = sDoc.getRegionAtCharacterOffset(selectionOffset);
                        if (sdRegion == null) {
                            super.doOperation(operation);
                            return;
                        }
                        ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(selectionOffset);
                        if (textRegion instanceof ForeignRegion) {
                            ForeignRegion foreignRegion = (ForeignRegion)textRegion;
                            isJavaScriptRegion = "script".equalsIgnoreCase(foreignRegion.getSurroundingTag());
                        }
                        if (this.fTextEditor instanceof PHPStructuredEditor && (modelElement = (phpEditor = (PHPStructuredEditor)this.fTextEditor).getModelElement()) != null && (project = (scriptProject = modelElement.getScriptProject()).getProject()) != null && project.isAccessible() && project.getNature("org.eclipse.wst.jsdt.core.jsNature") == null) {
                            hasJavaScriptNature = false;
                        }
                        if (isJavaScriptRegion && !hasJavaScriptNature && (addJavaScriptSupport = OptionalMessageDialog.open((String)"PROMPT_ADD_JAVASCRIPT_SUPPORT", (Shell)(activeWorkbenchShell = PHPUiPlugin.getActiveWorkbenchShell()), (String)PHPUIMessages.PHPStructuredTextViewer_0, null, (String)PHPUIMessages.PHPStructuredTextViewer_1, (int)3, (String[])new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, (int)0)) == 0 && project != null) {
                            SetupProjectsWizzard wiz = new SetupProjectsWizzard();
                            wiz.setActivePart(null, (IWorkbenchPart)this.getTextEditor());
                            wiz.selectionChanged(null, (ISelection)new StructuredSelection((Object)project));
                            wiz.run(null);
                        }
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
                if (this.fViewerConfiguration != null) {
                    IContentAssistProcessor[] all;
                    PHPStructuredTextViewerConfiguration structuredTextViewerConfiguration = (PHPStructuredTextViewerConfiguration)this.fViewerConfiguration;
                    IContentAssistProcessor[] iContentAssistProcessorArray = all = structuredTextViewerConfiguration.getContentAssistProcessors((ISourceViewer)this, "org.eclipse.php.PHP_DEFAULT");
                    int n = all.length;
                    int e = 0;
                    while (e < n) {
                        IContentAssistProcessor element = iContentAssistProcessorArray[e];
                        if (element instanceof PHPCompletionProcessor) {
                            ((PHPCompletionProcessor)element).setExplicit(true);
                        }
                        ++e;
                    }
                }
                super.doOperation(operation);
                return;
            }
            case 51: {
                if (this.fOutlinePresenter != null) {
                    this.fOutlinePresenter.showInformation();
                }
                return;
            }
            case 53: {
                if (this.fHierarchyPresenter != null) {
                    this.fHierarchyPresenter.showInformation();
                }
                return;
            }
            case 6: {
                StyledText textWidget = this.getTextWidget();
                if (textWidget == null) {
                    return;
                }
                ITextSelection textSelection = null;
                if (this.redraws()) {
                    try {
                        textSelection = (ITextSelection)this.getSelection();
                        int length = textSelection.getLength();
                        if (!(textWidget.getBlockSelection() || length != 0 && length != textWidget.getSelectionRange().y)) {
                            this.getTextWidget().invokeAction(127);
                        } else {
                            this.deleteSelection(textSelection, textWidget);
                        }
                        if (this.fFireSelectionChanged) {
                            Point range = textWidget.getSelectionRange();
                            this.fireSelectionChanged(range.x, range.y);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        super.doOperation(operation);
    }

    public void setFireSelectionChanged(boolean fireSelectionChanged) {
        this.fFireSelectionChanged = fireSelectionChanged;
    }

    private void deleteSelection(ITextSelection selection, StyledText textWidget) throws BadLocationException {
        new SelectionProcessor((ITextViewer)this).doDelete((ISelection)selection);
    }

    public boolean canDoOperation(int operation) {
        if (operation == 53) {
            return this.fHierarchyPresenter != null;
        }
        if (operation == 51) {
            return this.fOutlinePresenter != null;
        }
        return super.canDoOperation(operation);
    }

    private void beginRecording(String label, String description, int cursorPosition, int selectionLength) {
        IDocument doc = this.getDocument();
        if (doc instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)doc;
            IStructuredTextUndoManager undoManager = structuredDocument.getUndoManager();
            undoManager.beginRecording((Object)this, label, description, cursorPosition, selectionLength);
        }
    }

    private void endRecording(int cursorPosition, int selectionLength) {
        IDocument doc = this.getDocument();
        if (doc instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)doc;
            IStructuredTextUndoManager undoManager = structuredDocument.getUndoManager();
            undoManager.endRecording((Object)this, cursorPosition, selectionLength);
        }
    }

    protected IDocumentAdapter createDocumentAdapter() {
        this.documentAdapter = new StructuredDocumentToTextAdapterForPHP(this.getTextWidget());
        return this.documentAdapter;
    }

    public IDocumentAdapter getDocumentAdapter() {
        return this.documentAdapter;
    }

    public void addVerticalRulerColumn(IVerticalRulerColumn column) {
        if (this.fProjectionAnnotationHover == null) {
            this.fProjectionAnnotationHover = new PHPStructuredTextProjectionAnnotationHover();
        }
        ((AnnotationRulerColumn)column).setHover(this.fProjectionAnnotationHover);
        super.addVerticalRulerColumn(column);
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        if (this.fAnnotationHover instanceof StructuredTextAnnotationHover) {
            ((StructuredTextAnnotationHover)this.fAnnotationHover).release();
        }
        this.setAnnotationHover((IAnnotationHover)new PHPStructuredTextAnnotationHover());
        this.ensureAnnotationHoverManagerInstalled();
        if (!(configuration instanceof PHPStructuredTextViewerConfiguration)) {
            return;
        }
        this.fViewerConfiguration = configuration;
        PHPStructuredTextViewerConfiguration phpConfiguration = (PHPStructuredTextViewerConfiguration)configuration;
        IContentAssistant newPHPAssistant = phpConfiguration.getPHPContentAssistant((ISourceViewer)this, true);
        if (this.fContentAssistant != null) {
            this.fContentAssistant.uninstall();
        }
        this.fContentAssistant = newPHPAssistant;
        if (this.fContentAssistant != null) {
            this.fContentAssistant.install((ITextViewer)this);
            if (this.fContentAssistant instanceof IContentAssistantExtension2 && this.fContentAssistant instanceof IContentAssistantExtension4) {
                this.fContentAssistantFacade = new ContentAssistantFacade(this.fContentAssistant);
            }
            this.fContentAssistantInstalled = true;
        } else {
            this.enableOperation(13, false);
        }
        this.fOutlinePresenter = phpConfiguration.getOutlinePresenter((ISourceViewer)this);
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.install((ITextViewer)this);
        }
        this.fHierarchyPresenter = phpConfiguration.getHierarchyPresenter(this, true);
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.install((ITextViewer)this);
        }
    }

    public void unconfigure() {
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        super.unconfigure();
    }

    protected void ensureAnnotationHoverManagerInstalled() {
        if (this.fAnnotationHover instanceof PHPStructuredTextAnnotationHover) {
            super.ensureAnnotationHoverManagerInstalled();
        }
    }

    public int modelLine2WidgetLine(int modelLine) {
        try {
            return super.modelLine2WidgetLine(modelLine);
        }
        catch (IllegalStateException e) {
            return -1;
        }
    }

    protected int getClosestWidgetLineForModelLine(int modelLine) {
        try {
            return super.getClosestWidgetLineForModelLine(modelLine);
        }
        catch (IllegalStateException e) {
            return -1;
        }
    }

    public void reconcile() {
        ((StructuredRegionProcessor)this.fReconciler).processDirtyRegion(new DirtyRegion(0, this.getDocument().getLength(), "__insert", this.getDocument().get()));
    }

    void setReconciler(IReconciler reconciler) {
        this.fReconciler = reconciler;
    }

    IReconciler getReconciler() {
        return this.fReconciler;
    }

    public void prependTextPresentationListener(ITextPresentationListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextPresentationListeners == null) {
            this.fTextPresentationListeners = new ArrayList();
        }
        this.fTextPresentationListeners.remove(listener);
        this.fTextPresentationListeners.add(0, listener);
    }

    protected void selectionChanged(int offset, int length) {
        if (this.fFireSelectionChanged) {
            super.selectionChanged(offset, length);
        }
    }

    public SourceViewerConfiguration getViewerConfiguration() {
        return this.fViewerConfiguration;
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        CommandStack commandStack;
        if (this.getDocument() instanceof IStructuredDocument && (commandStack = ((IStructuredDocument)this.getDocument()).getUndoManager().getCommandStack()) instanceof BasicCommandStack) {
            commandStack.addCommandStackListener(this.getInternalCommandStackListener());
        }
        super.setDocument(document, annotationModel, modelRangeOffset, modelRangeLength);
        if (this.getDocument() instanceof IStructuredDocument && (commandStack = ((IStructuredDocument)this.getDocument()).getUndoManager().getCommandStack()) instanceof BasicCommandStack) {
            commandStack.addCommandStackListener(this.getInternalCommandStackListener());
        }
    }

    private void fireDirty() {
        if (this.fTextEditor instanceof PHPStructuredEditor) {
            PHPStructuredEditor phpEditor = (PHPStructuredEditor)this.fTextEditor;
            phpEditor.firePropertyChange(257);
        }
    }

    private CommandStackListener getInternalCommandStackListener() {
        if (this.fInternalCommandStackListener == null) {
            this.fInternalCommandStackListener = new InternalCommandStackListener();
        }
        return this.fInternalCommandStackListener;
    }

    public ContentAssistantFacade getContentAssistFacade() {
        return this.fContentAssistantFacade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePostSelectionChanged(int offset, int length) {
        PHPStructuredTextViewer pHPStructuredTextViewer = this;
        synchronized (pHPStructuredTextViewer) {
            if (this.fTextEditor instanceof PHPStructuredEditor && !((PHPStructuredEditor)this.fTextEditor).fReconcileSelection) {
                super.firePostSelectionChanged(offset, length);
                this.fPostSelectionOffset = -1;
                this.fPostSelectionLength = -1;
            } else {
                this.fPostSelectionOffset = offset;
                this.fPostSelectionLength = length;
            }
        }
    }

    class InternalCommandStackListener
    implements CommandStackListener {
        InternalCommandStackListener() {
        }

        public void commandStackChanged(EventObject event) {
            PHPStructuredTextViewer.this.fireDirty();
        }
    }

    public class StructuredDocumentToTextAdapterForPHP
    extends StructuredDocumentToTextAdapter {
        public StructuredDocumentToTextAdapterForPHP() {
        }

        public StructuredDocumentToTextAdapterForPHP(StyledText styledTextWidget) {
            super(styledTextWidget);
        }

        protected void redrawRegionChanged(RegionChangedEvent structuredDocumentEvent) {
            IPHPScriptRegion region;
            if (structuredDocumentEvent != null && structuredDocumentEvent.getRegion() != null && structuredDocumentEvent.getRegion().getType() == "PHP_CONTENT" && (region = (IPHPScriptRegion)structuredDocumentEvent.getRegion()).isFullReparsed()) {
                TextRegionListImpl newList = new TextRegionListImpl();
                newList.add((ITextRegion)region);
                IStructuredDocumentRegion structuredDocumentRegion = structuredDocumentEvent.getStructuredDocumentRegion();
                IStructuredDocument structuredDocument = structuredDocumentEvent.getStructuredDocument();
                RegionsReplacedEvent regionsReplacedEvent = new RegionsReplacedEvent(structuredDocument, (Object)structuredDocumentRegion, structuredDocumentRegion, null, (ITextRegionList)newList, null, 0, 0);
                this.redrawRegionsReplaced(regionsReplacedEvent);
            }
            super.redrawRegionChanged(structuredDocumentEvent);
        }
    }
}

