/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.ArrayCreation;
import org.eclipse.php.core.ast.nodes.Assignment;
import org.eclipse.php.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.ThrowStatement;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.ui.corext.codemanipulation.StubUtility;

public class CodeGeneration {
    private static final String UNKNOWN_TYPE = UnknownType.INSTANCE.getTypeName();
    public static final String CLASS_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.classbody";
    public static final String INTERFACE_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.interfacebody";
    public static final String ENUM_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.enumbody";
    public static final String ANNOTATION_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.annotationbody";
    private static final String[] EMPTY = new String[0];

    private CodeGeneration() {
    }

    public static String getCompilationUnitContent(IScriptProject sp, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        return CodeGeneration.getCompilationUnitContent(sp, CodeGeneration.getFileComment(sp, lineDelimiter), typeComment, typeContent, lineDelimiter);
    }

    public static String getCompilationUnitContent(IScriptProject sp, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        return StubUtility.getCompilationUnitContent(sp, fileComment, typeComment, typeContent, lineDelimiter);
    }

    public static String getFileComment(ISourceModule sm, String lineDelimiter) throws CoreException {
        return StubUtility.getFileComment(sm, lineDelimiter);
    }

    public static String getFileComment(IScriptProject sp, String lineDelimiter) throws CoreException {
        return StubUtility.getFileComment(sp, lineDelimiter);
    }

    public static String getTypeComment(IScriptProject sp, String typeQualifiedName, String lineDelimiter) throws CoreException {
        return StubUtility.getTypeComment(sp, typeQualifiedName, EMPTY, lineDelimiter);
    }

    public static String getTypeComment(IScriptProject sp, String typeQualifiedName, String[] typeParameterNames, String lineDelimiter) throws CoreException {
        return StubUtility.getTypeComment(sp, typeQualifiedName, typeParameterNames, lineDelimiter);
    }

    public static String getTypeBody(String typeKind, IScriptProject sp, String typeName, String lineDelim) throws CoreException {
        return StubUtility.getTypeBody(typeKind, sp, typeName, lineDelim);
    }

    public static String getFieldComment(IScriptProject sp, IField field, String lineDelimiter) throws CoreException {
        ConstantDeclaration constDeclaration;
        Identifier[] varDeclarations;
        Boolean isVar = false;
        Program program = null;
        if (program == null && (program = CodeGeneration.generateProgram((IMember)field, null)) == null) {
            return null;
        }
        ASTNode elementAt = program.getElementAt(field.getSourceRange().getOffset());
        Expression[] expressions = new Expression[1];
        ITypeBinding[] varTypes = new ITypeBinding[1];
        String[] fieldNames = new String[]{field.getElementName()};
        if (elementAt instanceof Variable) {
            isVar = true;
            Variable varDeclaration = (Variable)elementAt;
            if (varDeclaration.getParent() instanceof Assignment) {
                expressions[0] = ((Assignment)varDeclaration.getParent()).getRightHandSide();
                varTypes[0] = expressions[0].resolveTypeBinding();
            } else {
                varTypes[0] = varDeclaration.resolveTypeBinding();
            }
        } else if (elementAt instanceof FieldsDeclaration) {
            FieldsDeclaration fieldDeclaration = (FieldsDeclaration)elementAt;
            Variable[] varDeclarations2 = fieldDeclaration.getVariableNames();
            if (varDeclarations2.length > 0) {
                expressions = fieldDeclaration.getInitialValues();
                assert (varDeclarations2.length == expressions.length);
                varTypes = new ITypeBinding[varDeclarations2.length];
                fieldNames = new String[varDeclarations2.length];
                int i = 0;
                while (i < varDeclarations2.length) {
                    varTypes[i] = varDeclarations2[i].resolveTypeBinding();
                    fieldNames[i] = CodeGeneration.getVarName(varDeclarations2[i]);
                    ++i;
                }
            }
        } else if (elementAt instanceof ConstantDeclaration && (varDeclarations = (constDeclaration = (ConstantDeclaration)elementAt).names().toArray(new Identifier[0])).length > 0) {
            expressions = constDeclaration.initializers().toArray(new Expression[0]);
            assert (varDeclarations.length == expressions.length);
            varTypes = new ITypeBinding[varDeclarations.length];
            fieldNames = new String[varDeclarations.length];
            int i = 0;
            while (i < varDeclarations.length) {
                varTypes[i] = varDeclarations[i].resolveTypeBinding();
                fieldNames[i] = CodeGeneration.getVarName(varDeclarations[i]);
                ++i;
            }
        }
        String[] fieldTypes = CodeGeneration.getFieldTypes(varTypes, expressions);
        if (isVar.booleanValue() || fieldTypes.length > 1) {
            return StubUtility.getMultipleFieldsComment(sp, fieldTypes, fieldNames, lineDelimiter);
        }
        return StubUtility.getFieldComment(sp, fieldTypes[0], fieldNames[0], lineDelimiter);
    }

    private static String getVarName(Identifier varDeclaration) {
        return String.valueOf('$') + varDeclaration.getName();
    }

    private static String getVarName(Variable varDeclaration) {
        if (varDeclaration.getName() instanceof Identifier) {
            Identifier id = (Identifier)varDeclaration.getName();
            return CodeGeneration.getVarName(id);
        }
        return "";
    }

    public static String[] getFieldTypes(ITypeBinding[] varTypes, Expression[] expressions) {
        String[] fieldTypes = new String[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            Expression expression = expressions[i];
            ITypeBinding varType = varTypes[i];
            if (expression instanceof ArrayCreation) {
                fieldTypes[i] = PHPSimpleTypes.ARRAY.getTypeName();
            } else if (expression instanceof Scalar) {
                Scalar scalar = (Scalar)expression;
                switch (scalar.getScalarType()) {
                    case 0: {
                        fieldTypes[i] = "integer";
                        break;
                    }
                    case 2: {
                        if (!expression.isNullExpression()) {
                            fieldTypes[i] = PHPSimpleTypes.STRING.getTypeName();
                            break;
                        }
                        varType = null;
                    }
                }
            }
            if (fieldTypes[i] == null && varType != null) {
                fieldTypes[i] = varType.isArray() ? PHPSimpleTypes.ARRAY.getTypeName() : (varType.isAmbiguous() ? "Ambiguous" : varType.getName());
            }
            if (fieldTypes[i] == null) {
                fieldTypes[i] = UNKNOWN_TYPE;
            }
            ++i;
        }
        return fieldTypes;
    }

    public static String getMethodComment(IScriptProject sp, String declaringTypeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, IMethod overridden, String lineDelimiter, List<String> exceptions) throws CoreException {
        return StubUtility.getMethodComment(sp, declaringTypeName, methodName, paramNames, retTypeSig, EMPTY, overridden, false, lineDelimiter, exceptions);
    }

    public static String getMethodComment(IScriptProject sp, String declaringTypeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, String[] typeParameterNames, IMethod overridden, String lineDelimiter, List<String> exceptions) throws CoreException {
        return StubUtility.getMethodComment(sp, declaringTypeName, methodName, paramNames, retTypeSig, typeParameterNames, overridden, false, lineDelimiter, exceptions);
    }

    public static String getMethodComment(IMethod method, IMethod overridden, String lineDelimiter) throws CoreException {
        int i;
        StringBuilder returnTypeBuffer;
        Identifier returnType;
        ASTNode elementAt;
        Program program;
        String[] parameterTypes;
        String[] typeParameterNames;
        String retType;
        block38: {
            retType = null;
            typeParameterNames = null;
            parameterTypes = null;
            program = null;
            if (program == null && (program = CodeGeneration.generateProgram((IMember)method, null)) == null) {
                return null;
            }
            elementAt = null;
            try {
                elementAt = program.getElementAt(method.getSourceRange().getOffset());
            }
            catch (IllegalArgumentException e) {
                program = CodeGeneration.generateProgram((IMember)method, null);
                if (program == null) {
                    return null;
                }
                elementAt = program.getElementAt(method.getSourceRange().getOffset());
                if (elementAt != null) break block38;
                return null;
            }
        }
        if (!(elementAt instanceof MethodDeclaration || elementAt instanceof FunctionDeclaration || elementAt.getParent() instanceof MethodDeclaration)) {
            if ((program = CodeGeneration.generateProgram((IMember)method, program)) == null) {
                return null;
            }
            elementAt = program.getElementAt(method.getSourceRange().getOffset());
        }
        if (elementAt.getParent() instanceof MethodDeclaration) {
            elementAt = elementAt.getParent();
        }
        ITypeBinding[] returnTypes = null;
        ITypeBinding[] typeParametersTypes = null;
        IMethodBinding resolvedBinding = null;
        List formalParameters = null;
        if (elementAt instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)elementAt;
            resolvedBinding = methodDeclaration.resolveMethodBinding();
            formalParameters = methodDeclaration.getFunction().formalParameters();
            returnType = methodDeclaration.getFunction().getReturnType();
            if (returnType != null) {
                if (returnType.isNullable()) {
                    returnTypeBuffer = new StringBuilder();
                    returnTypeBuffer.append(returnType.getName()).append('|').append(PHPSimpleTypes.NULL.getTypeName());
                    retType = returnTypeBuffer.toString();
                } else {
                    retType = returnType.getName();
                }
            }
        } else if (elementAt instanceof FunctionDeclaration) {
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)elementAt;
            resolvedBinding = functionDeclaration.resolveFunctionBinding();
            formalParameters = functionDeclaration.formalParameters();
            returnType = functionDeclaration.getReturnType();
            if (returnType != null) {
                if (returnType.isNullable()) {
                    returnTypeBuffer = new StringBuilder();
                    returnTypeBuffer.append(returnType.getName()).append('|').append(PHPSimpleTypes.NULL.getTypeName());
                    retType = returnTypeBuffer.toString();
                } else {
                    retType = returnType.getName();
                }
            }
        }
        final ArrayList exceptions = new ArrayList();
        elementAt.accept((Visitor)new AbstractVisitor(){

            public boolean visit(ThrowStatement throwStatement) {
                ITypeBinding type;
                ClassInstanceCreation cic;
                Expression expression = throwStatement.getExpression();
                if (expression instanceof ClassInstanceCreation && (cic = (ClassInstanceCreation)throwStatement.getExpression()).getClassName().getName() instanceof Identifier) {
                    Identifier name = (Identifier)cic.getClassName().getName();
                    exceptions.add(name.getName());
                }
                if (expression instanceof Variable && (type = ((Variable)expression).resolveTypeBinding()) != null) {
                    exceptions.add(type.getName());
                }
                return true;
            }
        });
        ArrayList<String> newExceptions = new ArrayList<String>();
        HashSet<String> exceptionSet = new HashSet<String>();
        for (String exception : exceptions) {
            if (exceptionSet.contains(exception)) continue;
            exceptionSet.add(exception);
            newExceptions.add(exception);
        }
        if (formalParameters != null) {
            parameterTypes = new String[formalParameters.size()];
            int i2 = 0;
            for (ASTNode node : formalParameters) {
                FormalParameter formalParameter = (FormalParameter)node;
                Expression parameterType = formalParameter.getParameterType();
                if (parameterType != null) {
                    String typeName = ((Identifier)parameterType).getName();
                    parameterTypes[i2++] = typeName;
                    continue;
                }
                if (formalParameter.getDefaultValue() != null && formalParameter.getDefaultValue() instanceof Scalar && !formalParameter.getDefaultValue().isNullExpression()) {
                    Scalar scalar = (Scalar)formalParameter.getDefaultValue();
                    IEvaluatedType simpleType = PHPSimpleTypes.fromString((String)Scalar.getType((int)scalar.getScalarType()));
                    if (simpleType == null) {
                        parameterTypes[i2++] = Scalar.getType((int)scalar.getScalarType());
                        continue;
                    }
                    parameterTypes[i2++] = simpleType.getTypeName();
                    continue;
                }
                parameterTypes[i2++] = formalParameter.getDefaultValue() != null && formalParameter.getDefaultValue() instanceof ArrayCreation ? PHPSimpleTypes.ARRAY.getTypeName() : UNKNOWN_TYPE;
            }
        }
        StringBuilder returnTypeBuffer2 = new StringBuilder();
        if (resolvedBinding != null) {
            if (retType == null && (returnTypes = resolvedBinding.getReturnType()) != null && returnTypes.length > 0) {
                List<ITypeBinding> returnTypesList = CodeGeneration.removeDuplicateTypes(returnTypes);
                for (ITypeBinding returnType2 : returnTypesList) {
                    if (returnType2.isUnknown()) {
                        returnTypeBuffer2.append(PHPSimpleTypes.NULL.getTypeName()).append('|');
                        continue;
                    }
                    if (returnType2.isAmbiguous()) {
                        returnTypeBuffer2.append("Ambiguous").append('|');
                        continue;
                    }
                    if (CodeGeneration.appendAllPossibleTypes(returnType2.getEvaluatedType(), returnTypeBuffer2)) continue;
                    returnTypeBuffer2.append(returnType2.getName()).append('|');
                }
                if (returnTypeBuffer2.length() > 0) {
                    retType = returnTypeBuffer2.substring(0, returnTypeBuffer2.length() - 1);
                }
            }
            if ((typeParametersTypes = resolvedBinding.getParameterTypes()) != null) {
                int i3 = 0;
                typeParameterNames = new String[typeParametersTypes.length];
                ITypeBinding[] iTypeBindingArray = typeParametersTypes;
                int n = typeParametersTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding type = iTypeBindingArray[n2];
                    typeParameterNames[i3++] = type.getName();
                    ++n2;
                }
            }
        }
        String[] paramNames = method.getParameterNames();
        if (formalParameters == null) {
            parameterTypes = new String[paramNames.length];
            i = 0;
            while (i < paramNames.length) {
                parameterTypes[i] = UNKNOWN_TYPE;
                ++i;
            }
        } else {
            i = 0;
            while (i < formalParameters.size()) {
                if (((FormalParameter)formalParameters.get(i)).isVariadic()) {
                    paramNames[i] = "..." + paramNames[i];
                }
                ++i;
            }
        }
        i = 0;
        while (i < paramNames.length) {
            if (parameterTypes != null && parameterTypes[i] != null) {
                paramNames[i] = String.valueOf(parameterTypes[i]) + " " + paramNames[i];
            }
            ++i;
        }
        IType declaringType = method.getDeclaringType();
        if (declaringType != null) {
            return StubUtility.getMethodComment(method.getScriptProject(), declaringType.getElementName(), method.getElementName(), paramNames, retType, typeParameterNames, overridden, false, lineDelimiter, newExceptions);
        }
        return StubUtility.getMethodComment(method.getScriptProject(), null, method.getElementName(), paramNames, retType, typeParameterNames, overridden, false, lineDelimiter, newExceptions);
    }

    public static Program generateProgram(IMember member, Program program) {
        ISourceModule source = member.getSourceModule();
        ASTParser parserForExpected = ASTParser.newParser((PHPVersion)ProjectOptions.getPHPVersion((IProject)source.getScriptProject().getProject()), (ISourceModule)source);
        try {
            parserForExpected.setSource(source);
            program = parserForExpected.createAST((IProgressMonitor)new NullProgressMonitor());
            program.recordModifications();
            program.setSourceModule(source);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return program;
    }

    private static List<ITypeBinding> removeDuplicateTypes(ITypeBinding[] returnTypes) {
        ArrayList<ITypeBinding> types = new ArrayList<ITypeBinding>();
        ITypeBinding[] iTypeBindingArray = returnTypes;
        int n = returnTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding type = iTypeBindingArray[n2];
            if (!types.contains(type)) {
                types.add(type);
            }
            ++n2;
        }
        return types;
    }

    private static boolean appendAllPossibleTypes(IEvaluatedType type, StringBuilder buffer) {
        ArrayList<String> foundTypes = new ArrayList<String>();
        if (CodeGeneration.findAllPossibleTypes(type, foundTypes, 0, true)) {
            for (String foundType : foundTypes) {
                buffer.append(foundType).append('|');
            }
            return true;
        }
        return false;
    }

    private static boolean findAllPossibleTypes(IEvaluatedType type, List<String> foundTypes, int level, boolean firstCall) {
        List allPossibleTypes;
        if (type instanceof AmbiguousType) {
            IEvaluatedType[] allPossibleTypes2;
            IEvaluatedType[] iEvaluatedTypeArray = allPossibleTypes2 = ((AmbiguousType)type).getPossibleTypes();
            int n = allPossibleTypes2.length;
            int n2 = 0;
            while (n2 < n) {
                IEvaluatedType possibleType = iEvaluatedTypeArray[n2];
                CodeGeneration.findAllPossibleTypes(possibleType, foundTypes, level, false);
                ++n2;
            }
            return true;
        }
        if (type instanceof MultiTypeType && !(allPossibleTypes = ((MultiTypeType)type).getTypes()).isEmpty()) {
            for (IEvaluatedType possibleType : allPossibleTypes) {
                CodeGeneration.findAllPossibleTypes(possibleType, foundTypes, level + 1, false);
            }
            return true;
        }
        if (!firstCall || type instanceof MultiTypeType) {
            StringBuilder buffer = new StringBuilder();
            if (type instanceof MultiTypeType) {
                buffer.append(PHPSimpleTypes.ARRAY.getTypeName());
            } else {
                buffer.append(type.getTypeName());
            }
            int i = 1;
            while (i <= level) {
                buffer.append("[]");
                ++i;
            }
            String foundType = buffer.toString();
            if (!foundTypes.contains(foundType)) {
                foundTypes.add(foundType);
            }
            return true;
        }
        return false;
    }

    public static String getMethodBodyContent(IScriptProject sp, String declaringTypeName, String methodName, boolean isConstructor, String bodyStatement, String lineDelimiter) throws CoreException {
        return StubUtility.getMethodBodyContent(isConstructor, sp, declaringTypeName, methodName, bodyStatement, lineDelimiter);
    }

    public static String getGetterMethodBodyContent(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String lineDelimiter) throws CoreException {
        return StubUtility.getGetterMethodBodyContent(sp, declaringTypeName, methodName, fieldName, lineDelimiter);
    }

    public static String getSetterMethodBodyContent(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String paramName, String lineDelimiter) throws CoreException {
        return StubUtility.getSetterMethodBodyContent(sp, declaringTypeName, methodName, fieldName, paramName, lineDelimiter);
    }

    public static String getGetterComment(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        return StubUtility.getGetterComment(sp, declaringTypeName, methodName, fieldName, fieldType, bareFieldName, lineDelimiter);
    }

    public static String getSetterComment(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String fieldType, String paramName, String bareFieldName, String lineDelimiter) throws CoreException {
        return StubUtility.getSetterComment(sp, declaringTypeName, methodName, fieldName, fieldType, paramName, bareFieldName, lineDelimiter);
    }
}

