/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.packages;

import java.net.ProxySelector;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.util.EntityUtils;
import org.eclipse.php.composer.api.packages.AbstractDownloader;
import org.eclipse.php.composer.api.packages.DownloadListenerInterface;

public class AsyncDownloader
extends AbstractDownloader {
    public static final int TIMEOUT = 30;
    private int lastSlot = 1;
    private Log log = LogFactory.getLog(AsyncDownloader.class);
    private PoolingHttpClientConnectionManager connectionManager;
    private Map<Integer, Connection> connections = new HashMap<Integer, Connection>();

    public AsyncDownloader() {
    }

    public AsyncDownloader(String url) {
        super(url);
    }

    @Override
    protected void init() {
        super.init();
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory ssf = new SSLConnectionSocketFactory(builder.build());
            Registry r = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)ssf).build();
            this.connectionManager = new PoolingHttpClientConnectionManager(r);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)"Exception during init", (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.log.error((Object)"Exception during init", (Throwable)e);
        }
        catch (KeyStoreException e) {
            this.log.error((Object)"Exception during init", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int download() {
        try {
            slot = ++this.lastSlot;
            connection = new Connection(this.url);
            connection.start();
            this.connections.put(slot, connection);
            return slot;
        }
        catch (Exception e) {
            ** for (listener : this.listeners)
        }
lbl-1000:
        // 1 sources

        {
            listener.errorOccured(e);
            continue;
        }
lbl12:
        // 1 sources

        return -1;
    }

    public void abort() {
        this.abort(this.lastSlot);
    }

    public void abort(int slot) {
        try {
            Connection conn = this.connections.get(slot);
            if (conn != null) {
                conn.abort();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortListeners(String url) {
        AsyncDownloader asyncDownloader = this;
        synchronized (asyncDownloader) {
            for (DownloadListenerInterface listener : this.listeners) {
                listener.aborted(url);
            }
        }
    }

    public void shutdown() {
        if (this.connectionManager != null) {
            for (Connection conn : this.connections.values()) {
                if (conn == null) continue;
                conn.abort();
            }
            this.connectionManager.shutdown();
        }
    }

    private class Connection
    implements Runnable {
        private String url;
        private Thread thread;

        public Connection(String url) {
            this.url = url;
        }

        public void closed() {
            AsyncDownloader.this.abortListeners(this.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                this.closed();
                return;
            }
            try {
                URI uri = URI.create(this.url);
                HttpGet httpGet = new HttpGet(uri);
                httpGet.addHeader("Accept", "*/*");
                httpGet.addHeader("User-Agent", this.getClass().getName());
                httpGet.addHeader("Host", uri.getHost());
                HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                SystemDefaultRoutePlanner planner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
                HttpClientContext context = HttpClientContext.create();
                HttpRoute route = planner.determineRoute(host, (HttpRequest)httpGet, (HttpContext)context);
                ConnectionRequest connRequest = AsyncDownloader.this.connectionManager.requestConnection(route, null);
                HttpClientConnection conn = connRequest.get(30L, TimeUnit.SECONDS);
                try {
                    if (Thread.currentThread().isInterrupted()) {
                        this.closed();
                        return;
                    }
                    AsyncDownloader.this.connectionManager.connect(conn, route, 1000, (HttpContext)context);
                    if (Thread.currentThread().isInterrupted()) {
                        this.closed();
                        return;
                    }
                    AsyncDownloader.this.connectionManager.routeComplete(conn, route, (HttpContext)context);
                    if (Thread.currentThread().isInterrupted()) {
                        this.closed();
                        return;
                    }
                    HttpRequestExecutor exeRequest = new HttpRequestExecutor();
                    context.setTargetHost(host);
                    HttpResponse response = exeRequest.execute((HttpRequest)httpGet, conn, (HttpContext)context);
                    if (response.getStatusLine().getStatusCode() >= 300) {
                        throw new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
                    }
                    HttpEntity entity = response.getEntity();
                    if (Thread.currentThread().isInterrupted()) {
                        this.closed();
                        return;
                    }
                    if (entity == null) {
                        throw new ClientProtocolException("Response contains no content");
                    }
                    try {
                        AsyncDownloader asyncDownloader = AsyncDownloader.this;
                        synchronized (asyncDownloader) {
                            Iterator iterator = AsyncDownloader.this.listeners.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    return;
                                }
                                DownloadListenerInterface listener = (DownloadListenerInterface)iterator.next();
                                try {
                                    if (Thread.currentThread().isInterrupted()) {
                                        this.closed();
                                        return;
                                    }
                                }
                                catch (Exception e) {
                                    listener.errorOccured(e);
                                    continue;
                                }
                                {
                                    listener.dataReceived(response.getEntity().getContent(), httpGet.getURI().toString());
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)entity);
                    }
                }
                finally {
                    if (conn != null) {
                        AsyncDownloader.this.connectionManager.releaseConnection(conn, null, 1L, TimeUnit.SECONDS);
                    }
                }
            }
            catch (Exception ex) {
                AsyncDownloader asyncDownloader = AsyncDownloader.this;
                synchronized (asyncDownloader) {
                    for (DownloadListenerInterface listener : AsyncDownloader.this.listeners) {
                        listener.errorOccured(ex);
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            Connection connection = this;
            synchronized (connection) {
                if (this.thread != null && this.thread.isAlive()) {
                    this.thread.interrupt();
                }
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }
}

