/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.ReturnType;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class FunctionDeclaration
extends Statement {
    private boolean isReference;
    private Identifier name;
    private final ASTNode.NodeList<FormalParameter> formalParameters = new ASTNode.NodeList(FORMAL_PARAMETERS_PROPERTY);
    private Block body;
    private ReturnType returnType;
    public static final SimplePropertyDescriptor IS_REFERENCE_PROPERTY = new SimplePropertyDescriptor(FunctionDeclaration.class, "isReference", Boolean.class, false);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(FunctionDeclaration.class, "name", Identifier.class, true, false);
    public static final ChildListPropertyDescriptor FORMAL_PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(FunctionDeclaration.class, "formalParameters", FormalParameter.class, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(FunctionDeclaration.class, "body", Block.class, false, true);
    public static final ChildPropertyDescriptor RETURN_TYPE_PROPERTY = new ChildPropertyDescriptor(FunctionDeclaration.class, "returnType", ReturnType.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(4);
        propertyList.add(IS_REFERENCE_PROPERTY);
        propertyList.add(NAME_PROPERTY);
        propertyList.add(FORMAL_PARAMETERS_PROPERTY);
        propertyList.add(BODY_PROPERTY);
        propertyList.add(RETURN_TYPE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public FunctionDeclaration(int start, int end, AST ast, Identifier functionName, List<FormalParameter> formalParameters, Block body, boolean isReference) {
        this(start, end, ast, functionName, formalParameters, body, isReference, null);
    }

    public FunctionDeclaration(int start, int end, AST ast, Identifier functionName, List<FormalParameter> formalParameters, Block body, boolean isReference, Identifier returnType) {
        super(start, end, ast);
        if (functionName == null || formalParameters == null) {
            throw new IllegalArgumentException();
        }
        this.setIsReference(isReference);
        this.setFunctionName(functionName);
        Iterator<FormalParameter> iterator = formalParameters.iterator();
        while (iterator.hasNext()) {
            FormalParameter obj;
            FormalParameter formalParameter = obj = iterator.next();
            this.formalParameters.add(formalParameter);
        }
        if (returnType != null) {
            this.setReturnType(returnType);
        }
        if (body != null) {
            this.setBody(body);
        }
    }

    public FunctionDeclaration(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.name.accept(visitor);
        for (ASTNode aSTNode : this.formalParameters) {
            aSTNode.accept(visitor);
        }
        if (this.returnType != null) {
            this.returnType.accept(visitor);
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.name.traverseTopDown(visitor);
        for (ASTNode aSTNode : this.formalParameters) {
            aSTNode.traverseTopDown(visitor);
        }
        if (this.returnType != null) {
            this.returnType.traverseTopDown(visitor);
        }
        if (this.body != null) {
            this.body.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.name.traverseBottomUp(visitor);
        for (ASTNode aSTNode : this.formalParameters) {
            aSTNode.traverseBottomUp(visitor);
        }
        if (this.returnType != null) {
            this.returnType.traverseBottomUp(visitor);
        }
        if (this.body != null) {
            this.body.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FunctionDeclaration");
        this.appendInterval(buffer);
        buffer.append(" isReference='").append(this.isReference).append("'>\n");
        buffer.append("\t").append(tab).append("<FunctionName>\n");
        this.name.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</FunctionName>\n");
        buffer.append("\t").append(tab).append("<FormalParameters>\n");
        for (ASTNode aSTNode : this.formalParameters) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</FormalParameters>\n");
        if (this.getReturnType() != null) {
            buffer.append("\t").append(tab).append("<ReturnType>\n");
            this.getReturnType().toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            buffer.append("\t").append(tab).append("</ReturnType>\n");
        }
        buffer.append("\t").append(tab).append("<FunctionBody>\n");
        if (this.body != null) {
            this.body.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</FunctionBody>\n");
        buffer.append(tab).append("</FunctionDeclaration>");
    }

    @Override
    public int getType() {
        return 29;
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        Block oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public List<FormalParameter> formalParameters() {
        return this.formalParameters;
    }

    public Identifier getFunctionName() {
        return this.name;
    }

    public void setFunctionName(Identifier name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Identifier oldChild = this.name;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this.name = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    public boolean isReference() {
        return this.isReference;
    }

    public final void setIsReference(boolean value) {
        this.preValueChange(IS_REFERENCE_PROPERTY);
        this.isReference = value;
        this.postValueChange(IS_REFERENCE_PROPERTY);
    }

    public Identifier getReturnType() {
        if (this.returnType != null) {
            return this.returnType.getName();
        }
        return null;
    }

    public void setReturnType(Identifier returnType) {
        ReturnType oldChild = this.returnType;
        ReturnType newChild = null;
        if (returnType != null) {
            newChild = new ReturnType(returnType);
        }
        this.preReplaceChild(oldChild, newChild, RETURN_TYPE_PROPERTY);
        this.returnType = newChild;
        this.postReplaceChild(oldChild, newChild, RETURN_TYPE_PROPERTY);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == IS_REFERENCE_PROPERTY) {
            if (get) {
                return this.isReference();
            }
            this.setIsReference(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getFunctionName();
            }
            this.setFunctionName((Identifier)child);
            return null;
        }
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        if (property == RETURN_TYPE_PROPERTY) {
            if (get) {
                return this.getReturnType();
            }
            this.setReturnType((Identifier)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == FORMAL_PARAMETERS_PROPERTY) {
            return this.formalParameters();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Block body = ASTNode.copySubtree(target, this.getBody());
        Identifier function = ASTNode.copySubtree(target, this.getFunctionName());
        List<FormalParameter> formalParams = ASTNode.copySubtrees(target, this.formalParameters());
        boolean isRef = this.isReference();
        Identifier returnType = ASTNode.copySubtree(target, this.getReturnType());
        return new FunctionDeclaration(this.getStart(), this.getEnd(), target, function, formalParams, body, isRef, returnType);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IFunctionBinding resolveFunctionBinding() {
        return this.ast.getBindingResolver().resolveFunction(this);
    }
}

