/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.parser.regions;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.parser.AbstractPHPLexer;
import org.eclipse.php.internal.core.documentModel.parser.PHPLexerFactory;
import org.eclipse.php.internal.core.documentModel.parser.Scanner;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.PHPTokenContainer;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.Logger;

public class PHPScriptRegion
extends ForeignRegion
implements IPHPScriptRegion {
    private static final String PHP_SCRIPT = "PHP Script";
    private static final ITextRegion[] EMPTY_REGION = new ITextRegion[0];
    private PHPTokenContainer tokensContainer = new PHPTokenContainer();
    private IProject project;
    PHPVersion currentPhpVersion;
    private int updatedTokensStart = -1;
    private int updatedTokensEnd = -1;
    private int inScriptingState;
    private int[] phpQuotesStates;
    private int[] heredocStates;
    protected boolean isFullReparsed;

    @Override
    public int getUpdatedTokensStart() {
        if (this.updatedTokensStart == -1) {
            return 0;
        }
        return this.updatedTokensStart;
    }

    @Override
    public int getUpdatedTokensLength() {
        return this.updatedTokensEnd - this.updatedTokensStart;
    }

    public PHPScriptRegion(String newContext, int startOffset, @Nullable IProject project, @NonNull AbstractPHPLexer phpLexer) {
        super(newContext, startOffset, 0, 0, PHP_SCRIPT);
        this.project = project;
        this.currentPhpVersion = ProjectOptions.getPHPVersion(this.project);
        this.inScriptingState = phpLexer.getInScriptingState();
        this.phpQuotesStates = phpLexer.getPHPQuotesStates();
        this.heredocStates = phpLexer.getHeredocStates();
        this.completeReparse(phpLexer);
    }

    @Override
    @NonNull
    public final String getPHPTokenType(int relativeOffset) throws BadLocationException {
        ITextRegion tokenForOffset = this.getPHPToken(relativeOffset);
        return tokenForOffset.getType();
    }

    @Override
    @NonNull
    public final ITextRegion getPHPToken(int relativeOffset) throws BadLocationException {
        return this.tokensContainer.getToken(relativeOffset);
    }

    @Override
    @NonNull
    public final ITextRegion[] getPHPTokens(int relativeOffset, int length) throws BadLocationException {
        return this.tokensContainer.getTokens(relativeOffset, length);
    }

    @Override
    @NonNull
    public ITextRegion[] getUpdatedPHPTokens() throws BadLocationException {
        if (this.updatedTokensStart == -1) {
            return EMPTY_REGION;
        }
        return this.tokensContainer.getTokens(this.updatedTokensStart, this.updatedTokensEnd - this.updatedTokensStart);
    }

    @Override
    @NonNull
    public String getPartition(int relativeOffset) throws BadLocationException {
        return this.tokensContainer.getPartitionType(relativeOffset);
    }

    protected boolean isHeredocState(int relativeOffset) throws BadLocationException {
        String type = this.getPHPTokenType(relativeOffset);
        if (type == "PHP_HEREDOC_START_TAG" || type == "PHP_HEREDOC_CLOSE_TAG" || type == "PHP_NOWDOC_START_TAG" || type == "PHP_NOWDOC_CLOSE_TAG") {
            return true;
        }
        Scanner.LexerState lexState = this.tokensContainer.getState(relativeOffset);
        if (lexState == null) {
            return false;
        }
        int[] nArray = this.heredocStates;
        int n = this.heredocStates.length;
        int n2 = 0;
        while (n2 < n) {
            int state = nArray[n2];
            if (lexState.isSubstateOf(state)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isPHPQuotesState(int relativeOffset) throws BadLocationException {
        String type = this.getPHPTokenType(relativeOffset);
        if (PHPPartitionTypes.isPHPQuotesState(type)) {
            return true;
        }
        Scanner.LexerState lexState = this.tokensContainer.getState(relativeOffset);
        if (lexState == null) {
            return false;
        }
        int[] nArray = this.phpQuotesStates;
        int n = this.phpQuotesStates.length;
        int n2 = 0;
        while (n2 < n) {
            int state = nArray[n2];
            if (lexState.isSubstateOf(state)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isFullReparsed() {
        return this.isFullReparsed;
    }

    @Override
    public void setFullReparsed(boolean isFullReparse) {
        this.isFullReparsed = isFullReparse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion flatnode, String changes, int requestStart, int lengthToReplace) {
        this.isFullReparsed = true;
        this.updatedTokensStart = -1;
        this.updatedTokensEnd = -1;
        try {
            offset = requestStart - flatnode.getStartOffset() - this.getStart();
            if (offset < 4) {
                return null;
            }
            deletedText = lengthToReplace == 0 ? "" : flatnode.getParentDocument().get(requestStart, lengthToReplace);
            length = changes.length();
            if (this.startQuoted(deletedText) != false) return null;
            if (this.startQuoted(changes)) {
                return null;
            }
            var9_10 = this.tokensContainer;
            synchronized (var9_10) {
                try {
                    if (ProjectOptions.getPHPVersion(this.project) != this.currentPhpVersion) {
                        return null;
                    }
                    tokenStart = this.tokensContainer.getToken(offset == 0 ? 0 : offset - 1);
                    tokenEnd = this.tokensContainer.getToken(offset + lengthToReplace);
                    while (true) {
                        if (!"UNKNOWN_TOKEN".equals(tokenStart.getType()) || tokenStart.getStart() <= 0) {
                            newTokenOffset = tokenStart.getStart();
                            if (!this.isHeredocState(newTokenOffset)) break;
                            return null;
                        }
                        tokenStart = this.tokensContainer.getToken(tokenStart.getStart() - 1);
                    }
                    if (this.isMaybeStartingNewHeredocSection(tokenStart)) {
                        return null;
                    }
                    while (true) {
                        if (!"UNKNOWN_TOKEN".equals(tokenEnd.getType()) || this.tokensContainer.getLastToken() == tokenEnd) {
                            shouldDeprecatedKeyword = false;
                            previousIndex = this.tokensContainer.phpTokens.indexOf(tokenStart) - 1;
                            if (previousIndex >= 0) {
                                previousRegion = (ITextRegion)this.tokensContainer.phpTokens.get(previousIndex);
                                if (PHPTokenContainer.deprecatedKeywordAfter(previousRegion.getType())) {
                                    shouldDeprecatedKeyword = true;
                                }
                                if (PHPPartitionTypes.isPHPMultiLineCommentRegion(tokenStart.getType()) && tokenStart.getLength() == 1 && PHPPartitionTypes.isPHPMultiLineCommentStartRegion(previousRegion.getType())) {
                                    requestStart = previousRegion.getStart();
                                }
                            }
                            startState = this.tokensContainer.getState(newTokenOffset);
                            endState = this.tokensContainer.getState(tokenEnd.getEnd());
                            if (PHPScriptRegion.$assertionsDisabled) break;
                            if (startState == null) throw new AssertionError();
                            if (endState == null) {
                                throw new AssertionError();
                            }
                            break;
                        }
                        tokenEnd = this.tokensContainer.getToken(tokenEnd.getEnd());
                    }
                    newContainer = new PHPTokenContainer();
                    phpLexer = this.getPHPLexer(new DocumentReader(flatnode, changes, requestStart, lengthToReplace, newTokenOffset), startState, this.currentPhpVersion);
                    state = startState;
                    try {
                        yylex = phpLexer.getNextToken();
                        if (shouldDeprecatedKeyword && PHPTokenContainer.isKeyword(yylex)) {
                            yylex = "PHP_LABEL";
                        }
                        toOffset = offset + length;
                        while (true) {
                            if (yylex == null || newTokenOffset > toOffset || yylex == "PHP_CLOSETAG") {
                                if (yylex == "WHITESPACE") {
                                    yylength = phpLexer.getLength();
                                    newContainer.adjustWhitespace(yylex, newTokenOffset, yylength, yylength, state);
                                }
                                break;
                            }
                            yylength = phpLexer.getLength();
                            newContainer.addLast(yylex, newTokenOffset, yylength, yylength, state);
                            newTokenOffset += yylength;
                            state = phpLexer.createLexicalStateMemento();
                            yylex = phpLexer.getNextToken();
                        }
                    }
                    catch (IOException e) {
                        Logger.logException((Throwable)e);
                    }
                    if (newContainer.isEmpty()) {
                        return null;
                    }
                    size = length - lengthToReplace;
                    end = newContainer.getLastToken().getEnd();
                    if (state != null) {
                        if (state.equals(endState) == false) return null;
                    }
                    if (tokenEnd.getEnd() + size != end) {
                        return null;
                    }
                    oldIterator = this.tokensContainer.removeTokensSubList(tokenStart, tokenEnd);
                    newTokens = newContainer.getPHPTokens();
                    i = 0;
                    while (i < newTokens.length) {
                        oldIterator.add((ContextRegion)newTokens[i]);
                        ++i;
                    }
                    ** GOTO lbl89
                }
                catch (Throwable v0) {
                    throw v0;
lbl89:
                    // 1 sources

                    if (true) ** GOTO lbl96
                }
            }
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
            return null;
        }
        {
            do {
                adjust = (ITextRegion)oldIterator.next();
                adjust.adjustStart(size);
lbl96:
                // 2 sources

            } while (oldIterator.hasNext());
            this.tokensContainer.updateStateChanges(newContainer, tokenStart.getStart(), end);
            this.updatedTokensStart = tokenStart.getStart();
            this.updatedTokensEnd = end;
            this.isFullReparsed = false;
            return super.updateRegion(requester, flatnode, changes, requestStart, lengthToReplace);
        }
    }

    @Override
    public synchronized void completeReparse(IDocument doc, int start, int length) {
        this.completeReparse(doc, start, length, this.project);
    }

    @Override
    public synchronized void completeReparse(IDocument doc, int start, int length, @Nullable IProject project) {
        this.project = project;
        this.currentPhpVersion = ProjectOptions.getPHPVersion(this.project);
        AbstractPHPLexer phpLexer = this.getPHPLexer(new BlockDocumentReader(doc, start, length), null, this.currentPhpVersion);
        this.inScriptingState = phpLexer.getInScriptingState();
        this.phpQuotesStates = phpLexer.getPHPQuotesStates();
        this.heredocStates = phpLexer.getHeredocStates();
        this.completeReparse(phpLexer);
    }

    public void equatePositions(ITextRegion region) {
        super.equatePositions(region);
        if (region instanceof PHPScriptRegion) {
            PHPScriptRegion sRegion = (PHPScriptRegion)region;
            this.tokensContainer = (PHPTokenContainer)sRegion.tokensContainer.clone();
            this.project = sRegion.project;
            this.currentPhpVersion = sRegion.currentPhpVersion;
            this.updatedTokensStart = sRegion.updatedTokensStart;
            this.updatedTokensEnd = sRegion.updatedTokensEnd;
            this.inScriptingState = sRegion.inScriptingState;
            this.phpQuotesStates = sRegion.phpQuotesStates;
            this.heredocStates = sRegion.heredocStates;
            this.isFullReparsed = sRegion.isFullReparsed;
        }
    }

    private final synchronized boolean isMaybeStartingNewHeredocSection(ITextRegion tokenStart) {
        block7: {
            if (tokenStart.getType() == "PHP_TOKEN") {
                try {
                    ITextRegion token = this.tokensContainer.getToken(tokenStart.getStart() - 1);
                    return token.getType() == "PHP_OPERATOR" && token.getLength() == 2;
                }
                catch (BadLocationException badLocationException) {
                    assert (false);
                    break block7;
                }
            }
            if (tokenStart.getType() == "PHP_LABEL") {
                try {
                    ITextRegion token = this.tokensContainer.getToken(tokenStart.getStart() - 1);
                    token = this.tokensContainer.getToken(token.getStart() - 1);
                    return token.getType() == "PHP_OPERATOR" && token.getLength() == 2;
                }
                catch (BadLocationException badLocationException) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
        }
        return false;
    }

    private boolean startQuoted(String text) {
        int length = text.length();
        if (length == 0) {
            return false;
        }
        boolean isOdd = false;
        int index = 0;
        while (index < length) {
            char charAt = text.charAt(index);
            if (charAt == '\"' || charAt == '\'') {
                isOdd = !isOdd;
            }
            ++index;
        }
        return isOdd;
    }

    private void completeReparse(@NonNull AbstractPHPLexer lexer) {
        this.setPHPTokens(lexer);
    }

    private AbstractPHPLexer getPHPLexer(Reader stream, Scanner.LexerState startState, PHPVersion phpVersion) {
        AbstractPHPLexer lexer = PHPLexerFactory.createLexer(stream, phpVersion);
        lexer.initialize(this.inScriptingState);
        if (startState != null) {
            startState.restoreState(lexer);
        }
        lexer.setAspTags(ProjectOptions.isSupportingASPTags(this.project));
        return lexer;
    }

    private synchronized void setPHPTokens(AbstractPHPLexer lexer) {
        this.setLength(0);
        this.setTextLength(0);
        this.isFullReparsed = true;
        assert (lexer != null);
        int start = 0;
        this.tokensContainer.getModelForCreation();
        this.tokensContainer.reset();
        try {
            try {
                Scanner.LexerState state = lexer.createLexicalStateMemento();
                String yylex = lexer.getNextToken();
                int yylength = 0;
                while (yylex != null && yylex != "PHP_CLOSETAG") {
                    yylength = lexer.getLength();
                    this.tokensContainer.addLast(yylex, start, yylength, yylength, state);
                    start += yylength;
                    state = lexer.createLexicalStateMemento();
                    yylex = lexer.getNextToken();
                }
                this.adjustLength(start);
                this.adjustTextLength(start);
            }
            catch (IOException e) {
                Logger.logException((Throwable)e);
                this.tokensContainer.releaseModelFromCreation();
            }
        }
        finally {
            this.tokensContainer.releaseModelFromCreation();
        }
    }

    public static class BlockDocumentReader
    extends Reader {
        private static final String BAD_LOCATION_ERROR = "Bad location error ";
        private final IDocument parent;
        private int startPhpRegion;
        private final int endPhpRegion;

        public BlockDocumentReader(IDocument parent, int startPhpRegion, int length) {
            this.parent = parent;
            this.startPhpRegion = startPhpRegion;
            this.endPhpRegion = startPhpRegion + length;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.startPhpRegion < this.endPhpRegion ? (int)this.parent.getChar(this.startPhpRegion++) : -1;
            }
            catch (BadLocationException badLocationException) {
                throw new IOException(BAD_LOCATION_ERROR + this.startPhpRegion);
            }
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (char)c;
            int i = 1;
            try {
                while (i < len) {
                    c = this.read();
                    if (c != -1) {
                        b[off + i] = (char)c;
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
            return i;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class DocumentReader
    extends Reader {
        private static final String BAD_LOCATION_ERROR = "Bad location error ";
        private final IStructuredDocument parent;
        private final int startPhpRegion;
        private final int endPhpRegion;
        private final int changeLength;
        private final String change;
        private final int requestStart;
        private final int lengthToReplace;
        private int index;
        private int internalIndex = 0;

        public DocumentReader(IStructuredDocumentRegion flatnode, String change, int requestStart, int lengthToReplace, int newTokenOffset) {
            this.parent = flatnode.getParentDocument();
            this.startPhpRegion = flatnode.getStart() + PHPScriptRegion.this.getStart();
            this.endPhpRegion = this.startPhpRegion + PHPScriptRegion.this.getLength();
            this.changeLength = change.length();
            this.index = this.startPhpRegion + newTokenOffset;
            this.change = change;
            this.requestStart = requestStart;
            this.lengthToReplace = lengthToReplace;
        }

        @Override
        public int read() throws IOException {
            try {
                if (this.index < this.requestStart) {
                    return this.parent.getChar(this.index++);
                }
                if (this.internalIndex < this.changeLength) {
                    return this.change.charAt(this.internalIndex++);
                }
                if (this.index < this.requestStart + this.lengthToReplace) {
                    this.index = this.requestStart + this.lengthToReplace;
                }
                return this.index < this.endPhpRegion ? (int)this.parent.getChar(this.index++) : -1;
            }
            catch (BadLocationException badLocationException) {
                throw new IOException(BAD_LOCATION_ERROR);
            }
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            int n = len = len > 80 ? 80 : len;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (char)c;
            int i = 1;
            try {
                while (i < len) {
                    c = this.read();
                    if (c != -1) {
                        b[off + i] = (char)c;
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
            return i;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

