/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunch;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;

public class PHPRemoteLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate2 {
    private ILaunch launch;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean runWithDebug = configuration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        this.launch = launch;
        if (mode.equals("run") && !runWithDebug) {
            return;
        }
        IProject proj = null;
        String fileName = configuration.getAttribute("file_name", null);
        if (fileName != null) {
            Path filePath = new Path(fileName);
            try {
                proj = ResourcesPlugin.getWorkspace().getRoot().getProject(filePath.segment(0));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        if (proj != null) {
            String project = proj.getFullPath().toString();
            wc.setAttribute("org.eclipse.php.debug.core.PHP_Project", project);
        }
        wc.doSave();
        String URL2 = configuration.getAttribute("base_url", "");
        if (mode.equals("debug") || runWithDebug) {
            boolean isStopAtFirstLine = wc.getAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine(proj));
            int requestPort = PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
            launch.setAttribute("port", Integer.toString(requestPort));
            launch.setAttribute("webServerDebugger", Boolean.toString(true));
            launch.setAttribute("firstLineBreakpoint", Boolean.toString(isStopAtFirstLine));
            launch.setAttribute("uriginalURL", URL2);
        }
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PHPLaunch(configuration, mode, null);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    public void terminated() {
        DebugEvent event = null;
        if (this.launch.getDebugTarget() == null) {
            DummyDebugTarget dummyDebugTarget = new DummyDebugTarget(this.launch);
            event = new DebugEvent((Object)dummyDebugTarget, 8);
            if (this.launch != null) {
                this.launch.addDebugTarget((IDebugTarget)dummyDebugTarget);
                IDebugEventSetListener launchListener = (IDebugEventSetListener)this.launch;
                launchListener.handleDebugEvents(new DebugEvent[]{event});
            }
        }
        event = new DebugEvent((Object)this, 8);
        this.fireEvent(event);
    }

    public void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    private class DummyDebugTarget
    implements IDebugTarget {
        private ILaunch launch;

        public DummyDebugTarget(ILaunch launch) {
            this.launch = launch;
        }

        public String getName() throws DebugException {
            return "Session Terminated";
        }

        public IProcess getProcess() {
            return null;
        }

        public IThread[] getThreads() throws DebugException {
            return null;
        }

        public boolean hasThreads() throws DebugException {
            return false;
        }

        public boolean supportsBreakpoint(IBreakpoint breakpoint) {
            return false;
        }

        public IDebugTarget getDebugTarget() {
            return this;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        public String getModelIdentifier() {
            return "";
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean canTerminate() {
            return true;
        }

        public boolean isTerminated() {
            return true;
        }

        public void terminate() throws DebugException {
        }

        public boolean canResume() {
            return false;
        }

        public boolean canSuspend() {
            return false;
        }

        public boolean isSuspended() {
            return false;
        }

        public void resume() throws DebugException {
        }

        public void suspend() throws DebugException {
        }

        public void breakpointAdded(IBreakpoint breakpoint) {
        }

        public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        }

        public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        }

        public boolean canDisconnect() {
            return false;
        }

        public void disconnect() throws DebugException {
        }

        public boolean isDisconnected() {
            return false;
        }

        public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
            return null;
        }

        public boolean supportsStorageRetrieval() {
            return false;
        }
    }
}

