/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;

public class PHPStackFrame
extends PHPDebugElement
implements IStackFrame {
    private static final Pattern LAMBDA_FUNC_PATTERN = Pattern.compile("(.*)\\((\\d+)\\) : runtime-created function");
    private PHPThread fThread;
    private String fFunctionName;
    private String fFileName;
    private String fResolvedFileName;
    private int fLineNumber;
    private int fDepth;
    private Expression[] fLocalVariables;
    private PHPVariableContainer fCurrentVariables;
    private PHPVariableContainer fPreviousVariables;

    public PHPStackFrame(IThread thread, String fileName, String resolvedFileName, String funcName, int lineNumber, int depth, Expression[] localVariables) {
        super((PHPDebugTarget)thread.getDebugTarget());
        this.baseInit(thread, fileName, resolvedFileName, funcName, lineNumber, depth, localVariables);
    }

    private void baseInit(IThread thread, String fileName, String resolvedFileName, String funcName, int lineNumber, int depth, Expression[] localVariables) {
        Matcher matcher = LAMBDA_FUNC_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            fileName = matcher.group(1);
            lineNumber = Integer.parseInt(matcher.group(2));
        }
        this.fFunctionName = funcName;
        this.fFileName = fileName;
        this.fResolvedFileName = resolvedFileName;
        this.fLineNumber = lineNumber;
        this.fDepth = depth;
        this.fThread = (PHPThread)thread;
        this.fLocalVariables = localVariables;
    }

    protected void update(int lineNumber, Expression[] localVariables) throws DebugException {
        this.fLineNumber = lineNumber;
        this.fPreviousVariables = this.fCurrentVariables;
        this.fCurrentVariables = null;
        this.fLocalVariables = localVariables;
    }

    protected IVariable merge(IVariable variable) {
        if (this.fPreviousVariables == null) {
            return variable;
        }
        if (!(variable instanceof PHPVariable)) {
            return variable;
        }
        PHPVariable incoming = (PHPVariable)variable;
        if (incoming.getFullName().isEmpty()) {
            return incoming;
        }
        IVariable[] iVariableArray = this.fPreviousVariables.locals;
        int n = this.fPreviousVariables.locals.length;
        int n2 = 0;
        while (n2 < n) {
            PHPVariable previous;
            IVariable stored = iVariableArray[n2];
            if (stored instanceof PHPVariable && (previous = (PHPVariable)stored).getFullName().equals(incoming.getFullName())) {
                ((PHPVariable)stored).update(incoming.getExpression());
                return stored;
            }
            ++n2;
        }
        return variable;
    }

    protected int getDepth() {
        return this.fDepth;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        Expression[] localVariables = ExpressionValue.sort(this.fLocalVariables);
        if (this.fCurrentVariables == null) {
            this.fCurrentVariables = new PHPVariableContainer();
            this.fCurrentVariables.locals = new PHPVariable[localVariables.length];
            int i = 0;
            while (i < localVariables.length) {
                PHPVariable incoming = new PHPVariable((PHPDebugTarget)this.fThread.getDebugTarget(), localVariables[i]);
                this.fCurrentVariables.locals[i] = this.merge(incoming);
                ++i;
            }
        }
        return this.fCurrentVariables.locals;
    }

    public synchronized IVariable findVariable(String varName) throws DebugException {
        if (this.fCurrentVariables == null) {
            this.getVariables();
        }
        if (this.fCurrentVariables != null) {
            return this.fCurrentVariables.findVariable(varName);
        }
        return null;
    }

    public boolean hasVariables() throws DebugException {
        return ((PHPDebugTarget)this.getDebugTarget()).getVariables(this).length > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.fLineNumber;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.fFunctionName;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public int checkLineNumber() throws DebugException {
        return this.fLineNumber;
    }

    public String getSourceName() {
        return this.fResolvedFileName;
    }

    public String getAbsoluteFileName() {
        return this.fFileName;
    }

    public Expression[] getStackVariables() {
        return this.fLocalVariables;
    }

    public void setStackVariables(Expression[] variables) {
        this.fLocalVariables = variables;
    }

    private static class PHPVariableContainer {
        IVariable[] locals = null;

        private PHPVariableContainer() {
        }

        public IVariable findVariable(String varName) throws DebugException {
            IVariable variable;
            if (this.locals != null && (variable = PHPVariableContainer.findVariable(varName, this.locals)) != null) {
                return variable;
            }
            return null;
        }

        private static IVariable findVariable(String varName, IVariable[] vars) throws DebugException {
            int i = 0;
            while (i < vars.length) {
                IVariable var = vars[i];
                if (var.getName().equals(varName)) {
                    return var;
                }
                ++i;
            }
            return null;
        }
    }
}

