/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageSection;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.model.connection.PHPUnitConnectionListener;
import org.eclipse.php.phpunit.model.connection.PHPUnitMessageParser;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitElementManager;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestException;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestGroup;
import org.eclipse.php.phpunit.ui.view.CounterPanel;
import org.eclipse.php.phpunit.ui.view.DiffTrace;
import org.eclipse.php.phpunit.ui.view.FailureTrace;
import org.eclipse.php.phpunit.ui.view.ProgressBar;
import org.eclipse.php.phpunit.ui.view.TestViewer;
import org.eclipse.php.phpunit.ui.view.actions.ScrollLockAction;
import org.eclipse.php.phpunit.ui.view.actions.ShowNextFailureAction;
import org.eclipse.php.phpunit.ui.view.actions.ShowPreviousFailureAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class PHPUnitView
extends ViewPart {
    public static final String NAME = "org.eclipse.php.phpunit.PHPUnitView";
    static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    private static PHPUnitView instance = null;
    boolean codeCoverageTabVisibile = false;
    final Image fCodeCoverageIcon = PHPUnitPlugin.createImage("obj16/cov_statistic_co.gif");
    Image fOriginalViewImage;
    final Image fStackViewIcon = PHPUnitPlugin.createImage("eview16/stackframe.png");
    final Image fDiffViewIcon = PHPUnitPlugin.createImage("eview16/diff.png");
    boolean running = false;
    protected boolean fAutoScroll = true;
    protected CounterPanel fCounterPanel;
    protected ProgressBar fProgressBar;
    private CTabFolder bottomTabFolder;
    private CTabItem codeCoverageTab;
    private CodeCoverageSection fCodeCoverageSection;
    private Action fCollapseAllAction;
    private Composite fCounterComposite;
    private int fCurrentOrientation;
    private Action fExpandAllAction;
    private Action fFailuresOnlyFilterAction;
    private DiffTrace fDiffTrace;
    private FailureTrace fFailureTrace;
    private boolean fIsDisposed = false;
    private Action fNextAction;
    private int fOrientation = 2;
    private Composite fParent;
    private Action fPreviousAction;
    private RerunLastAction fRerunLastTestAction;
    private SashForm fSashForm;
    private ScrollLockAction fScrollLockAction;
    private StopAction fStopAction;
    private TestViewer fTestViewer;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private PHPUnitTestGroup input;
    private ILaunch launch;
    private PHPUnitConnectionListener listener;
    private IProject project;

    public static synchronized void activateView(boolean focus) {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                IWorkbenchPage activePage = window.getActivePage();
                if (activePage == null) {
                    return;
                }
                try {
                    IViewPart foundView;
                    instance = focus ? (PHPUnitView)activePage.showView(NAME) : ((foundView = activePage.findView(NAME)) != null ? (PHPUnitView)foundView : (PHPUnitView)activePage.showView(NAME));
                }
                catch (PartInitException e) {
                    PHPUnitPlugin.log(e);
                }
            }
        });
    }

    public static PHPUnitView getDefault() {
        return instance;
    }

    public PHPUnitView() {
        if (instance == null) {
            instance = this;
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.addResizeListener(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.configureToolBar();
        this.fCounterComposite = this.createProgressCountPanel(parent);
        this.fCounterComposite.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(parent);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.fOriginalViewImage = this.getTitleImage();
    }

    public void handleTestSelected(PHPUnitElement testInfo) {
        if (testInfo == null) {
            this.showFailure(null);
        } else {
            this.showFailure(testInfo);
        }
    }

    public void processChangesInUI() {
        if (this.isDisposed()) {
            return;
        }
        this.refreshCounters();
        this.updateViewIcon();
        boolean hasErrorsOrFailures = false;
        if (this.input != null) {
            hasErrorsOrFailures = this.input.getStatus() > 1;
        }
        this.fNextAction.setEnabled(hasErrorsOrFailures);
        this.fPreviousAction.setEnabled(hasErrorsOrFailures);
        boolean empty = true;
        if (this.input != null && this.input.getRunCount() > 0) {
            empty = false;
        }
        this.fExpandAllAction.setEnabled(!empty);
        this.fCollapseAllAction.setEnabled(!empty);
        this.fTestViewer.processChangesInUI();
    }

    public void refresh(PHPUnitTestGroup root) {
        PHPUnitView.activateView(false);
        this.setInput(root);
        this.getSite().getShell().getDisplay().asyncExec(() -> {
            PHPUnitView view = PHPUnitView.getDefault();
            view.processChangesInUI();
        });
    }

    public void refreshCounters() {
        int totalCount = 0;
        int runCount = 0;
        int errorCount = 0;
        int failureCount = 0;
        if (this.input != null) {
            runCount = this.input.getRunCount();
            totalCount = this.input.getTotalCount();
            errorCount = this.input.getStatusCount(5);
            failureCount = this.input.getStatusCount(4);
            this.fCounterPanel.setTotal(totalCount);
            this.fCounterPanel.setRunValue(runCount);
            this.fCounterPanel.setErrorValue(errorCount);
            this.fCounterPanel.setFailureValue(failureCount);
            this.fProgressBar.setMaximum(totalCount);
            this.fProgressBar.step(errorCount + failureCount > 0, runCount);
        } else if (this.input == null || this.input.getTotalCount() == 0) {
            this.fCounterPanel.reset();
            this.fProgressBar.step(false, 0);
            this.fProgressBar.reset();
        }
    }

    public void rerunTest(int testId, ISourceModule sourceModule, String launchMode) {
        try {
            ILaunchConfiguration launchConfiguration = this.getLaunch().getLaunchConfiguration();
            if (launchConfiguration == null) {
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)PHPUnitMessages.PHPUnitView_Rerun_Error, (String)PHPUnitMessages.PHPUnitView_Rerun_Error_Message);
                return;
            }
            String name = sourceModule.getElementName();
            String configName = MessageFormat.format(PHPUnitMessages.PHPUnitView_Rerun_Config, name);
            ILaunchConfigurationWorkingCopy tmp = launchConfiguration.copy(configName);
            tmp.setAttribute("org.eclipse.php.phpunit.rerun", true);
            tmp.launch(launchMode, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)PHPUnitMessages.PHPUnitView_Cant_Rerun, (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    public void reset() {
        this.input = null;
        this.fTestViewer.registerActiveSession(null);
        this.fTestViewer.processChangesInUI();
        this.processChangesInUI();
    }

    public void selectNextFailure() {
        this.fTestViewer.selectFailure(true);
    }

    public void selectPreviousFailure() {
        this.fTestViewer.selectFailure(false);
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public void setCodeCoverageTabVisible(boolean visible) {
        Display.getDefault().asyncExec(() -> {
            if (!visible) {
                if (this.codeCoverageTab != null && !this.codeCoverageTab.isDisposed()) {
                    this.codeCoverageTab.dispose();
                }
            } else if (this.codeCoverageTab == null || this.codeCoverageTab.isDisposed()) {
                this.createCodeCoverageTab(this.bottomTabFolder);
            }
        });
        this.codeCoverageTabVisibile = visible;
    }

    public void setFocus() {
        if (this.fTestViewer != null) {
            this.fTestViewer.getTestViewerControl().setFocus();
        }
    }

    public void setInput(PHPUnitTestGroup newInput) {
        PHPUnitView view = PHPUnitView.getDefault();
        if (this.input != newInput) {
            this.input = newInput;
            view.fTestViewer.registerActiveSession(newInput);
        }
    }

    public void showCodeCoverage(CodeCoverageData[] coveredFiles) {
        if (this.codeCoverageTabVisibile) {
            this.getSite().getShell().getDisplay().asyncExec(() -> this.fCodeCoverageSection.showCodeCoverage(coveredFiles));
        }
    }

    public void startRunning(ILaunch launch, PHPUnitConnectionListener listener) {
        this.running = true;
        this.setLaunch(launch);
        this.listener = listener;
        Display.getDefault().asyncExec(() -> this.reset());
        this.fRerunLastTestAction.setEnabled(false);
        this.fStopAction.setEnabled(true);
    }

    public void stop(PHPUnitTestGroup root, String message) {
        instance.stopRunning(false);
        if (PHPUnitMessageParser.getInstance().isInProgress()) {
            PHPUnitView.instance.fProgressBar.stopped();
        }
        PHPUnitView.instance.fRerunLastTestAction.setEnabled(true);
        PHPUnitTestCase currentTestCase = PHPUnitMessageParser.getInstance().getCurrentTestCase();
        if (currentTestCase != null) {
            PHPUnitTestException.addAbnormalException(currentTestCase);
            this.fTestViewer.registerAutoScrollTarget(currentTestCase);
            this.fTestViewer.registerFailedForAutoScroll(currentTestCase);
        }
        this.refresh(root);
        if (root.getRunCount() == 0 && currentTestCase == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)this.getSite().getShell(), (String)PHPUnitMessages.PHPUnitWizard_Error_Title, (String)message));
        }
    }

    public void stopRunning(boolean terminateLaunch) {
        PHPUnitView.instance.fStopAction.setEnabled(false);
        this.listener.shutdown(terminateLaunch);
        if (this.input != null) {
            PHPUnitMessageParser.getInstance().setInProgress(false);
        }
        this.running = false;
    }

    void computeOrientation() {
        if (this.fOrientation != 2) {
            this.fCurrentOrientation = this.fOrientation;
            this.setOrientation(this.fCurrentOrientation);
        } else {
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    CTabItem createTraceTab(CTabFolder parent) {
        CTabItem traceTab = new CTabItem(parent, 0);
        traceTab.setText(PHPUnitMessages.PHPUnitView_Tab_Trace);
        traceTab.setImage(this.fStackViewIcon);
        ViewForm traceForm = new ViewForm((Composite)parent, 0);
        ToolBar failureToolBar = new ToolBar((Composite)traceForm, 0x800040);
        traceForm.setTopCenter((Control)failureToolBar);
        this.fFailureTrace = new FailureTrace((Composite)traceForm, this, failureToolBar);
        traceForm.setContent((Control)this.fFailureTrace.getComposite());
        traceTab.setControl((Control)traceForm);
        return traceTab;
    }

    CTabItem createDiffTab(CTabFolder parent) {
        CTabItem diffTab = new CTabItem(parent, 0);
        diffTab.setText(PHPUnitMessages.PHPUnitView_Tab_Diff);
        diffTab.setImage(this.fDiffViewIcon);
        ViewForm diffForm = new ViewForm((Composite)parent, 0);
        ToolBar failureToolBar = new ToolBar((Composite)diffForm, 0x800040);
        diffForm.setTopCenter((Control)failureToolBar);
        this.fDiffTrace = new DiffTrace((Composite)diffForm, this);
        diffForm.setContent((Control)this.fDiffTrace.getComposite());
        diffTab.setControl((Control)diffForm);
        return diffTab;
    }

    void setShowFailuresOnly(boolean failuresOnly) {
        this.setFilterAndLayout(failuresOnly);
    }

    protected void createBottomTabFolder(ViewForm parent) {
        this.bottomTabFolder = SWTUtil.createTabFolder((Composite)parent);
        parent.setContent((Control)this.bottomTabFolder);
        CTabItem traceTab = this.createTraceTab(this.bottomTabFolder);
        this.setCodeCoverageTabVisible(this.codeCoverageTabVisibile);
        this.bottomTabFolder.setSelection(traceTab);
    }

    protected CTabItem createCodeCoverageTab(CTabFolder parent) {
        this.codeCoverageTab = new CTabItem(parent, 0);
        this.codeCoverageTab.setText(PHPUnitMessages.PHPUnitView_Tab_Coverage);
        this.codeCoverageTab.setImage(this.fCodeCoverageIcon);
        ViewForm codeCoverageForm = this.createCodeCoverageForm((Composite)parent);
        this.codeCoverageTab.setControl((Control)codeCoverageForm);
        this.codeCoverageTab.addDisposeListener(e -> this.fCodeCoverageSection.dispose());
        return this.codeCoverageTab;
    }

    protected Composite createProgressCountPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setCounterColumns(layout);
        this.fCounterPanel = new CounterPanel(composite);
        this.fCounterPanel.setLayoutData(new GridData(768));
        this.fProgressBar = new ProgressBar(composite);
        this.fProgressBar.setLayoutData(new GridData(768));
        return composite;
    }

    protected void setLaunch(ILaunch launch) {
        this.launch = launch;
        try {
            String projectName = PHPUnitView.getDefault().getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.php.phpunit.project", null);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.project = workspaceRoot.getProject(projectName);
            String codeCoverageAttributeValue = launch.getAttribute("collectCodeCoverage");
            if (codeCoverageAttributeValue != null && !"profile".equals(launch.getLaunchMode())) {
                this.setCodeCoverageTabVisible(Integer.parseInt(codeCoverageAttributeValue) > 0);
            } else {
                this.setCodeCoverageTabVisible(false);
            }
            this.fRerunLastTestAction.setLaunch(launch);
        }
        catch (CoreException e) {
            PHPUnitPlugin.log(e);
        }
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PHPUnitView.this.computeOrientation();
            }
        });
    }

    private void configureToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fNextAction = new ShowNextFailureAction(this);
        this.fNextAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAction);
        this.fPreviousAction = new ShowPreviousFailureAction(this);
        this.fPreviousAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPreviousAction);
        this.fStopAction = new StopAction();
        this.fStopAction.setEnabled(false);
        this.fRerunLastTestAction = new RerunLastAction();
        this.fFailuresOnlyFilterAction = new FailuresOnlyFilterAction();
        this.fScrollLockAction = new ScrollLockAction(this);
        this.fScrollLockAction.setChecked(!this.fAutoScroll);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 2)};
        this.fExpandAllAction = new ExpandAllAction();
        this.fExpandAllAction.setEnabled(false);
        this.fCollapseAllAction = new CollapseAllAction();
        this.fCollapseAllAction.setEnabled(false);
        toolBar.add((IAction)this.fNextAction);
        toolBar.add((IAction)this.fPreviousAction);
        toolBar.add((IAction)this.fExpandAllAction);
        toolBar.add((IAction)this.fCollapseAllAction);
        toolBar.add((IAction)this.fFailuresOnlyFilterAction);
        toolBar.add((IAction)this.fScrollLockAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fRerunLastTestAction);
        toolBar.add((IAction)this.fStopAction);
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(PHPUnitMessages.PHPUnitView_Layout);
        ToggleOrientationAction[] toggleOrientationActionArray = this.fToggleOrientationActions;
        int n = this.fToggleOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleOrientationAction fToggleOrientationAction = toggleOrientationActionArray[n2];
            layoutSubMenu.add((IAction)fToggleOrientationAction);
            ++n2;
        }
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
        actionBars.updateActionBars();
    }

    private ViewForm createCodeCoverageForm(Composite parent) {
        ViewForm codeCoverageForm = new ViewForm(parent, 0);
        this.fCodeCoverageSection = new CodeCoverageSection((Composite)codeCoverageForm, (ViewPart)this, null);
        this.fCodeCoverageSection.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(parentElement instanceof IWorkspaceRoot) || !(element instanceof ISourceModule);
            }
        });
        codeCoverageForm.setContent(this.fCodeCoverageSection.getComposite());
        return codeCoverageForm;
    }

    private SashForm createSashForm(Composite parent) {
        this.fSashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)this.fSashForm, 0);
        Composite empty = new Composite((Composite)top, 0);
        empty.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(1, 1);
            }

            protected void layout(Composite composite, boolean flushCache) {
            }
        });
        top.setTopLeft((Control)empty);
        this.fTestViewer = new TestViewer((Composite)top, this);
        top.setContent(this.fTestViewer.getTestViewerControl());
        ViewForm bottom = new ViewForm((Composite)this.fSashForm, 0);
        this.createBottomTabFolder(bottom);
        this.fSashForm.setWeights(new int[]{50, 50});
        return this.fSashForm;
    }

    private void disposeImages() {
        this.fStackViewIcon.dispose();
        this.fCodeCoverageIcon.dispose();
    }

    private void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getSite().getShell().getDisplay().syncExec(r);
        }
    }

    private void setCounterColumns(GridLayout layout) {
        layout.numColumns = this.fCurrentOrientation == 1 ? 2 : 1;
    }

    private void setFilterAndLayout(boolean failuresOnly) {
        this.fFailuresOnlyFilterAction.setChecked(failuresOnly);
        this.fTestViewer.setShowFailuresOnly(failuresOnly);
    }

    private void setOrientation(int orientation) {
        if (this.fSashForm == null || this.fSashForm.isDisposed()) {
            return;
        }
        boolean horizontal = orientation == 1;
        this.fSashForm.setOrientation(horizontal ? 256 : 512);
        ToggleOrientationAction[] toggleOrientationActionArray = this.fToggleOrientationActions;
        int n = this.fToggleOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleOrientationAction fToggleOrientationAction;
            fToggleOrientationAction.setChecked(this.fOrientation == (fToggleOrientationAction = toggleOrientationActionArray[n2]).getOrientation());
            ++n2;
        }
        this.fCurrentOrientation = orientation;
        GridLayout layout = (GridLayout)this.fCounterComposite.getLayout();
        this.setCounterColumns(layout);
        this.fParent.layout();
    }

    private void showFailure(PHPUnitElement failure) {
        this.postSyncRunnable(() -> {
            if (!this.isDisposed()) {
                this.fDiffTrace.showFailure(failure);
                this.fFailureTrace.showFailure(failure);
            }
        });
    }

    private void updateViewIcon() {
        this.firePropertyChange(1);
    }

    public synchronized void dispose() {
        this.fIsDisposed = true;
        this.setInput(null);
        this.disposeImages();
    }

    public PHPUnitElement getTestElement(int testId) {
        if (testId != 0) {
            return null;
        }
        return PHPUnitElementManager.getInstance().findTest(testId);
    }

    public TestViewer getViewer() {
        return this.fTestViewer;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public boolean isDisposed() {
        return this.fIsDisposed || this.fCounterPanel.isDisposed();
    }

    public PHPUnitTestGroup getInput() {
        return this.input;
    }

    public synchronized ILaunch getLaunch() {
        return this.launch;
    }

    public IProject getProject() {
        return this.project;
    }

    private class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            this.setText(PHPUnitMessages.PHPUnitView_Collapse_Name);
            this.setToolTipText(PHPUnitMessages.PHPUnitView_Collapse_ToolTip);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_ELCL_COLLAPSEALL_DISABLED"));
            this.setHoverImageDescriptor(images.getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
            this.setImageDescriptor(images.getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
        }

        public void run() {
            PHPUnitView.this.fTestViewer.collapseAll();
        }
    }

    private class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setText(PHPUnitMessages.PHPUnitView_Expand_Name);
            this.setToolTipText(PHPUnitMessages.PHPUnitView_Expand_ToolTip);
            this.setDisabledImageDescriptor(PHPUnitPlugin.getImageDescriptor("dlcl16/expandall.png"));
            this.setHoverImageDescriptor(PHPUnitPlugin.getImageDescriptor("elcl16/expandall.png"));
            this.setImageDescriptor(PHPUnitPlugin.getImageDescriptor("elcl16/expandall.png"));
        }

        public void run() {
            PHPUnitView.this.fTestViewer.expandAll();
        }
    }

    private class FailuresOnlyFilterAction
    extends Action {
        public FailuresOnlyFilterAction() {
            super(PHPUnitMessages.PHPUnitView_Failures_Name, 2);
            this.setToolTipText(PHPUnitMessages.PHPUnitView_Failures_Tooltip);
            this.setImageDescriptor(PHPUnitPlugin.getImageDescriptor("obj16/failures.png"));
        }

        public void run() {
            PHPUnitView.this.setShowFailuresOnly(this.isChecked());
        }
    }

    public class RerunAction
    extends Action {
        protected ILaunchConfiguration fConfiguration;
        protected String fMode;
        private RerunLastAction fParent;

        public RerunAction(ILaunch launch, RerunLastAction parent) {
            if (launch != null) {
                this.fConfiguration = launch.getLaunchConfiguration();
                this.fMode = launch.getLaunchMode();
                this.setToolTipText(this.fConfiguration.getName());
                this.setText(this.fConfiguration.getName());
            }
            this.fParent = parent;
            this.setHoverImageDescriptor(PHPUnitPlugin.getImageDescriptor("elcl16/relaunch.png"));
            this.setImageDescriptor(PHPUnitPlugin.getImageDescriptor("elcl16/relaunch.png"));
        }

        public void run() {
            if (this.fConfiguration != null) {
                DebugUITools.launch((ILaunchConfiguration)this.fConfiguration, (String)this.fMode);
            }
            if (this.fParent != null) {
                this.fParent.setEnabled(false);
            }
        }
    }

    private class RerunLastAction
    extends RerunAction {
        private static final int HISTORY_DEPTH = 10;
        List<RerunAction> previousLaunches;

        public RerunLastAction() {
            super(null, null);
            this.previousLaunches = new ArrayList<RerunAction>();
            this.setToolTipText(PHPUnitMessages.PHPUnitView_Run_ToolTip);
            this.setEnabled(false);
            this.setMenuCreator(new IMenuCreator(){
                private Menu fMenu;

                public void dispose() {
                }

                public Menu getMenu(Control parent) {
                    if (this.fMenu != null) {
                        this.fMenu.dispose();
                    }
                    this.fMenu = new Menu(parent);
                    Iterator<RerunAction> iterator = RerunLastAction.this.previousLaunches.iterator();
                    while (iterator.hasNext()) {
                        RerunAction element;
                        RerunAction action = element = iterator.next();
                        ActionContributionItem item = new ActionContributionItem((IAction)action);
                        item.fill(this.fMenu, -1);
                    }
                    return this.fMenu;
                }

                public Menu getMenu(Menu parent) {
                    return null;
                }
            });
        }

        public void setLaunch(ILaunch launch) {
            this.fConfiguration = launch.getLaunchConfiguration();
            this.fMode = launch.getLaunchMode();
            int i = 0;
            while (i < this.previousLaunches.size()) {
                if (this.previousLaunches.get((int)i).fConfiguration.equals(this.fConfiguration)) {
                    this.previousLaunches.remove(i);
                    break;
                }
                ++i;
            }
            this.previousLaunches.add(0, new RerunAction(launch, this));
            i = 10;
            while (i < this.previousLaunches.size()) {
                this.previousLaunches.remove(i);
                ++i;
            }
        }
    }

    private class StopAction
    extends Action {
        public StopAction() {
            this.setText(PHPUnitMessages.PHPUnitView_Stop_Name);
            this.setToolTipText(PHPUnitMessages.PHPUnitView_Stop_ToolTip);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_ELCL_STOP_DISABLED"));
            this.setHoverImageDescriptor(images.getImageDescriptor("IMG_ELCL_STOP"));
            this.setImageDescriptor(images.getImageDescriptor("IMG_ELCL_STOP"));
        }

        public void run() {
            PHPUnitView.this.stopRunning(true);
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final int fActionOrientation;

        public ToggleOrientationAction(PHPUnitView v, int orientation) {
            super("", 8);
            if (orientation == 1) {
                this.setText(PHPUnitMessages.PHPUnitView_Orient_Horizont);
                this.setImageDescriptor(PHPUnitPlugin.getImageDescriptor("elcl16/th_horizontal.png"));
            } else if (orientation == 0) {
                this.setText(PHPUnitMessages.PHPUnitView_Orient_Vertical);
                this.setImageDescriptor(PHPUnitPlugin.getImageDescriptor("elcl16/th_vertical.png"));
            } else if (orientation == 2) {
                this.setText(PHPUnitMessages.PHPUnitView_Orient_Auto);
                this.setImageDescriptor(PHPUnitPlugin.getImageDescriptor("elcl16/th_automatic.png"));
            }
            this.fActionOrientation = orientation;
        }

        public int getOrientation() {
            return this.fActionOrientation;
        }

        public void run() {
            if (this.isChecked()) {
                PHPUnitView.this.fOrientation = this.fActionOrientation;
                PHPUnitView.this.computeOrientation();
            }
        }
    }
}

