/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.wizards.templates;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.php.phpunit.ui.wizards.templates.TestCaseTemplate;

public class TestCaseClassTemplate
extends TestCaseTemplate {
    private static final String METHOD_DYNAMIC_STRUCT = "DynamicMethod";
    private static final String METHOD_NAME = "MethodName";
    private static final String METHOD_NAME_CAMELIZED = "MethodNameCamelized";
    private static final String METHOD_STATIC_STRUCT = "StaticMethod";
    private static final String METHODS_STRUCT = "Methods";
    private static final String TEMPLATE_PATH = "resources/templates/ZendPHPUnitClassTest.tpl.php";
    private ArrayList<Method> methods;

    public void addMethod(String name, boolean isStatic) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        this.methods.add(new Method(name, isStatic));
    }

    public void compileMethods() {
        this.extract("input", METHODS_STRUCT, null);
        if (this.methods == null || this.methods.isEmpty()) {
            this.set(METHODS_STRUCT, "");
            return;
        }
        this.extract(METHODS_STRUCT, METHOD_DYNAMIC_STRUCT, null);
        this.extract(METHODS_STRUCT, METHOD_STATIC_STRUCT, null);
        this.set(METHODS_STRUCT, "");
        for (Method method : this.methods) {
            String methodName = method.getName();
            this.set(METHOD_NAME, methodName);
            this.set(METHOD_NAME_CAMELIZED, String.valueOf(methodName.substring(0, 1).toUpperCase()) + methodName.substring(1));
            this.compile(method.getIsStatic() ? METHOD_STATIC_STRUCT : METHOD_DYNAMIC_STRUCT, METHODS_STRUCT, true);
        }
    }

    @Override
    protected String getTemplatePath() {
        return TEMPLATE_PATH;
    }

    @Override
    public void setMasterElement(IModelElement masterElement, String masterElementName, IProject project) {
        this.set("MasterElementNameVar", String.valueOf(masterElementName.substring(0, 1).toLowerCase()) + masterElementName.substring(1));
        super.setMasterElement(masterElement, masterElementName, project);
    }

    private static class Method {
        protected boolean isStatic;
        protected String name;

        public Method(String name, boolean isStatic) {
            this.name = name;
            this.isStatic = isStatic;
        }

        public boolean equals(Object o) {
            if (o instanceof Method) {
                Method method = (Method)o;
                return this.name.equals(method.getName()) && this.isStatic == method.getIsStatic();
            }
            return false;
        }

        public boolean getIsStatic() {
            return this.isStatic;
        }

        public String getName() {
            return this.name;
        }
    }
}

