/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.data;

public class ProfilerCallTraceLayer {
    public static final int ENTER = 1;
    public static final int EXIT = 0;
    private static final int CONVERTION = 1000000;
    private int fType;
    private int fLineNumber;
    private int fCalledID;
    private int fTimestampSeconds;
    private int fTimestampMicroseconds;
    private int fDurationSecond = 0;
    private int fDurationMicrosecond = 0;

    public ProfilerCallTraceLayer() {
    }

    public ProfilerCallTraceLayer(int type, int lineNumber, int calledID, int timestampSeconds, int timestampMicroseconds) {
        this.setType(type);
        this.setLine(lineNumber);
        this.setCalledID(calledID);
        this.setTimestampSeconds(timestampSeconds);
        this.setTimestampMicroseconds(timestampMicroseconds);
    }

    public ProfilerCallTraceLayer(int type, int lineNumber, int calledID, int timestampSeconds, int timestampMicroseconds, int durationSeconds, int durationMicroSeconds) {
        this.setType(type);
        this.setLine(lineNumber);
        this.setCalledID(calledID);
        this.setTimestampSeconds(timestampSeconds);
        this.setTimestampMicroseconds(timestampMicroseconds);
        this.fDurationSecond = durationSeconds;
        this.fDurationMicrosecond = durationMicroSeconds;
    }

    public int getType() {
        return this.fType;
    }

    public void setType(int type) {
        this.fType = type;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getCalledID() {
        return this.fCalledID;
    }

    public int getTimestampSeconds() {
        return this.fTimestampSeconds;
    }

    public void setTimestampSeconds(int timestampSeconds) {
        this.fTimestampSeconds = timestampSeconds;
    }

    public int getTimestampMicroseconds() {
        return this.fTimestampMicroseconds;
    }

    public void setTimestampMicroseconds(int timestampMicroseconds) {
        this.fTimestampMicroseconds = timestampMicroseconds;
    }

    public int getDurationSeconds() {
        return this.fDurationSecond;
    }

    public double getDuration() {
        double duration = ((double)this.fDurationSecond * 1000000.0 + (double)this.fDurationMicrosecond) / 1000000.0;
        return duration;
    }

    public double getDurationInMilli() {
        return this.getDuration() * 1000.0;
    }

    public void setDuration(long exitTimeSeconds, long exitTimeMicroseconds) {
        long startSecond = this.fTimestampSeconds;
        long startMSecond = this.fTimestampMicroseconds;
        long startTime = startMSecond + startSecond * 1000000L;
        long endTime = exitTimeMicroseconds + exitTimeSeconds * 1000000L;
        int duration = (int)(endTime - startTime);
        this.fDurationSecond = duration / 1000000;
        this.fDurationMicrosecond = duration % 1000000;
    }

    public int getDurationMicroeconds() {
        return this.fDurationMicrosecond;
    }

    private void setLine(int lineNumber) {
        this.fLineNumber = lineNumber;
    }

    private void setCalledID(int calledID) {
        this.fCalledID = calledID;
    }
}

