/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.ui.refactoring.LanguageElementNode;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.refactoring.ui.RefactoringUIPlugin;
import org.eclipse.php.refactoring.ui.rename.ASTNodeImageProvider;
import org.eclipse.php.refactoring.ui.rename.ASTNodeLabels;
import org.eclipse.text.edits.TextEdit;

public class PHPRefactoringChangeNode
extends TextEditChangeNode {
    static final TextEditChangeNode.ChildNode[] EMPTY_CHILDREN = new TextEditChangeNode.ChildNode[0];

    public PHPRefactoringChangeNode(TextEditBasedChange change) {
        super(change);
    }

    protected TextEditChangeNode.ChildNode[] createChildNodes() {
        TextEditBasedChange change = this.getTextEditBasedChange();
        Program program = (Program)change.getAdapter(Program.class);
        if (program != null) {
            ArrayList children = new ArrayList(5);
            HashMap map = new HashMap(20);
            TextEditBasedChangeGroup[] changes = this.getSortedChangeGroups(change);
            int i = 0;
            while (i < changes.length) {
                TextEditBasedChangeGroup tec = changes[i];
                try {
                    ASTNode element = this.getModifiedPHPElement(tec, program);
                    this.addNode(program, children, map, tec, element);
                }
                catch (Exception e) {
                    RefactoringUIPlugin.log(e);
                }
                ++i;
            }
            return children.toArray(new TextEditChangeNode.ChildNode[children.size()]);
        }
        return EMPTY_CHILDREN;
    }

    private void addNode(Program program, List children, Map map, TextEditBasedChangeGroup tec, ASTNode element) {
        if (element.getType() == 46) {
            children.add(PHPRefactoringChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)tec));
        } else {
            PHPLanguageNode pjce = this.getChangeElement(map, element, children, this);
            pjce.addChild(PHPRefactoringChangeNode.createTextEditGroupNode((TextEditChangeNode.ChildNode)pjce, (TextEditBasedChangeGroup)tec));
        }
    }

    private TextEditBasedChangeGroup[] getSortedChangeGroups(TextEditBasedChange change) {
        TextEditBasedChangeGroup[] edits = change.getChangeGroups();
        ArrayList<TextEditBasedChangeGroup> result = new ArrayList<TextEditBasedChangeGroup>(edits.length);
        int i = 0;
        while (i < edits.length) {
            if (!edits[i].getTextEditGroup().isEmpty()) {
                result.add(edits[i]);
            }
            ++i;
        }
        OffsetComparator comparator = new OffsetComparator();
        Collections.sort(result, comparator);
        return result.toArray(new TextEditBasedChangeGroup[result.size()]);
    }

    private ASTNode getModifiedPHPElement(TextEditBasedChangeGroup edit, Program program) throws Exception {
        IRegion range = edit.getRegion();
        if (range.getOffset() == 0 && range.getLength() == 0) {
            return program;
        }
        ASTNode result = program.getElementAt(range.getOffset());
        if (result == null) {
            return program;
        }
        return this.getParentContext(result);
    }

    private PHPLanguageNode getChangeElement(Map map, ASTNode element, List children, TextEditChangeNode cunitChange) {
        PHPLanguageNode result = (PHPLanguageNode)((Object)map.get(element));
        if (result != null) {
            return result;
        }
        int type = element.getType();
        if (type == 12 || type == 40 || type == 29) {
            result = new PHPLanguageNode(cunitChange, element);
            children.add(result);
            map.put(element, result);
        } else {
            assert (element.getType() == 42);
            ASTNode parentNode = this.getParentContext(element);
            PHPLanguageNode parentChange = this.getChangeElement(map, parentNode, children, cunitChange);
            result = new PHPLanguageNode((TextEditChangeNode.ChildNode)parentChange, element);
            parentChange.addChild((TextEditChangeNode.ChildNode)result);
            map.put(element, result);
        }
        return result;
    }

    private ASTNode getParentContext(ASTNode element) {
        element = element.getParent();
        switch (element.getType()) {
            case 12: 
            case 40: 
            case 42: 
            case 46: {
                return element;
            }
            case 29: {
                if (element.getParent().getType() == 42) {
                    return element.getParent();
                }
                return element;
            }
        }
        return this.getParentContext(element);
    }

    private boolean coveredBy(TextEditBasedChangeGroup group, IRegion sourceRegion) {
        int sLength = sourceRegion.getLength();
        if (sLength == 0) {
            return false;
        }
        int sOffset = sourceRegion.getOffset();
        int sEnd = sOffset + sLength - 1;
        TextEdit[] edits = group.getTextEdits();
        int i = 0;
        while (i < edits.length) {
            TextEdit edit = edits[i];
            if (edit.isDeleted()) {
                return false;
            }
            int rOffset = edit.getOffset();
            int rLength = edit.getLength();
            int rEnd = rOffset + rLength - 1;
            if (rLength == 0 ? sOffset >= rOffset || rOffset > sEnd : sOffset > rOffset || rEnd > sEnd) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class OffsetComparator
    implements Comparator {
        private OffsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int p2;
            TextEditBasedChangeGroup c1 = (TextEditBasedChangeGroup)o1;
            TextEditBasedChangeGroup c2 = (TextEditBasedChangeGroup)o2;
            int p1 = this.getOffset(c1);
            if (p1 < (p2 = this.getOffset(c2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextEditBasedChangeGroup edit) {
            return edit.getRegion().getOffset();
        }
    }

    private static class PHPLanguageNode
    extends LanguageElementNode {
        private ASTNode fphpElement;
        private static final ASTNodeImageProvider fgImageProvider = new ASTNodeImageProvider();

        public PHPLanguageNode(TextEditChangeNode parent, ASTNode element) {
            super(parent);
            this.fphpElement = element;
            Assert.isNotNull((Object)this.fphpElement);
        }

        public PHPLanguageNode(TextEditChangeNode.ChildNode parent, ASTNode element) {
            super(parent);
            assert (element != null);
            this.fphpElement = element;
        }

        public String getText() {
            return ASTNodeLabels.getElementLabel(this.fphpElement, 3L);
        }

        public ImageDescriptor getImageDescriptor() {
            return fgImageProvider.getPHPImageDescriptor(this.fphpElement, 3);
        }

        public IRegion getTextRange() throws CoreException {
            return new Region(this.fphpElement.getStart(), this.fphpElement.getLength());
        }
    }
}

