/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptCopyProcessor;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptMoveProcessor;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.internal.ui.scriptview.SelectionTransferDropAdapter;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.internal.ui.actions.ReorgMoveAction;
import org.eclipse.php.internal.ui.util.ReorgPolicyFactory;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PHPSelectionTransferDropAdapter
extends SelectionTransferDropAdapter {
    private List<Object> fElements;
    private ScriptMoveProcessor fMoveProcessor;
    private int fCanMoveElements;
    private ScriptCopyProcessor fCopyProcessor;
    private int fCanCopyElements;
    private ISelection fSelection;
    private static final long DROP_TIME_DIFF_TRESHOLD = 150L;

    public PHPSelectionTransferDropAdapter(StructuredViewer viewer) {
        super(viewer);
    }

    public boolean performDrop(Object data) {
        try {
            switch (this.getCurrentOperation()) {
                case 2: {
                    this.handleDropMove(this.getCurrentTarget());
                    break;
                }
                case 1: {
                    this.handleDropCopy(this.getCurrentTarget());
                }
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), (String)ScriptMessages.SelectionTransferDropAdapter_error_title, (String)ScriptMessages.SelectionTransferDropAdapter_error_message);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    private void handleDropMove(Object target) throws ModelException, InvocationTargetException, InterruptedException {
        List elements = ((IStructuredSelection)this.getSelection()).toList();
        Object[] resources = this.getResources(elements);
        ReorgMoveAction action = new ReorgMoveAction();
        action.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        StructuredSelection selection = new StructuredSelection(resources);
        action.selectionChanged(null, (ISelection)selection);
        Object targetContainer = target;
        if (targetContainer instanceof IModelElement) {
            targetContainer = this.getResource((IModelElement)target);
        }
        if (targetContainer instanceof IContainer) {
            action.setTarget((IContainer)targetContainer);
        } else if (targetContainer instanceof IResource) {
            action.setTarget(((IResource)targetContainer).getParent());
        }
        action.run((IAction)null);
    }

    private void handleDropCopy(Object target) throws ModelException, InvocationTargetException, InterruptedException {
        List elements = ((IStructuredSelection)this.getSelection()).toList();
        IModelElement[] modelElements = ReorgUtils.getModelElements((List)elements);
        IResource[] resources = this.getResources(modelElements);
        ReorgCopyStarter starter = null;
        if (target instanceof IModelElement) {
            starter = ReorgCopyStarter.create((IModelElement[])modelElements, (IResource[])resources, (IModelElement)((IModelElement)target));
        } else if (target instanceof IResource) {
            starter = ReorgCopyStarter.create((IModelElement[])modelElements, (IResource[])resources, (IResource)((IResource)target));
        }
        if (starter != null) {
            starter.run(this.getViewer().getControl().getShell());
        }
    }

    public IResource[] getResources(IModelElement[] elements) {
        ArrayList<IResource> resultArray = new ArrayList<IResource>();
        int i = 0;
        while (i < elements.length) {
            IResource res = this.getResource(elements[i]);
            if (res != null) {
                resultArray.add(res);
            }
            ++i;
        }
        return resultArray.toArray(new IResource[resultArray.size()]);
    }

    public IResource getResource(IModelElement element) {
        if (element instanceof ISourceModule) {
            return ((ISourceModule)element).getPrimary().getResource();
        }
        return element.getResource();
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getTransfer();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof IModelElement || target instanceof IResource;
    }

    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.setSelectionFeedbackEnabled(false);
        this.fElements = null;
        this.fSelection = null;
        this.fMoveProcessor = null;
        this.fCanMoveElements = 0;
        this.fCopyProcessor = null;
        this.fCanCopyElements = 0;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return this.determineOperation(target, operation, transferType, 7) != 0;
    }

    protected int determineOperation(Object target, int operation, TransferData transferType, int operations) {
        int result = this.internalDetermineOperation(target, operation, operations);
        if (result == 0) {
            this.setSelectionFeedbackEnabled(false);
        } else {
            this.setSelectionFeedbackEnabled(true);
        }
        return result;
    }

    private int internalDetermineOperation(Object target, int operation, int operations) {
        IResource targetResource;
        this.initializeSelection();
        if (target == null) {
            return 0;
        }
        IResource[] resources = this.getResources(this.fElements);
        if (this.getCurrentLocation() == 3) {
            IModelElement[] javaElements = ReorgUtils.getModelElements(this.fElements);
            if (this.contains(javaElements, target)) {
                return 0;
            }
            if (this.contains(resources, target)) {
                return 0;
            }
        }
        if (target instanceof IModelElement && (targetResource = ReorgUtils.getResource((IModelElement)((IModelElement)target))) instanceof IContainer && PHPSelectionTransferDropAdapter.isParentOfAny((IContainer)targetResource, resources)) {
            return 0;
        }
        try {
            switch (operation) {
                case 16: {
                    return this.handleValidateDefault(target, operations);
                }
                case 1: {
                    return this.handleValidateCopy(target);
                }
                case 2: {
                    return this.handleValidateMove(target);
                }
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), (String)ScriptMessages.SelectionTransferDropAdapter_error_title, (String)ScriptMessages.SelectionTransferDropAdapter_error_message);
        }
        return 0;
    }

    private static boolean isParentOfAny(IContainer container, IResource[] roots) {
        int i = 0;
        while (i < roots.length) {
            if (ReorgUtils.isParentInWorkspaceOrOnDisk((IResource)roots[i], (IResource)container)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IResource[] getResources(List elements) {
        ArrayList<IResource> resources = new ArrayList<IResource>(elements.size());
        for (Object element : elements) {
            if (element instanceof IResource) {
                resources.add((IResource)element);
            }
            if (!(element instanceof IModelElement)) continue;
            resources.add(((IModelElement)element).getResource());
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private boolean contains(IResource[] resources, Object target) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null && resources[i].equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean contains(IModelElement[] elements, Object target) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            this.fSelection = StructuredSelection.EMPTY;
            this.fElements = Collections.EMPTY_LIST;
            return;
        }
        this.fSelection = s;
        this.fElements = ((IStructuredSelection)s).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    private int handleValidateDefault(Object target, int operations) throws ModelException {
        int result;
        if ((operations & 2) != 0 && (result = this.handleValidateMove(target)) != 0) {
            return result;
        }
        return this.handleValidateCopy(target);
    }

    private int handleValidateMove(Object target) throws ModelException {
        IReorgPolicy.IMovePolicy policy;
        if (this.fMoveProcessor == null && (policy = ReorgPolicyFactory.createMovePolicy(this.getResources(this.fElements), ReorgUtils.getModelElements(this.fElements))).canEnable()) {
            this.fMoveProcessor = new ScriptMoveProcessor(policy);
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        if (this.fMoveProcessor == null) {
            return 0;
        }
        if (target instanceof IModelElement && !this.fMoveProcessor.setDestination((IModelElement)target).isOK()) {
            return 0;
        }
        if (target instanceof IResource && !this.fMoveProcessor.setDestination((IResource)target).isOK()) {
            return 0;
        }
        return 2;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (this.fMoveProcessor == null) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private int handleValidateCopy(Object target) throws ModelException {
        if (this.fCopyProcessor == null) {
            IReorgPolicy.ICopyPolicy policy = ReorgPolicyFactory.createCopyPolicy(this.getResources(this.fElements), ReorgUtils.getModelElements(this.fElements));
            ScriptCopyProcessor scriptCopyProcessor = this.fCopyProcessor = policy.canEnable() ? new ScriptCopyProcessor(policy) : null;
        }
        if (!this.canCopyElements()) {
            return 0;
        }
        if (this.fCopyProcessor == null) {
            return 0;
        }
        if (target instanceof IModelElement && !this.fCopyProcessor.setDestination((IModelElement)target).isOK()) {
            return 0;
        }
        if (target instanceof IResource && !this.fCopyProcessor.setDestination((IResource)target).isOK()) {
            return 0;
        }
        return 1;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (this.fCopyProcessor == null) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    protected int getCurrentLocation() {
        if (this.getFeedbackEnabled()) {
            return super.getCurrentLocation();
        }
        return 3;
    }
}

