/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.php.internal.ui.text.correction.ICommandAccess;
import org.eclipse.php.internal.ui.text.correction.PHPCorrectionProcessor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.wst.sse.ui.StructuredTextInvocationContext;

public class CorrectionCommandHandler
extends AbstractHandler {
    private static final PHPCorrectionProcessor phpCorrectionProcessor = new PHPCorrectionProcessor();

    public CorrectionCommandHandler() {
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
        PHPStructuredEditor editor = (PHPStructuredEditor)context.getVariable("activePart");
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        StructuredTextInvocationContext assistInvocation = new StructuredTextInvocationContext(editor.getViewer(), selection.getOffset(), selection.getLength(), new HashMap());
        ICompletionProposal[] proposals = phpCorrectionProcessor.computeQuickAssistProposals((IQuickAssistInvocationContext)assistInvocation);
        if (proposals == null || proposals.length == 0) {
            return null;
        }
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICommandAccess command;
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (proposal instanceof ICommandAccess && (command = (ICommandAccess)proposal).getCommandId() != null && command.getCommandId().equals(commandId)) {
                this.runProposal(editor, proposal, assistInvocation);
                return null;
            }
            ++n2;
        }
        return null;
    }

    private void runProposal(PHPStructuredEditor editor, ICompletionProposal proposal, StructuredTextInvocationContext context) {
        if (proposal instanceof ICompletionProposalExtension2) {
            ((ICompletionProposalExtension2)proposal).apply((ITextViewer)editor.getTextViewer(), '\u0000', 0, context.getOffset());
        } else if (proposal instanceof ICompletionProposalExtension && editor.getDocument() != null) {
            ((ICompletionProposalExtension)proposal).apply(editor.getDocument(), '\u0000', context.getOffset());
        } else {
            proposal.apply(editor.getDocument());
        }
    }

    public void setEnabled(Object evaluationContext) {
        try {
            IEvaluationContext context = (IEvaluationContext)evaluationContext;
            if (!(context.getVariable("activePart") instanceof PHPStructuredEditor)) {
                this.setBaseEnabled(false);
                return;
            }
            PHPStructuredEditor editor = (PHPStructuredEditor)context.getVariable("activePart");
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (!(selection instanceof ITextSelection)) {
                this.setBaseEnabled(false);
                return;
            }
            int offset = ((ITextSelection)selection).getOffset();
            ITypedRegion partition = editor.getDocument().getPartition(offset);
            this.setBaseEnabled(partition.getType().equals("org.eclipse.php.PHP_DEFAULT"));
            return;
        }
        catch (IllegalArgumentException context) {
        }
        catch (BadLocationException e) {
            PHPUiPlugin.log(e);
        }
        this.setBaseEnabled(false);
    }

    public static String getShortcut(String commandId) {
        TriggerSequence trigger;
        IBindingService keys = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (commandId != null && keys != null && (trigger = keys.getBestActiveBindingFor(commandId)) != null && trigger.getTriggers().length > 0) {
            return trigger.format();
        }
        return null;
    }

    public static String appendShortcut(String name, String commandId) {
        String shortcut;
        if (commandId != null && commandId.isEmpty() && (shortcut = CorrectionCommandHandler.getShortcut(commandId)) != null) {
            return NLS.bind((String)CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, (Object[])new String[]{name, shortcut});
        }
        return name;
    }

    public static StyledString styleWithShortcut(String name, String commandId) {
        StyledString str = new StyledString(name);
        if (commandId != null && !commandId.isEmpty()) {
            String keys = CorrectionCommandHandler.getShortcut(commandId);
            if (keys == null) {
                return str;
            }
            String decorated = NLS.bind((String)CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, (Object[])new String[]{name, keys});
            return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)str);
        }
        return str;
    }
}

