/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.model.ComposerBuildpathContainer;
import org.eclipse.php.composer.core.model.ModelAccess;
import org.eclipse.php.composer.core.model.PackageManager;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.project.PHPVersionChangedHandler;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.internal.core.util.project.observer.ProjectRemovedObserversAttacher;

public class ComposerBuildpathContainerInitializer
extends BuildpathContainerInitializer {
    public static final String CONTAINER = "org.eclipse.php.composer.core.CONTAINER";
    private Map<IProject, IPreferencesPropagatorListener> project2PhpVerListener = new HashMap<IProject, IPreferencesPropagatorListener>();

    public void initialize(IPath containerPath, IScriptProject scriptProject) throws CoreException {
        if (containerPath.segmentCount() > 0 && containerPath.segment(0).equals(CONTAINER) && ComposerPlugin.getDefault().isBuildpathContainerEnabled()) {
            try {
                if (ComposerBuildpathContainerInitializer.isPHPProject(scriptProject)) {
                    DLTKCore.setBuildpathContainer((IPath)containerPath, (IScriptProject[])new IScriptProject[]{scriptProject}, (IBuildpathContainer[])new IBuildpathContainer[]{new ComposerBuildpathContainer(containerPath, scriptProject)}, null);
                    this.initializeListener(containerPath, scriptProject);
                }
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
            }
        }
    }

    private void initializeListener(final IPath containerPath, final IScriptProject scriptProject) {
        final IProject project = scriptProject.getProject();
        if (this.project2PhpVerListener.containsKey(project)) {
            return;
        }
        IPreferencesPropagatorListener versionChangeListener = new IPreferencesPropagatorListener(){

            public void preferencesEventOccured(PreferencesPropagatorEvent event) {
                try {
                    ComposerBuildpathContainerInitializer.this.initialize(containerPath, scriptProject);
                }
                catch (CoreException e) {
                    Logger.logException((Throwable)e);
                }
            }

            public IProject getProject() {
                return project;
            }
        };
        this.project2PhpVerListener.put(project, versionChangeListener);
        PHPVersionChangedHandler.getInstance().addPHPVersionChangedListener(versionChangeListener);
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(project, new IProjectClosedObserver(){

            public void closed() {
                PHPVersionChangedHandler.getInstance().removePHPVersionChangedListener((IPreferencesPropagatorListener)ComposerBuildpathContainerInitializer.this.project2PhpVerListener.get(project));
                ComposerBuildpathContainerInitializer.this.project2PhpVerListener.remove(project);
            }
        });
    }

    private static boolean isPHPProject(IScriptProject project) {
        String nature = ComposerBuildpathContainerInitializer.getNatureFromProject(project);
        return "org.eclipse.php.core.PHPNature".equals(nature);
    }

    private static String getNatureFromProject(IScriptProject project) {
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
        if (languageToolkit != null) {
            return languageToolkit.getNatureId();
        }
        return null;
    }

    public void requestBuildpathContainerUpdate(IPath containerPath, IScriptProject project, IBuildpathContainer containerSuggestion) {
        if (this.isComposerContainer(containerPath)) {
            String name = containerPath.segment(1);
            if (containerSuggestion != null) {
                PackageManager manager = ModelAccess.getInstance().getPackageManager();
                if (manager.getPackage(name) == null) {
                    return;
                }
                manager.setPackage(name, containerSuggestion.getBuildpathEntries(), containerSuggestion.getKind() == 2);
            } else {
                ModelAccess.getInstance().getPackageManager().removePackage(name);
            }
        }
    }

    private boolean isComposerContainer(IPath path) {
        return path != null && CONTAINER.equals(path.segment(0));
    }

    public boolean canUpdateBuildpathContainer(IPath containerPath, IScriptProject project) {
        return this.isComposerContainer(containerPath);
    }
}

