/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class IfStatement
extends Statement {
    private Expression condition;
    private Statement trueStatement;
    private Statement falseStatement;
    public static final ChildPropertyDescriptor CONDITION_PROPERTY = new ChildPropertyDescriptor(IfStatement.class, "condition", Expression.class, true, true);
    public static final ChildPropertyDescriptor TRUE_STATEMENT_PROPERTY = new ChildPropertyDescriptor(IfStatement.class, "trueStatement", Statement.class, true, true);
    public static final ChildPropertyDescriptor FALSE_STATEMENT_PROPERTY = new ChildPropertyDescriptor(IfStatement.class, "falseStatement", Statement.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> list = new ArrayList<ChildPropertyDescriptor>(3);
        list.add(CONDITION_PROPERTY);
        list.add(TRUE_STATEMENT_PROPERTY);
        list.add(FALSE_STATEMENT_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(list);
    }

    public IfStatement(int start, int end, AST ast, Expression condition, Statement trueStatement, Statement falseStatement) {
        super(start, end, ast);
        if (condition == null || trueStatement == null) {
            throw new IllegalArgumentException();
        }
        this.setCondition(condition);
        this.setTrueStatement(trueStatement);
        if (falseStatement != null) {
            this.setFalseStatement(falseStatement);
        }
    }

    public IfStatement(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.condition.accept(visitor);
        this.trueStatement.accept(visitor);
        if (this.falseStatement != null) {
            this.falseStatement.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.condition.traverseTopDown(visitor);
        this.trueStatement.traverseTopDown(visitor);
        if (this.falseStatement != null) {
            this.falseStatement.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.condition.traverseBottomUp(visitor);
        this.trueStatement.traverseBottomUp(visitor);
        if (this.falseStatement != null) {
            this.falseStatement.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<IfStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Condition>\n");
        this.condition.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</Condition>\n");
        buffer.append("\t").append(tab).append("<TrueStatement>\n");
        this.trueStatement.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</TrueStatement>\n");
        buffer.append("\t").append(tab).append("<FalseStatement>\n");
        if (this.falseStatement != null) {
            this.falseStatement.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</FalseStatement>\n");
        buffer.append(tab).append("</IfStatement>");
    }

    @Override
    public int getType() {
        return 34;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.condition;
        this.preReplaceChild(oldChild, expression, CONDITION_PROPERTY);
        this.condition = expression;
        this.postReplaceChild(oldChild, expression, CONDITION_PROPERTY);
    }

    public Statement getTrueStatement() {
        return this.trueStatement;
    }

    public void setTrueStatement(Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException();
        }
        Statement oldChild = this.trueStatement;
        this.preReplaceChild(oldChild, statement, TRUE_STATEMENT_PROPERTY);
        this.trueStatement = statement;
        this.postReplaceChild(oldChild, statement, TRUE_STATEMENT_PROPERTY);
    }

    public Statement getFalseStatement() {
        return this.falseStatement;
    }

    public void setFalseStatement(Statement statement) {
        Statement oldChild = this.falseStatement;
        this.preReplaceChild(oldChild, statement, FALSE_STATEMENT_PROPERTY);
        this.falseStatement = statement;
        this.postReplaceChild(oldChild, statement, FALSE_STATEMENT_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression condition = ASTNode.copySubtree(target, this.getCondition());
        Statement trueStatement = ASTNode.copySubtree(target, this.getTrueStatement());
        Statement falseStatement = ASTNode.copySubtree(target, this.getFalseStatement());
        IfStatement result = new IfStatement(this.getStart(), this.getEnd(), target, condition, trueStatement, falseStatement);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == CONDITION_PROPERTY) {
            if (get) {
                return this.getCondition();
            }
            this.setCondition((Expression)child);
            return null;
        }
        if (property == TRUE_STATEMENT_PROPERTY) {
            if (get) {
                return this.getTrueStatement();
            }
            this.setTrueStatement((Statement)child);
            return null;
        }
        if (property == FALSE_STATEMENT_PROPERTY) {
            if (get) {
                return this.getFalseStatement();
            }
            this.setFalseStatement((Statement)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }
}

