/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.builder;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.builder.AbstractBuildParticipantType;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.compiler.ast.visitor.ValidatorVisitor;

public class ValidatorBuildParticipantFactory
extends AbstractBuildParticipantType
implements IExecutableExtension {
    private String natureId = null;

    public IBuildParticipant createBuildParticipant(IScriptProject project) throws CoreException {
        if (this.natureId != null) {
            return new ParserBuildParticipant();
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.natureId = config.getAttribute("nature");
    }

    private static class ParserBuildParticipant
    implements IBuildParticipant {
        private ParserBuildParticipant() {
        }

        public void build(IBuildContext context) throws CoreException {
            if (!this.isValidatorEnabled(context)) {
                return;
            }
            try {
                ModelManager.getModelManager().getIndexManager().waitUntilReady();
                ModuleDeclaration moduleDeclaration = this.getModuleDeclaration(context);
                if (moduleDeclaration != null) {
                    moduleDeclaration.traverse((ASTVisitor)new ValidatorVisitor(context));
                }
            }
            catch (Exception e) {
                PHPCorePlugin.log(e);
            }
        }

        private ModuleDeclaration getModuleDeclaration(IBuildContext context) {
            ModuleDeclaration moduleDeclaration = (ModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
            if (moduleDeclaration == null) {
                ISourceModuleInfoCache.ISourceModuleInfo cacheEntry = ModelManager.getModelManager().getSourceModuleInfoCache().get(context.getSourceModule());
                moduleDeclaration = SourceParserUtil.getModuleFromCache((ISourceModuleInfoCache.ISourceModuleInfo)cacheEntry, (IProblemReporter)context.getProblemReporter());
            }
            return moduleDeclaration;
        }

        private boolean isValidatorEnabled(IBuildContext context) throws CoreException {
            return !Boolean.TRUE.equals(context.get("IN_LIBRARY_FOLDER"));
        }
    }
}

